/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtLightSourceElement;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtPsiSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0015"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/syntax/FirLocalVariableTypeParametersSyntaxChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "<init>", "()V", "isApplicable", "", "element", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "checkPsi", "", "Lksp/org/jetbrains/kotlin/KtPsiSourceElement;", "psi", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkLightTree", "Lksp/org/jetbrains/kotlin/KtLightSourceElement;", "checkers"})
public final class FirLocalVariableTypeParametersSyntaxChecker
extends FirDeclarationSyntaxChecker<FirProperty, KtExpression> {
    @NotNull
    public static final FirLocalVariableTypeParametersSyntaxChecker INSTANCE = new FirLocalVariableTypeParametersSyntaxChecker();

    private FirLocalVariableTypeParametersSyntaxChecker() {
    }

    @Override
    public boolean isApplicable(@NotNull FirProperty element2, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return !(source.getKind() instanceof KtFakeSourceElementKind) && element2.isLocal();
    }

    @Override
    public void checkPsi(@NotNull FirProperty element2, @NotNull KtPsiSourceElement source, @NotNull KtExpression psi, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (psi instanceof KtProperty && ((KtProperty)psi).getTypeParameterList() != null) {
            KtDiagnosticFactory0 diagnostic = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitTypeParametersForLocalVariables) ? FirErrors.INSTANCE.getLOCAL_VARIABLE_WITH_TYPE_PARAMETERS() : FirErrors.INSTANCE.getLOCAL_VARIABLE_WITH_TYPE_PARAMETERS_WARNING();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, diagnostic, (DiagnosticContext)context2, null, 8, null);
        }
    }

    @Override
    public void checkLightTree(@NotNull FirProperty element2, @NotNull KtLightSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            LighterASTNode node = source.getLighterASTNode();
            if (!Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.PROPERTY)) {
                return;
            }
            if (LightTreePositioningStrategiesKt.typeParametersList(source.getTreeStructure(), source.getLighterASTNode()) == null) break block1;
            boolean bl = false;
            KtDiagnosticFactory0 diagnostic = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitTypeParametersForLocalVariables) ? FirErrors.INSTANCE.getLOCAL_VARIABLE_WITH_TYPE_PARAMETERS() : FirErrors.INSTANCE.getLOCAL_VARIABLE_WITH_TYPE_PARAMETERS_WARNING();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, diagnostic, (DiagnosticContext)context2, null, 8, null);
        }
    }
}

