/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.cfg;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.cfg.WhenExhaustivenessChecker;
import ksp.org.jetbrains.kotlin.cfg.WhenOnNullableExhaustivenessChecker;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtWhenCondition;
import ksp.org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import ksp.org.jetbrains.kotlin.psi.KtWhenEntry;
import ksp.org.jetbrains.kotlin.psi.KtWhenExpression;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/cfg/WhenOnBooleanExhaustivenessChecker;", "Lksp/org/jetbrains/kotlin/cfg/WhenExhaustivenessChecker;", "<init>", "()V", "getMissingCases", "", "Lksp/org/jetbrains/kotlin/diagnostics/WhenMissingCase;", "expression", "Lksp/org/jetbrains/kotlin/psi/KtWhenExpression;", "context", "Lksp/org/jetbrains/kotlin/resolve/BindingContext;", "subjectDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/ClassDescriptor;", "nullable", "", "isApplicable", "subjectType", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "frontend"})
final class WhenOnBooleanExhaustivenessChecker
implements WhenExhaustivenessChecker {
    @NotNull
    public static final WhenOnBooleanExhaustivenessChecker INSTANCE = new WhenOnBooleanExhaustivenessChecker();

    private WhenOnBooleanExhaustivenessChecker() {
    }

    @Override
    @NotNull
    public List<WhenMissingCase> getMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2, @Nullable ClassDescriptor subjectDescriptor, boolean nullable) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        boolean containsFalse = false;
        boolean containsTrue = false;
        for (KtWhenEntry whenEntry : expression2.getEntries()) {
            for (KtWhenCondition whenCondition : whenEntry.getConditions()) {
                if (!(whenCondition instanceof KtWhenConditionWithExpression)) continue;
                KtExpression whenExpression = ((KtWhenConditionWithExpression)whenCondition).getExpression();
                if (CompileTimeConstantUtils.canBeReducedToBooleanConstant(whenExpression, context2, true)) {
                    containsTrue = true;
                }
                if (!CompileTimeConstantUtils.canBeReducedToBooleanConstant(whenExpression, context2, false)) continue;
                containsFalse = true;
            }
        }
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)(!containsTrue ? CollectionsKt.listOf((Object)WhenMissingCase.BooleanIsMissing.TrueIsMissing.INSTANCE) : CollectionsKt.emptyList()), (Iterable)(!containsFalse ? CollectionsKt.listOf((Object)WhenMissingCase.BooleanIsMissing.FalseIsMissing.INSTANCE) : CollectionsKt.emptyList())), (Iterable)WhenOnNullableExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context2, nullable));
    }

    @Override
    public boolean isApplicable(@NotNull KotlinType subjectType) {
        Intrinsics.checkNotNullParameter((Object)subjectType, (String)"subjectType");
        return KotlinBuiltIns.isBoolean(TypeUtils.makeNotNullable(subjectType));
    }
}

