/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.lower.InnerClassesSupport;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import ksp.org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import ksp.org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import ksp.org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFactory;
import ksp.org.jetbrains.kotlin.ir.declarations.IrField;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import ksp.org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/JvmInnerClassesSupport;", "Lksp/org/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "irFactory", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFactory;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrFactory;)V", "outerThisDeclarations", "Ljava/util/concurrent/ConcurrentHashMap;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrField;", "innerClassConstructors", "Lksp/org/jetbrains/kotlin/ir/declarations/IrConstructor;", "originalInnerClassPrimaryConstructorByClass", "getOuterThisField", "innerClass", "getInnerClassConstructorWithOuterThisParameter", "innerClassConstructor", "getInnerClassOriginalPrimaryConstructorOrNull", "createInnerClassConstructorWithOuterThisParameter", "oldConstructor", "backend.jvm"})
@SourceDebugExtension(value={"SMAP\nJvmInnerClassesSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmInnerClassesSupport.kt\norg/jetbrains/kotlin/backend/jvm/JvmInnerClassesSupport\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n72#2,2:77\n72#2,2:85\n1#3:79\n1#3:84\n1#3:87\n74#4,4:80\n283#4,4:88\n343#4,4:92\n1557#5:96\n1628#5,3:97\n*S KotlinDebug\n*F\n+ 1 JvmInnerClassesSupport.kt\norg/jetbrains/kotlin/backend/jvm/JvmInnerClassesSupport\n*L\n25#1:77,2\n42#1:85,2\n25#1:84\n42#1:87\n27#1:80,4\n58#1:88,4\n67#1:92,4\n72#1:96\n72#1:97,3\n*E\n"})
public final class JvmInnerClassesSupport
implements InnerClassesSupport {
    @NotNull
    private final IrFactory irFactory;
    @NotNull
    private final ConcurrentHashMap<IrClass, IrField> outerThisDeclarations;
    @NotNull
    private final ConcurrentHashMap<IrConstructor, IrConstructor> innerClassConstructors;
    @NotNull
    private final ConcurrentHashMap<IrClass, IrConstructor> originalInnerClassPrimaryConstructorByClass;

    public JvmInnerClassesSupport(@NotNull IrFactory irFactory) {
        Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
        this.irFactory = irFactory;
        this.outerThisDeclarations = new ConcurrentHashMap();
        this.innerClassConstructors = new ConcurrentHashMap();
        this.originalInnerClassPrimaryConstructorByClass = new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public IrField getOuterThisField(@NotNull IrClass innerClass) {
        Intrinsics.checkNotNullParameter((Object)innerClass, (String)"innerClass");
        ConcurrentMap $this$getOrPut$iv = this.outerThisDeclarations;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(innerClass);
        if (object == null) {
            IrField irField;
            boolean bl = false;
            boolean bl2 = innerClass.isInner();
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-JvmInnerClassesSupport$getOuterThisField$1$22 = false;
                String $i$a$-assert-JvmInnerClassesSupport$getOuterThisField$1$22 = "Class is not inner: " + DumpIrTreeKt.dump$default(innerClass, null, 1, null);
                throw new AssertionError((Object)$i$a$-assert-JvmInnerClassesSupport$getOuterThisField$1$22);
            }
            IrFactory $this$buildField$iv = this.irFactory;
            boolean $i$f$buildField = false;
            IrFieldBuilder $this$buildField_u24lambda_u244$iv = new IrFieldBuilder();
            boolean bl3 = false;
            IrFieldBuilder $this$getOuterThisField_u24lambda_u243_u24lambda_u241 = $this$buildField_u24lambda_u244$iv;
            boolean bl4 = false;
            $this$getOuterThisField_u24lambda_u243_u24lambda_u241.setName(Name.identifier("this$0"));
            $this$getOuterThisField_u24lambda_u243_u24lambda_u241.setType(IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(innerClass)));
            $this$getOuterThisField_u24lambda_u243_u24lambda_u241.setOrigin(IrDeclarationOrigin.Companion.getFIELD_FOR_OUTER_THIS());
            $this$getOuterThisField_u24lambda_u243_u24lambda_u241.setVisibility(JavaDescriptorVisibilities.PACKAGE_VISIBILITY);
            $this$getOuterThisField_u24lambda_u243_u24lambda_u241.setFinal(true);
            IrField $this$getOuterThisField_u24lambda_u243_u24lambda_u242 = irField = DeclarationBuildersKt.buildField($this$buildField$iv, $this$buildField_u24lambda_u244$iv);
            boolean bl5 = false;
            $this$getOuterThisField_u24lambda_u243_u24lambda_u242.setParent(innerClass);
            IrField default$iv = irField;
            boolean bl6 = false;
            object = $this$getOrPut$iv.putIfAbsent(innerClass, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (IrField)object;
    }

    @Override
    @NotNull
    public IrConstructor getInnerClassConstructorWithOuterThisParameter(@NotNull IrConstructor innerClassConstructor) {
        Intrinsics.checkNotNullParameter((Object)innerClassConstructor, (String)"innerClassConstructor");
        IrDeclarationParent irDeclarationParent = innerClassConstructor.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrClass innerClass = (IrClass)irDeclarationParent;
        boolean bl = innerClass.isInner();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JvmInnerClassesSupport$getInnerClassConstructorWithOuterThisParameter$22 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Class is not inner: ");
            IrDeclarationParent irDeclarationParent2 = innerClassConstructor.getParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            String $i$a$-assert-JvmInnerClassesSupport$getInnerClassConstructorWithOuterThisParameter$22 = stringBuilder.append(DumpIrTreeKt.dump$default((IrClass)irDeclarationParent2, null, 1, null)).toString();
            throw new AssertionError((Object)$i$a$-assert-JvmInnerClassesSupport$getInnerClassConstructorWithOuterThisParameter$22);
        }
        ConcurrentMap $this$getOrPut$iv = this.innerClassConstructors;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(innerClassConstructor);
        if (object == null) {
            boolean bl2 = false;
            IrConstructor default$iv = this.createInnerClassConstructorWithOuterThisParameter(innerClassConstructor);
            boolean bl3 = false;
            object = $this$getOrPut$iv.putIfAbsent(innerClassConstructor, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Object v = object;
        IrConstructor it = (IrConstructor)v;
        boolean bl4 = false;
        if (innerClassConstructor.isPrimary()) {
            ((Map)this.originalInnerClassPrimaryConstructorByClass).put(innerClass, innerClassConstructor);
        }
        Object v2 = v;
        Intrinsics.checkNotNullExpressionValue(v2, (String)"also(...)");
        return (IrConstructor)v2;
    }

    @Override
    @Nullable
    public IrConstructor getInnerClassOriginalPrimaryConstructorOrNull(@NotNull IrClass innerClass) {
        Intrinsics.checkNotNullParameter((Object)innerClass, (String)"innerClass");
        boolean bl = innerClass.isInner();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Class is not inner: " + innerClass;
            throw new AssertionError((Object)string2);
        }
        return this.originalInnerClassPrimaryConstructorByClass.get(innerClass);
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor createInnerClassConstructorWithOuterThisParameter(IrConstructor oldConstructor) {
        Collection<IrValueParameter> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrConstructor irConstructor;
        IrFactory $this$buildConstructor$iv = this.irFactory;
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2424$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u248 = $this$buildConstructor_u24lambda_u2424$iv;
        boolean bl2 = false;
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u248.updateFrom(oldConstructor);
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u248.setReturnType(oldConstructor.getReturnType());
        IrConstructor $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2411 = irConstructor = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv, $this$buildConstructor_u24lambda_u2424$iv);
        boolean bl3 = false;
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2411.setParent(oldConstructor.getParent());
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2411.setReturnType(oldConstructor.getReturnType());
        IrUtilsKt.copyAnnotationsFrom($this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2411, oldConstructor);
        IrUtilsKt.copyTypeParametersFrom$default($this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2411, oldConstructor, null, null, 6, null);
        boolean $i$f$buildValueParameter22 = false;
        IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2430$iv = new IrValueParameterBuilder();
        boolean $i$a$-run-DeclarationBuildersKt$buildValueParameter$2$iv22 = false;
        IrValueParameterBuilder $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2411_u24lambda_u249 = $this$buildValueParameter_u24lambda_u2430$iv;
        boolean bl4 = false;
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2411_u24lambda_u249.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getFIELD_FOR_OUTER_THIS());
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2411_u24lambda_u249.setName(Name.identifier("this$0"));
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2411_u24lambda_u249.setType(IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(IrUtilsKt.getParentAsClass(oldConstructor))));
        IrValueParameter outerThisValueParameter = DeclarationBuildersKt.buildValueParameter(((IrDeclaration)$this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2411).getFactory(), $this$buildValueParameter_u24lambda_u2430$iv, (IrDeclarationParent)((Object)((IrDeclaration)$this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2411)));
        Iterable $i$f$buildValueParameter22 = oldConstructor.getValueParameters();
        Collection collection2 = CollectionsKt.listOf((Object)outerThisValueParameter);
        IrConstructor irConstructor2 = $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2411;
        boolean $i$f$map = false;
        void $i$a$-run-DeclarationBuildersKt$buildValueParameter$2$iv22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(IrUtilsKt.copyTo$default((IrValueParameter)it, $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2411, null, 0, 0, null, null, null, null, null, false, false, false, 4094, null));
        }
        collection = (List)destination$iv$iv;
        irConstructor2.setValueParameters(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2411.setMetadata(oldConstructor.getMetadata());
        return irConstructor;
    }
}

