/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.CommonBackendContext;
import ksp.org.jetbrains.kotlin.backend.common.FileLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import ksp.org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import ksp.org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrField;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrScript;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrVariable;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBlock;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBranch;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBreak;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCatch;
import ksp.org.jetbrains.kotlin.ir.expressions.IrClassReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrComposite;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConst;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstKind;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrContinue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import ksp.org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetClass;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetField;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import ksp.org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrLoop;
import ksp.org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrReturn;
import ksp.org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSetField;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSetValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import ksp.org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrThrow;
import ksp.org.jetbrains.kotlin.ir.expressions.IrTry;
import ksp.org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrVararg;
import ksp.org.jetbrains.kotlin.ir.expressions.IrWhen;
import ksp.org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import ksp.org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;

@PhaseDescription(name="FlattenStringConcatenationLowering", description="Flatten nested string concatenation expressions into a single IrStringConcatenation")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\f\u0010\u0010\u001a\u00020\u000e*\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/lower/FlattenStringConcatenationLowering;", "Lksp/org/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lksp/org/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lksp/org/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "lower", "", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "visitExpression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "tryToFold", "Lksp/org/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "constToString", "", "const", "Lksp/org/jetbrains/kotlin/ir/expressions/IrConst;", "normalizeUnsignedValue", "", "Companion", "ir.backend.common"})
public final class FlattenStringConcatenationLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private static final Set<FqName> PARENT_NAMES;

    public FlattenStringConcatenationLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitExpression(@NotNull IrExpression expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (FlattenStringConcatenationLowering.Companion.isStringConcatenationExpression(expression2) || expression2 instanceof IrCall && FlattenStringConcatenationLowering.Companion.isSpecialToStringCall((IrCall)expression2)) {
            IrExpression $this$visitExpression_u24lambda_u240 = expression2;
            boolean bl = false;
            irExpression = this.tryToFold(BuildersKt.IrStringConcatenationImpl($this$visitExpression_u24lambda_u240.getStartOffset(), $this$visitExpression_u24lambda_u240.getEndOffset(), $this$visitExpression_u24lambda_u240.getType(), FlattenStringConcatenationLowering.Companion.collectStringConcatenationArguments($this$visitExpression_u24lambda_u240)));
        } else {
            irExpression = expression2;
        }
        IrExpression transformedExpression = irExpression;
        IrElementTransformerVoidKt.transformChildrenVoid(transformedExpression, this);
        return transformedExpression;
    }

    private final IrExpression tryToFold(IrStringConcatenation $this$tryToFold) {
        List folded = new ArrayList();
        for (IrExpression next2 : $this$tryToFold.getArguments()) {
            IrExpression last = (IrExpression)CollectionsKt.lastOrNull((List)folded);
            if (!(next2 instanceof IrConst)) {
                ((Collection)folded).add(next2);
                continue;
            }
            if (!(last instanceof IrConst)) {
                ((Collection)folded).add(IrConstImpl.Companion.string(next2.getStartOffset(), next2.getEndOffset(), this.context.getIrBuiltIns().getStringType(), this.constToString((IrConst)next2)));
                continue;
            }
            folded.set(folded.size() - 1, IrConstImpl.Companion.string(Math.min(((IrConst)last).getStartOffset(), next2.getStartOffset()), Math.max(((IrConst)last).getEndOffset(), next2.getEndOffset()), this.context.getIrBuiltIns().getStringType(), this.constToString((IrConst)last) + this.constToString((IrConst)next2)));
        }
        Object object = CollectionsKt.singleOrNull((List)folded);
        IrConst irConst = object instanceof IrConst ? (IrConst)object : null;
        return irConst != null ? (IrExpression)irConst : (IrExpression)BuildersKt.IrStringConcatenationImpl($this$tryToFold.getStartOffset(), $this$tryToFold.getEndOffset(), $this$tryToFold.getType(), folded);
    }

    private final String constToString(IrConst irConst) {
        return String.valueOf(this.normalizeUnsignedValue(irConst));
    }

    private final Object normalizeUnsignedValue(IrConst irConst) {
        if (IrTypeUtilsKt.isUnsigned(irConst.getType())) {
            IrConstKind kind = irConst.getKind();
            if (kind instanceof IrConstKind.Byte) {
                Object object = irConst.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Byte");
                return UByte.box-impl((byte)UByte.constructor-impl((byte)((Byte)object)));
            }
            if (kind instanceof IrConstKind.Short) {
                Object object = irConst.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Short");
                return UShort.box-impl((short)UShort.constructor-impl((short)((Short)object)));
            }
            if (kind instanceof IrConstKind.Int) {
                Object object = irConst.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                return UInt.box-impl((int)UInt.constructor-impl((int)((Integer)object)));
            }
            if (kind instanceof IrConstKind.Long) {
                Object object = irConst.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
                return ULong.box-impl((long)ULong.constructor-impl((long)((Long)object)));
            }
        }
        return irConst.getValue();
    }

    static {
        Object[] objectArray = new FqName[]{StandardNames.BUILT_INS_PACKAGE_FQ_NAME, StandardNames.FqNames.string.toSafe()};
        PARENT_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\nR\u0015\u0010\u000b\u001a\u00020\b*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0018\u0010\u000e\u001a\u00020\b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u0018\u0010\u000f\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0018\u0010\u0010\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u0016"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/lower/FlattenStringConcatenationLowering$Companion;", "", "<init>", "()V", "PARENT_NAMES", "", "Lksp/org/jetbrains/kotlin/name/FqName;", "isStringPlusCall", "", "Lksp/org/jetbrains/kotlin/ir/expressions/IrCall;", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Z", "isToString", "Lksp/org/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Z", "isNullableToString", "isToStringCall", "isSpecialToStringCall", "isStringConcatenationExpression", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "collectStringConcatenationArguments", "", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isStringPlusCall(IrCall $this$isStringPlusCall) {
            IrValueParameter receiverParameter;
            IrSimpleFunction function2 = (IrSimpleFunction)$this$isStringPlusCall.getSymbol().getOwner();
            IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
            if (irValueParameter == null) {
                irValueParameter = function2.getExtensionReceiverParameter();
            }
            if ((receiverParameter = irValueParameter) == null) return false;
            if (!IrTypePredicatesKt.isStringClassType(receiverParameter.getType())) return false;
            if (!IrTypePredicatesKt.isStringClassType(function2.getReturnType())) return false;
            if (function2.getValueParameters().size() != 1) return false;
            if (!Intrinsics.areEqual((Object)function2.getName(), (Object)OperatorNameConventions.PLUS)) return false;
            FqName fqName = IrUtilsKt.getFqNameWhenAvailable(function2);
            if (!CollectionsKt.contains((Iterable)PARENT_NAMES, (Object)(fqName != null ? fqName.parent() : null))) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isToString(@NotNull IrSimpleFunction $this$isToString) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)$this$isToString, (String)"<this>");
            if (!Intrinsics.areEqual((Object)$this$isToString.getName(), (Object)OperatorNameConventions.TO_STRING)) return false;
            if (!((Collection)$this$isToString.getValueParameters()).isEmpty()) {
                return false;
            }
            boolean bl2 = false;
            if (bl2) return false;
            if (!IrTypePredicatesKt.isString($this$isToString.getReturnType())) {
                return false;
            }
            if ($this$isToString.getDispatchReceiverParameter() == null) return false;
            if ($this$isToString.getExtensionReceiverParameter() != null) return false;
            IrAnnotationContainer irAnnotationContainer = $this$isToString.getDispatchReceiverParameter();
            if (irAnnotationContainer != null && (irAnnotationContainer = irAnnotationContainer.getType()) != null) {
                if (IrTypePredicatesKt.isAny((IrType)irAnnotationContainer)) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if (((Collection)$this$isToString.getOverriddenSymbols()).isEmpty()) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isNullableToString(IrSimpleFunction $this$isNullableToString) {
            if (!Intrinsics.areEqual((Object)$this$isNullableToString.getName(), (Object)OperatorNameConventions.TO_STRING)) return false;
            if (!((Collection)$this$isNullableToString.getValueParameters()).isEmpty()) {
                return false;
            }
            boolean bl = false;
            if (bl) return false;
            if (!IrTypePredicatesKt.isString($this$isNullableToString.getReturnType())) {
                return false;
            }
            if ($this$isNullableToString.getDispatchReceiverParameter() != null) return false;
            IrValueParameter irValueParameter = $this$isNullableToString.getExtensionReceiverParameter();
            IrAnnotationContainer irAnnotationContainer = irValueParameter;
            if (irValueParameter == null) return false;
            IrType irType = irAnnotationContainer.getType();
            irAnnotationContainer = irType;
            if (irType == null) return false;
            if (!IrTypePredicatesKt.isNullableAny((IrType)irAnnotationContainer)) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            FqName fqName = IrUtilsKt.getFqNameWhenAvailable($this$isNullableToString);
            if (!Intrinsics.areEqual((Object)(fqName != null ? fqName.parent() : null), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME)) return false;
            return true;
        }

        private final boolean isToStringCall(IrCall $this$isToStringCall) {
            if ($this$isToStringCall.getSuperQualifierSymbol() != null) {
                return false;
            }
            IrSimpleFunction function2 = (IrSimpleFunction)$this$isToStringCall.getSymbol().getOwner();
            return this.isToString(function2) || this.isNullableToString(function2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isSpecialToStringCall(IrCall $this$isSpecialToStringCall) {
            if (!this.isToStringCall($this$isSpecialToStringCall)) return false;
            IrExpression irExpression = $this$isSpecialToStringCall.getDispatchReceiver();
            Object object = irExpression;
            if (irExpression == null) return true;
            IrType irType = ((IrExpression)object).getType();
            object = irType;
            if (irType == null) return true;
            if (IrTypePredicatesKt.isPrimitiveType$default((IrType)object, false, 1, null)) return true;
            return false;
        }

        private final boolean isStringConcatenationExpression(IrExpression expression2) {
            return expression2 instanceof IrStringConcatenation || expression2 instanceof IrCall && this.isStringPlusCall((IrCall)expression2);
        }

        private final List<IrExpression> collectStringConcatenationArguments(IrExpression expression2) {
            List arguments2 = new ArrayList();
            IrVisitorsKt.acceptChildrenVoid(expression2, new IrElementVisitorVoid(arguments2){
                final /* synthetic */ List<IrExpression> $arguments;
                {
                    this.$arguments = $arguments;
                }

                public void visitElement(IrElement element2) {
                    Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                    IrVisitorsKt.acceptChildrenVoid(element2, this);
                }

                public void visitCall(IrCall expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    if (ksp.org.jetbrains.kotlin.backend.common.lower.FlattenStringConcatenationLowering$Companion.access$isStringConcatenationExpression(FlattenStringConcatenationLowering.Companion, expression2) || ksp.org.jetbrains.kotlin.backend.common.lower.FlattenStringConcatenationLowering$Companion.access$isToStringCall(FlattenStringConcatenationLowering.Companion, expression2)) {
                        IrVisitorsKt.acceptChildrenVoid(expression2, this);
                    } else {
                        this.$arguments.add(expression2);
                    }
                }

                public void visitStringConcatenation(IrStringConcatenation expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrVisitorsKt.acceptChildrenVoid(expression2, this);
                }

                public void visitExpression(IrExpression expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    this.$arguments.add(expression2);
                }

                public void visitElement(IrElement element2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitElement(this, element2, data);
                }

                public void visitDeclaration(IrDeclarationBase declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
                }

                public void visitDeclaration(IrDeclarationBase declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
                }

                public void visitValueParameter(IrValueParameter declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
                }

                public void visitValueParameter(IrValueParameter declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
                }

                public void visitClass(IrClass declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
                }

                public void visitClass(IrClass declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
                }

                public void visitAnonymousInitializer(IrAnonymousInitializer declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
                }

                public void visitAnonymousInitializer(IrAnonymousInitializer declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
                }

                public void visitTypeParameter(IrTypeParameter declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
                }

                public void visitTypeParameter(IrTypeParameter declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
                }

                public void visitFunction(IrFunction declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
                }

                public void visitFunction(IrFunction declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
                }

                public void visitConstructor(IrConstructor declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
                }

                public void visitConstructor(IrConstructor declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
                }

                public void visitEnumEntry(IrEnumEntry declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
                }

                public void visitEnumEntry(IrEnumEntry declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
                }

                public void visitErrorDeclaration(IrErrorDeclaration declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
                }

                public void visitErrorDeclaration(IrErrorDeclaration declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
                }

                public void visitField(IrField declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
                }

                public void visitField(IrField declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
                }

                public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
                }

                public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
                }

                public void visitModuleFragment(IrModuleFragment declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
                }

                public void visitModuleFragment(IrModuleFragment declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
                }

                public void visitProperty(IrProperty declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
                }

                public void visitProperty(IrProperty declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
                }

                public void visitScript(IrScript declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data);
                }

                public void visitScript(IrScript declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
                }

                public void visitSimpleFunction(IrSimpleFunction declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
                }

                public void visitSimpleFunction(IrSimpleFunction declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
                }

                public void visitTypeAlias(IrTypeAlias declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data);
                }

                public void visitTypeAlias(IrTypeAlias declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
                }

                public void visitVariable(IrVariable declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
                }

                public void visitVariable(IrVariable declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
                }

                public void visitPackageFragment(IrPackageFragment declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
                }

                public void visitPackageFragment(IrPackageFragment declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
                }

                public void visitExternalPackageFragment(IrExternalPackageFragment declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
                }

                public void visitExternalPackageFragment(IrExternalPackageFragment declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
                }

                public void visitFile(IrFile declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
                }

                public void visitFile(IrFile declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
                }

                public void visitExpression(IrExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
                }

                public void visitBody(IrBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
                }

                public void visitBody(IrBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
                }

                public void visitExpressionBody(IrExpressionBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
                }

                public void visitExpressionBody(IrExpressionBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
                }

                public void visitBlockBody(IrBlockBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
                }

                public void visitBlockBody(IrBlockBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
                }

                public void visitDeclarationReference(IrDeclarationReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
                }

                public void visitDeclarationReference(IrDeclarationReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
                }

                public void visitMemberAccess(IrMemberAccessExpression<?> expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
                }

                public void visitMemberAccess(IrMemberAccessExpression<?> expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
                }

                public void visitFunctionAccess(IrFunctionAccessExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
                }

                public void visitFunctionAccess(IrFunctionAccessExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
                }

                public void visitConstructorCall(IrConstructorCall expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
                }

                public void visitConstructorCall(IrConstructorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
                }

                public void visitSingletonReference(IrGetSingletonValue expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
                }

                public void visitSingletonReference(IrGetSingletonValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
                }

                public void visitGetObjectValue(IrGetObjectValue expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
                }

                public void visitGetObjectValue(IrGetObjectValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
                }

                public void visitGetEnumValue(IrGetEnumValue expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
                }

                public void visitGetEnumValue(IrGetEnumValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
                }

                public void visitRawFunctionReference(IrRawFunctionReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
                }

                public void visitRawFunctionReference(IrRawFunctionReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
                }

                public void visitContainerExpression(IrContainerExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
                }

                public void visitContainerExpression(IrContainerExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
                }

                public void visitBlock(IrBlock expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
                }

                public void visitBlock(IrBlock expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
                }

                public void visitComposite(IrComposite expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
                }

                public void visitComposite(IrComposite expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
                }

                public void visitReturnableBlock(IrReturnableBlock expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2, data);
                }

                public void visitReturnableBlock(IrReturnableBlock expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2);
                }

                public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
                }

                public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock) {
                    IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock);
                }

                public void visitSyntheticBody(IrSyntheticBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
                }

                public void visitSyntheticBody(IrSyntheticBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
                }

                public void visitBreakContinue(IrBreakContinue jump, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
                }

                public void visitBreakContinue(IrBreakContinue jump) {
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
                }

                public void visitBreak(IrBreak jump, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
                }

                public void visitBreak(IrBreak jump) {
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
                }

                public void visitContinue(IrContinue jump, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
                }

                public void visitContinue(IrContinue jump) {
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
                }

                public void visitCall(IrCall expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
                }

                public void visitCallableReference(IrCallableReference<?> expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
                }

                public void visitCallableReference(IrCallableReference<?> expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
                }

                public void visitFunctionReference(IrFunctionReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
                }

                public void visitFunctionReference(IrFunctionReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
                }

                public void visitPropertyReference(IrPropertyReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
                }

                public void visitPropertyReference(IrPropertyReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
                }

                public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
                }

                public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
                }

                public void visitClassReference(IrClassReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
                }

                public void visitClassReference(IrClassReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
                }

                public void visitConst(IrConst expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
                }

                public void visitConst(IrConst expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
                }

                public void visitConstantValue(IrConstantValue expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data);
                }

                public void visitConstantValue(IrConstantValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
                }

                public void visitConstantPrimitive(IrConstantPrimitive expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data);
                }

                public void visitConstantPrimitive(IrConstantPrimitive expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
                }

                public void visitConstantObject(IrConstantObject expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data);
                }

                public void visitConstantObject(IrConstantObject expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
                }

                public void visitConstantArray(IrConstantArray expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data);
                }

                public void visitConstantArray(IrConstantArray expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
                }

                public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
                }

                public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
                }

                public void visitDynamicExpression(IrDynamicExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
                }

                public void visitDynamicExpression(IrDynamicExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
                }

                public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
                }

                public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
                }

                public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
                }

                public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
                }

                public void visitEnumConstructorCall(IrEnumConstructorCall expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
                }

                public void visitEnumConstructorCall(IrEnumConstructorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
                }

                public void visitErrorExpression(IrErrorExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
                }

                public void visitErrorExpression(IrErrorExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
                }

                public void visitErrorCallExpression(IrErrorCallExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
                }

                public void visitErrorCallExpression(IrErrorCallExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
                }

                public void visitFieldAccess(IrFieldAccessExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
                }

                public void visitFieldAccess(IrFieldAccessExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
                }

                public void visitGetField(IrGetField expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
                }

                public void visitGetField(IrGetField expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
                }

                public void visitSetField(IrSetField expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
                }

                public void visitSetField(IrSetField expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
                }

                public void visitFunctionExpression(IrFunctionExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
                }

                public void visitFunctionExpression(IrFunctionExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
                }

                public void visitGetClass(IrGetClass expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
                }

                public void visitGetClass(IrGetClass expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
                }

                public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
                }

                public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
                }

                public void visitLoop(IrLoop loop, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop, data);
                }

                public void visitLoop(IrLoop loop) {
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop);
                }

                public void visitWhileLoop(IrWhileLoop loop, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop, data);
                }

                public void visitWhileLoop(IrWhileLoop loop) {
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop);
                }

                public void visitDoWhileLoop(IrDoWhileLoop loop, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop, data);
                }

                public void visitDoWhileLoop(IrDoWhileLoop loop) {
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop);
                }

                public void visitReturn(IrReturn expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
                }

                public void visitReturn(IrReturn expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
                }

                public void visitStringConcatenation(IrStringConcatenation expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
                }

                public void visitSuspensionPoint(IrSuspensionPoint expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
                }

                public void visitSuspensionPoint(IrSuspensionPoint expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
                }

                public void visitSuspendableExpression(IrSuspendableExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
                }

                public void visitSuspendableExpression(IrSuspendableExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
                }

                public void visitThrow(IrThrow expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
                }

                public void visitThrow(IrThrow expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
                }

                public void visitTry(IrTry aTry, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
                }

                public void visitTry(IrTry aTry) {
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
                }

                public void visitCatch(IrCatch aCatch, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
                }

                public void visitCatch(IrCatch aCatch) {
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
                }

                public void visitTypeOperator(IrTypeOperatorCall expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
                }

                public void visitTypeOperator(IrTypeOperatorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
                }

                public void visitValueAccess(IrValueAccessExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
                }

                public void visitValueAccess(IrValueAccessExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
                }

                public void visitGetValue(IrGetValue expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
                }

                public void visitGetValue(IrGetValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
                }

                public void visitSetValue(IrSetValue expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
                }

                public void visitSetValue(IrSetValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
                }

                public void visitVararg(IrVararg expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
                }

                public void visitVararg(IrVararg expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
                }

                public void visitSpreadElement(IrSpreadElement spread, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
                }

                public void visitSpreadElement(IrSpreadElement spread) {
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
                }

                public void visitWhen(IrWhen expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
                }

                public void visitWhen(IrWhen expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
                }

                public void visitBranch(IrBranch branch, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
                }

                public void visitBranch(IrBranch branch) {
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
                }

                public void visitElseBranch(IrElseBranch branch, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
                }

                public void visitElseBranch(IrElseBranch branch) {
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
                }
            });
            return arguments2;
        }

        public static final /* synthetic */ boolean access$isToStringCall(Companion $this, IrCall $receiver) {
            return $this.isToStringCall($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

