/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file;

import java.io.InputStream;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file.DirectoryBasedClassFinderKt;
import ksp.org.jetbrains.kotlin.load.java.structure.JavaClass;
import ksp.org.jetbrains.kotlin.load.java.structure.JavaElementsKt;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import ksp.org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder;", "Lksp/org/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "packageDirectory", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "directoryPackageFqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/FqName;)V", "getPackageDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getDirectoryPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "findKotlinClassOrContent", "Lksp/org/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "javaClass", "Lksp/org/jetbrains/kotlin/load/java/structure/JavaClass;", "jvmMetadataVersion", "Lksp/org/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "classId", "Lksp/org/jetbrains/kotlin/name/ClassId;", "findMetadata", "Ljava/io/InputStream;", "findMetadataTopLevelClassesInPackage", "", "", "packageFqName", "hasMetadataPackage", "", "fqName", "findBuiltInsData", "decompiler-to-file-stubs"})
@SourceDebugExtension(value={"SMAP\nDirectoryBasedClassFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryBasedClassFinder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class DirectoryBasedClassFinder
implements KotlinClassFinder {
    @NotNull
    private final VirtualFile packageDirectory;
    @NotNull
    private final FqName directoryPackageFqName;

    public DirectoryBasedClassFinder(@NotNull VirtualFile packageDirectory, @NotNull FqName directoryPackageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageDirectory, (String)"packageDirectory");
        Intrinsics.checkNotNullParameter((Object)directoryPackageFqName, (String)"directoryPackageFqName");
        this.packageDirectory = packageDirectory;
        this.directoryPackageFqName = directoryPackageFqName;
    }

    @NotNull
    public final VirtualFile getPackageDirectory() {
        return this.packageDirectory;
    }

    @NotNull
    public final FqName getDirectoryPackageFqName() {
        return this.directoryPackageFqName;
    }

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull JavaClass javaClass, @NotNull JvmMetadataVersion jvmMetadataVersion) {
        Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
        Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"jvmMetadataVersion");
        ClassId classId = JavaElementsKt.getClassId(javaClass);
        Intrinsics.checkNotNull((Object)classId);
        return this.findKotlinClassOrContent(classId, jvmMetadataVersion);
    }

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull ClassId classId, @NotNull JvmMetadataVersion jvmMetadataVersion) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"jvmMetadataVersion");
        if (!Intrinsics.areEqual((Object)classId.getPackageFqName(), (Object)this.directoryPackageFqName)) {
            return null;
        }
        String targetName = CollectionsKt.joinToString$default((Iterable)classId.getRelativeClassName().pathSegments(), (CharSequence)"$", null, (CharSequence)".class", (int)0, null, null, (int)58, null);
        VirtualFile virtualFile = this.packageDirectory.findChild(targetName);
        if (virtualFile != null && DirectoryBasedClassFinderKt.access$isKotlinWithCompatibleAbiVersion(virtualFile, jvmMetadataVersion)) {
            KotlinClassFinder.Result.KotlinClass kotlinClass;
            KotlinJvmBinaryClass kotlinJvmBinaryClass = ClsKotlinBinaryClassCache.getKotlinBinaryClass$default(ClsKotlinBinaryClassCache.Companion.getInstance(), virtualFile, null, 2, null);
            if (kotlinJvmBinaryClass != null) {
                KotlinJvmBinaryClass p0 = kotlinJvmBinaryClass;
                boolean bl = false;
                kotlinClass = new KotlinClassFinder.Result.KotlinClass(p0, null, 2, null);
            } else {
                kotlinClass = null;
            }
            return kotlinClass;
        }
        return null;
    }

    @Override
    @Nullable
    public InputStream findMetadata(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return null;
    }

    @Override
    @Nullable
    public Set<String> findMetadataTopLevelClassesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return null;
    }

    @Override
    public boolean hasMetadataPackage(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return false;
    }

    @Override
    @Nullable
    public InputStream findBuiltInsData(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return null;
    }
}

