/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.load.kotlin;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ksp.com.intellij.ide.highlighter.JavaClassFileType;
import ksp.com.intellij.openapi.diagnostic.ControlFlowException;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import ksp.org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import ksp.org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.util.PerformanceCounter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0016\u001a\u00020\u0017H\u0014J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\b\u0010\u001d\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lksp/org/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass;", "Lksp/org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass;", "file", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "className", "Lksp/org/jetbrains/kotlin/name/ClassId;", "classVersion", "", "classHeader", "Lksp/org/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "innerClasses", "Lksp/org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$InnerClassesInfo;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/ClassId;ILorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;Lorg/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$InnerClassesInfo;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "location", "", "getLocation", "()Ljava/lang/String;", "containingLibrary", "getContainingLibrary", "getFileContents", "", "equals", "", "other", "", "hashCode", "toString", "Factory", "frontend.common.jvm"})
public final class VirtualFileKotlinClass
extends FileBasedKotlinClass {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final VirtualFile file;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final PerformanceCounter perfCounter;

    private VirtualFileKotlinClass(VirtualFile file2, ClassId className, int classVersion, KotlinClassHeader classHeader, FileBasedKotlinClass.InnerClassesInfo innerClasses) {
        super(className, classVersion, classHeader, innerClasses);
        this.file = file2;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public String getLocation() {
        String string2 = this.file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        return string2;
    }

    @Override
    @Nullable
    public String getContainingLibrary() {
        String string2 = this.file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        String[] stringArray = new String[]{"!/"};
        return (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    @Override
    @NotNull
    protected byte[] getFileContents() {
        try {
            byte[] byArray = this.file.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
            return byArray;
        }
        catch (IOException e) {
            throw VirtualFileKotlinClass.Factory.logFileReadingErrorMessage(e, this.file);
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof VirtualFileKotlinClass && Intrinsics.areEqual((Object)((VirtualFileKotlinClass)other).file, (Object)this.file);
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.file;
    }

    public /* synthetic */ VirtualFileKotlinClass(VirtualFile file2, ClassId className, int classVersion, KotlinClassHeader classHeader, FileBasedKotlinClass.InnerClassesInfo innerClasses, DefaultConstructorMarker $constructor_marker) {
        this(file2, className, classVersion, classHeader, innerClasses);
    }

    static {
        Logger logger2 = Logger.getInstance(VirtualFileKotlinClass.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
        perfCounter = PerformanceCounter.Companion.create$default(PerformanceCounter.Companion, "Binary class from Kotlin file", false, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lksp/org/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass$Factory;", "", "<init>", "()V", "LOG", "Lksp/com/intellij/openapi/diagnostic/Logger;", "Lksp/org/jetbrains/annotations/NotNull;", "perfCounter", "Lksp/org/jetbrains/kotlin/util/PerformanceCounter;", "create", "Lksp/org/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "file", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "jvmMetadataVersion", "Lksp/org/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "fileContent", "", "create$frontend_common_jvm", "logFileReadingErrorMessage", "", "e", "renderFileReadingErrorMessage", "", "frontend.common.jvm"})
    @SourceDebugExtension(value={"SMAP\nVirtualFileKotlinClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileKotlinClass.kt\norg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass$Factory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
    public static final class Factory {
        private Factory() {
        }

        @Nullable
        public final KotlinClassFinder.Result create$frontend_common_jvm(@NotNull VirtualFile file2, @NotNull JvmMetadataVersion jvmMetadataVersion, @Nullable byte[] fileContent) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"jvmMetadataVersion");
            return (KotlinClassFinder.Result)perfCounter.time(() -> Factory.create$lambda$3(file2, fileContent, jvmMetadataVersion));
        }

        private final Throwable logFileReadingErrorMessage(Throwable e, VirtualFile file2) {
            String errorMessage = this.renderFileReadingErrorMessage(file2);
            LOG.warn(errorMessage, e);
            return new IllegalStateException(errorMessage, e);
        }

        private final String renderFileReadingErrorMessage(VirtualFile file2) {
            return "Could not read file: " + file2.getPath() + "; size in bytes: " + file2.getLength() + "; file type: " + file2.getFileType().getName();
        }

        private static final VirtualFileKotlinClass create$lambda$3$lambda$1(VirtualFile $file, ClassId name2, Integer classVersion, KotlinClassHeader header, FileBasedKotlinClass.InnerClassesInfo innerClasses) {
            Intrinsics.checkNotNull((Object)name2);
            Intrinsics.checkNotNull((Object)classVersion);
            int n = classVersion;
            Intrinsics.checkNotNull((Object)header);
            Intrinsics.checkNotNull((Object)innerClasses);
            return new VirtualFileKotlinClass($file, name2, n, header, innerClasses, null);
        }

        private static final KotlinClassFinder.Result create$lambda$3(VirtualFile $file, byte[] $fileContent, JvmMetadataVersion $jvmMetadataVersion) {
            boolean bl;
            boolean bl2 = bl = Intrinsics.areEqual((Object)$file.getExtension(), (Object)JavaClassFileType.INSTANCE.getDefaultExtension()) || Intrinsics.areEqual((Object)$file.getFileType(), (Object)JavaClassFileType.INSTANCE);
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-VirtualFileKotlinClass$Factory$create$1$22 = false;
                String $i$a$-assert-VirtualFileKotlinClass$Factory$create$1$22 = "Trying to read binary data from a non-class file " + $file;
                throw new AssertionError((Object)$i$a$-assert-VirtualFileKotlinClass$Factory$create$1$22);
            }
            try {
                byte[] byteContent;
                byte[] byArray = $fileContent;
                if ($fileContent == null) {
                    byte[] byArray2 = $file.contentsToByteArray(false);
                    byArray = byArray2;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"contentsToByteArray(...)");
                }
                if (!((byteContent = byArray).length == 0)) {
                    KotlinClassFinder.Result result2;
                    VirtualFileKotlinClass kotlinJvmBinaryClass;
                    VirtualFileKotlinClass virtualFileKotlinClass = kotlinJvmBinaryClass = (VirtualFileKotlinClass)FileBasedKotlinClass.create(byteContent, $jvmMetadataVersion, (arg_0, arg_1, arg_2, arg_3) -> Factory.create$lambda$3$lambda$1($file, arg_0, arg_1, arg_2, arg_3));
                    if (virtualFileKotlinClass != null) {
                        VirtualFileKotlinClass it = virtualFileKotlinClass;
                        boolean bl3 = false;
                        result2 = new KotlinClassFinder.Result.KotlinClass(it, byteContent);
                    } else {
                        result2 = new KotlinClassFinder.Result.ClassFileContent(byteContent);
                    }
                    return result2;
                }
            }
            catch (FileNotFoundException byteContent) {
            }
            catch (Throwable e) {
                if (e instanceof ControlFlowException) {
                    throw e;
                }
                throw Factory.logFileReadingErrorMessage(e, $file);
            }
            return null;
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

