/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.google.gwt.dev.js.parserExceptions.AbortParsingException;
import ksp.com.google.gwt.dev.js.rhino.CodePosition;
import ksp.com.google.gwt.dev.js.rhino.ErrorReporter;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptor;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsProgram;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsScope;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsStatement;
import ksp.org.jetbrains.kotlin.js.parser.ParserUtilsKt;
import ksp.org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import ksp.org.jetbrains.kotlin.js.patterns.PatternBuilder;
import ksp.org.jetbrains.kotlin.js.resolve.BindingContextSlicesJsKt;
import ksp.org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import ksp.org.jetbrains.kotlin.js.resolve.diagnostics.JsCodeErrorReporter;
import ksp.org.jetbrains.kotlin.psi.KtCallExpression;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import ksp.org.jetbrains.kotlin.psi.KtValueArgument;
import ksp.org.jetbrains.kotlin.psi.KtValueArgumentList;
import ksp.org.jetbrains.kotlin.psi.KtVisitor;
import ksp.org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import ksp.org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import ksp.org.jetbrains.kotlin.resolve.constants.ConstantValue;
import ksp.org.jetbrains.kotlin.resolve.constants.StringValue;
import ksp.org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import ksp.org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import ksp.org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/js/resolve/diagnostics/JsCallChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "constantExpressionEvaluator", "Lksp/org/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "<init>", "(Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;)V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "Companion", "js.frontend"})
public final class JsCallChecker
implements CallChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private static final DescriptorPredicate JS_PATTERN;

    public JsCallChecker(@NotNull ConstantExpressionEvaluator constantExpressionEvaluator) {
        Intrinsics.checkNotNullParameter((Object)constantExpressionEvaluator, (String)"constantExpressionEvaluator");
        this.constantExpressionEvaluator = constantExpressionEvaluator;
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.isAnnotationContext() || !Companion.isJsCall(resolvedCall2)) {
            return;
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"getCallElement(...)");
        KtElement expression2 = ktElement;
        if (!(expression2 instanceof KtCallExpression)) {
            return;
        }
        KtValueArgumentList ktValueArgumentList = ((KtCallExpression)expression2).getValueArgumentList();
        List<KtValueArgument> arguments2 = ktValueArgumentList != null ? ktValueArgumentList.getArguments() : null;
        List<KtValueArgument> list = arguments2;
        if (list == null || (list = (KtValueArgument)CollectionsKt.firstOrNull(list)) == null || (list = ((KtValueArgument)((Object)list)).getArgumentExpression()) == null) {
            return;
        }
        List<KtValueArgument> argument = list;
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context2.getTrace(), "JsCallChecker");
        Intrinsics.checkNotNullExpressionValue((Object)temporaryBindingTrace, (String)"create(...)");
        TemporaryBindingTrace trace = temporaryBindingTrace;
        CompileTimeConstant<?> evaluationResult = this.constantExpressionEvaluator.evaluateExpression((KtExpression)((Object)argument), trace, TypeUtils.NO_EXPECTED_TYPE);
        String code = Companion.extractStringValue(evaluationResult);
        if (code == null) {
            context2.getTrace().report(ErrorsJs.JSCODE_ARGUMENT_SHOULD_BE_CONSTANT.on((KtExpression)((PsiElement)((Object)argument))));
            return;
        }
        argument.accept(new KtVisitor(trace, context2){
            final /* synthetic */ TemporaryBindingTrace $trace;
            final /* synthetic */ CallCheckerContext $context;
            {
                this.$trace = $trace;
                this.$context = $context;
            }

            public void visitElement(PsiElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                element2.acceptChildren(this);
            }

            public Void visitSimpleNameExpression(KtSimpleNameExpression expression2, Void data) {
                VariableDescriptor variableAccessing;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.$trace.getBindingContext());
                CallableDescriptor callableDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
                VariableDescriptor variableDescriptor = variableAccessing = callableDescriptor instanceof VariableDescriptor ? (VariableDescriptor)callableDescriptor : null;
                boolean bl = variableDescriptor != null ? !variableDescriptor.isConst() : false;
                if (bl) {
                    this.$context.getTrace().report(ErrorsJs.JSCODE_ARGUMENT_NON_CONST_EXPRESSION.on((KtExpression)((PsiElement)expression2)));
                }
                return (Void)super.visitSimpleNameExpression(expression2, data);
            }
        });
        trace.commit();
        JsCodeErrorReporter errorReporter = new JsCodeErrorReporter((KtExpression)((Object)argument), code, context2.getTrace());
        try {
            List<JsStatement> statements;
            JsFunctionScope parserScope = new JsFunctionScope(new JsRootScope(new JsProgram()), "<js fun>");
            ErrorReporter errorReporter2 = errorReporter;
            JsScope jsScope = parserScope;
            CodePosition codePosition = new CodePosition(0, 0);
            Object object = reportOn.getContainingFile();
            if (object == null || (object = object.getName()) == null) {
                object = "<unknown file>";
            }
            if ((statements = ParserUtilsKt.parseExpressionOrStatement(code, errorReporter2, jsScope, codePosition, (String)object)) == null || statements.isEmpty()) {
                context2.getTrace().report(ErrorsJs.JSCODE_NO_JAVASCRIPT_PRODUCED.on((KtExpression)((PsiElement)((Object)argument))));
            }
        }
        catch (AbortParsingException abortParsingException) {
            // empty catch block
        }
        context2.getTrace().record(BindingContextSlicesJsKt.LEXICAL_SCOPE_FOR_JS, resolvedCall2, context2.getScope());
    }

    @JvmStatic
    public static final <F extends CallableDescriptor> boolean isJsCall(@NotNull ResolvedCall<F> $this$isJsCall) {
        return Companion.isJsCall($this$isJsCall);
    }

    @JvmStatic
    @Nullable
    public static final String extractStringValue(@Nullable CompileTimeConstant<?> compileTimeConstant) {
        return Companion.extractStringValue(compileTimeConstant);
    }

    static {
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern("kotlin.js.js(String)");
        Intrinsics.checkNotNullExpressionValue((Object)descriptorPredicate, (String)"pattern(...)");
        JS_PATTERN = descriptorPredicate;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u0007\"\n\b\u0000\u0010\b*\u0004\u0018\u00010\t*\b\u0012\u0004\u0012\u0002H\b0\nH\u0007J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/js/resolve/diagnostics/JsCallChecker$Companion;", "", "<init>", "()V", "JS_PATTERN", "Lksp/org/jetbrains/kotlin/js/patterns/DescriptorPredicate;", "isJsCall", "", "F", "Lksp/org/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "extractStringValue", "", "compileTimeConstant", "Lksp/org/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "js.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final <F extends CallableDescriptor> boolean isJsCall(@NotNull ResolvedCall<F> $this$isJsCall) {
            Intrinsics.checkNotNullParameter($this$isJsCall, (String)"<this>");
            F f = $this$isJsCall.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue(f, (String)"getResultingDescriptor(...)");
            F descriptor2 = f;
            return descriptor2 instanceof SimpleFunctionDescriptor && JS_PATTERN.test(descriptor2);
        }

        @JvmStatic
        @Nullable
        public final String extractStringValue(@Nullable CompileTimeConstant<?> compileTimeConstant) {
            TypedCompileTimeConstant typedCompileTimeConstant = compileTimeConstant instanceof TypedCompileTimeConstant ? (TypedCompileTimeConstant)compileTimeConstant : null;
            ConstantValue constantValue = typedCompileTimeConstant != null ? typedCompileTimeConstant.getConstantValue() : null;
            StringValue stringValue = constantValue instanceof StringValue ? (StringValue)constantValue : null;
            return stringValue != null ? (String)stringValue.getValue() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

