/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.Visibilities;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory4;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import ksp.org.jetbrains.kotlin.fir.types.CompilerConeAttributes;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ProjectionKind;
import ksp.org.jetbrains.kotlin.types.EnrichedProjectionKind;
import ksp.org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J.\u0010\u0010\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J4\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002JP\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0002\u00a8\u0006 "}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassVarianceChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkCallableDeclaration", "member", "Lksp/org/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "checkTypeParameters", "typeParameters", "", "Lksp/org/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;", "variance", "Lksp/org/jetbrains/kotlin/types/Variance;", "checkVarianceConflict", "typeRef", "Lksp/org/jetbrains/kotlin/fir/types/FirTypeRef;", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "type", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "containingType", "isInAbbreviation", "", "checkers"})
public final class FirClassVarianceChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirClassVarianceChecker INSTANCE = new FirClassVarianceChecker();

    private FirClassVarianceChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkTypeParameters(declaration2.getTypeParameters(), Variance.OUT_VARIANCE, context2, reporter);
        for (FirTypeRef superTypeRef : declaration2.getSuperTypeRefs()) {
            FirClassVarianceChecker.checkVarianceConflict$default(this, superTypeRef, Variance.OUT_VARIANCE, context2, reporter, null, 16, null);
        }
        for (FirDeclaration member : declaration2.getDeclarations()) {
            if (member instanceof FirMemberDeclaration && Visibilities.INSTANCE.isPrivate(((FirMemberDeclaration)member).getStatus().getVisibility())) continue;
            if (member instanceof FirTypeParameterRefsOwner && !(member instanceof FirClass)) {
                this.checkTypeParameters(((FirTypeParameterRefsOwner)((Object)member)).getTypeParameters(), Variance.IN_VARIANCE, context2, reporter);
            }
            if (!(member instanceof FirCallableDeclaration)) continue;
            this.checkCallableDeclaration((FirCallableDeclaration)member, context2, reporter);
        }
    }

    private final void checkCallableDeclaration(FirCallableDeclaration member, CheckerContext context2, DiagnosticReporter reporter) {
        FirTypeRef receiverTypeRef;
        KtSourceElement memberSource = member.getSource();
        if (member instanceof FirSimpleFunction && memberSource != null && !(memberSource.getKind() instanceof KtFakeSourceElementKind)) {
            for (FirValueParameter param : ((FirSimpleFunction)member).getValueParameters()) {
                FirClassVarianceChecker.checkVarianceConflict$default(this, param.getReturnTypeRef(), Variance.IN_VARIANCE, context2, reporter, null, 16, null);
            }
        }
        Variance returnTypeVariance = member instanceof FirProperty && ((FirProperty)member).isVar() ? Variance.INVARIANT : Variance.OUT_VARIANCE;
        KtSourceElement returnSource = member.getReturnTypeRef().getSource();
        if (returnSource != null) {
            if (memberSource != null && returnSource.getKind() instanceof KtFakeSourceElementKind && !(memberSource.getKind() instanceof KtFakeSourceElementKind)) {
                returnSource = memberSource;
            }
        } else {
            returnSource = memberSource;
        }
        this.checkVarianceConflict(member.getReturnTypeRef(), returnTypeVariance, context2, reporter, returnSource);
        FirReceiverParameter firReceiverParameter = member.getReceiverParameter();
        FirTypeRef firTypeRef = receiverTypeRef = firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null;
        if (receiverTypeRef != null) {
            FirClassVarianceChecker.checkVarianceConflict$default(this, receiverTypeRef, Variance.IN_VARIANCE, context2, reporter, null, 16, null);
        }
    }

    private final void checkTypeParameters(List<? extends FirTypeParameterRef> typeParameters2, Variance variance2, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirTypeParameterRef firTypeParameterRef : typeParameters2) {
            if (!(firTypeParameterRef instanceof FirTypeParameter)) continue;
            for (FirResolvedTypeRef bound : ((FirTypeParameter)firTypeParameterRef).getSymbol().getResolvedBounds()) {
                FirClassVarianceChecker.checkVarianceConflict$default(this, bound, variance2, context2, reporter, null, 16, null);
            }
        }
    }

    private final void checkVarianceConflict(FirTypeRef typeRef, Variance variance2, CheckerContext context2, DiagnosticReporter reporter, KtSourceElement source) {
        ConeKotlinType expandedType = TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(typeRef), context2.getSession(), null, 2, null);
        FirClassVarianceChecker.checkVarianceConflict$default(this, expandedType, variance2, typeRef, expandedType, context2, reporter, source, false, 128, null);
    }

    static /* synthetic */ void checkVarianceConflict$default(FirClassVarianceChecker firClassVarianceChecker, FirTypeRef firTypeRef, Variance variance2, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement, int n, Object object) {
        if ((n & 0x10) != 0) {
            ktSourceElement = null;
        }
        firClassVarianceChecker.checkVarianceConflict(firTypeRef, variance2, checkerContext, diagnosticReporter, ktSourceElement);
    }

    private final void checkVarianceConflict(ConeKotlinType type2, Variance variance2, FirTypeRef typeRef, ConeKotlinType containingType, CheckerContext context2, DiagnosticReporter reporter, KtSourceElement source, boolean isInAbbreviation) {
        ConeClassLikeType fullyExpandedType2;
        FirClassLikeSymbol<?> classSymbol;
        if (type2 instanceof ConeTypeParameterType) {
            KtSourceElement resultSource;
            ConeSimpleKotlinType fullyExpandedType3 = TypeExpansionUtilsKt.fullyExpandedType$default((ConeSimpleKotlinType)type2, context2.getSession(), null, 2, null);
            FirTypeParameterSymbol typeParameterSymbol = ((ConeTypeParameterType)type2).getLookupTag().getTypeParameterSymbol();
            KtSourceElement ktSourceElement = source;
            if (ktSourceElement == null) {
                FirTypeRef firTypeRef = typeRef;
                ktSourceElement = firTypeRef != null ? firTypeRef.getSource() : null;
            }
            if ((resultSource = ktSourceElement) != null && !typeParameterSymbol.getVariance().allowsPosition(variance2) && !fullyExpandedType3.getAttributes().contains(CompilerConeAttributes.UnsafeVariance.INSTANCE)) {
                KtDiagnosticFactory4<FirTypeParameterSymbol, Variance, Variance, ConeKotlinType> factory2 = isInAbbreviation ? FirErrors.INSTANCE.getTYPE_VARIANCE_CONFLICT_IN_EXPANDED_TYPE() : FirErrors.INSTANCE.getTYPE_VARIANCE_CONFLICT_ERROR();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)resultSource, factory2, (Object)typeParameterSymbol, (Object)typeParameterSymbol.getVariance(), (Object)variance2, (Object)containingType, (DiagnosticContext)context2, null, 128, null);
            }
            return;
        }
        if (type2 instanceof ConeClassLikeType && (classSymbol = ToSymbolUtilsKt.toSymbol((fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)type2, context2.getSession(), null, 2, null)).getLookupTag(), context2.getSession())) instanceof FirClassSymbol) {
            List<FirTypeRefSource> typeRefAndSourcesForArguments = FirHelpersKt.extractArgumentsTypeRefAndSource(typeRef);
            ConeTypeProjection[] coneTypeProjectionArray = fullyExpandedType2.getTypeArguments();
            int n = coneTypeProjectionArray.length;
            block11: for (int i = 0; i < n; ++i) {
                ConeKotlinType typeArgumentType;
                FirTypeRefSource subTypeRefAndSource;
                Variance variance3;
                Variance variance4;
                int index = i;
                ConeTypeProjection typeArgument = coneTypeProjectionArray[i];
                Object object = (FirTypeParameterSymbol)CollectionsKt.getOrNull(((FirClassSymbol)classSymbol).getTypeParameterSymbols(), (int)index);
                if (object == null || (object = object.getVariance()) == null) continue;
                Object paramVariance = object;
                switch (WhenMappings.$EnumSwitchMapping$0[typeArgument.getKind().ordinal()]) {
                    case 1: {
                        variance4 = Variance.IN_VARIANCE;
                        break;
                    }
                    case 2: {
                        variance4 = Variance.OUT_VARIANCE;
                        break;
                    }
                    case 3: {
                        variance4 = Variance.INVARIANT;
                        break;
                    }
                    default: {
                        continue block11;
                    }
                }
                Variance argVariance = variance4;
                if (ConeTypeProjectionKt.getType(typeArgument) == null) continue;
                switch (WhenMappings.$EnumSwitchMapping$1[EnrichedProjectionKind.Companion.getEffectiveProjectionKind((Variance)((Object)paramVariance), argVariance).ordinal()]) {
                    case 1: {
                        variance3 = variance2;
                        break;
                    }
                    case 2: {
                        variance3 = variance2.opposite();
                        break;
                    }
                    case 3: {
                        variance3 = Variance.INVARIANT;
                        break;
                    }
                    case 4: {
                        variance3 = null;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Variance newVariance = variance3;
                if (newVariance == null) continue;
                List<FirTypeRefSource> list = typeRefAndSourcesForArguments;
                FirTypeRefSource firTypeRefSource = subTypeRefAndSource = list != null ? (FirTypeRefSource)CollectionsKt.getOrNull(list, (int)index) : null;
                FirTypeRef firTypeRef = firTypeRefSource != null ? firTypeRefSource.getTypeRef() : null;
                Object object2 = subTypeRefAndSource;
                if (object2 == null || (object2 = ((FirTypeRefSource)object2).getTypeRef()) == null || (object2 = ((FirTypeRef)object2).getSource()) == null) {
                    object2 = source;
                }
                this.checkVarianceConflict(typeArgumentType, newVariance, firTypeRef, containingType, context2, reporter, (KtSourceElement)object2, AbbreviatedTypeAttributeKt.isTypealiasExpansion(type2));
            }
        }
    }

    static /* synthetic */ void checkVarianceConflict$default(FirClassVarianceChecker firClassVarianceChecker, ConeKotlinType coneKotlinType, Variance variance2, FirTypeRef firTypeRef, ConeKotlinType coneKotlinType2, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement, boolean bl, int n, Object object) {
        if ((n & 0x40) != 0) {
            ktSourceElement = null;
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        firClassVarianceChecker.checkVarianceConflict(coneKotlinType, variance2, firTypeRef, coneKotlinType2, checkerContext, diagnosticReporter, ktSourceElement, bl);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProjectionKind.values().length];
            try {
                nArray[ProjectionKind.IN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.INVARIANT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[EnrichedProjectionKind.values().length];
            try {
                nArray[EnrichedProjectionKind.OUT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedProjectionKind.IN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedProjectionKind.INV.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedProjectionKind.STAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

