/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationsPlatformSpecificSupportComponentKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnyDeprecationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirAnyDeprecationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnyDeprecationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnyDeprecationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n37#2:35\n1863#3,2:36\n*S KotlinDebug\n*F\n+ 1 FirAnyDeprecationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnyDeprecationChecker\n*L\n22#1:35\n25#1:36,2\n*E\n"})
public final class FirAnyDeprecationChecker
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    public static final FirAnyDeprecationChecker INSTANCE = new FirAnyDeprecationChecker();

    private FirAnyDeprecationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirSimpleFunction declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirMemberDeclaration $this$isOverride$iv = declaration2;
        boolean $i$f$isOverride = false;
        if (!$this$isOverride$iv.getStatus().isOverride() || !FirDeclarationUtilKt.isMethodOfAny(declaration2.getSymbol())) {
            return;
        }
        Map<ClassId, Boolean> deprecationAnnotations = FirAnnotationsPlatformSpecificSupportComponentKt.getAnnotationPlatformSupport(context2.getSession()).getDeprecationAnnotationsWithOverridesPropagation();
        Iterable $this$forEach$iv = declaration2.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean isOptInMarker;
            FirAnnotation annotation = (FirAnnotation)element$iv;
            boolean bl = false;
            boolean isDeprecationMarker = deprecationAnnotations.containsKey(FirAnnotationUtilsKt.toAnnotationClassId(annotation, context2.getSession()));
            boolean bl2 = isOptInMarker = FirAnnotationHelpersKt.getAnnotationClassForOptInMarker(annotation, context2.getSession()) != null;
            if (!isDeprecationMarker && !isOptInMarker) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getPOTENTIALLY_NON_REPORTED_ANNOTATION(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

