/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.util;

import ksp.com.intellij.openapi.util.NullableLazyValue;
import ksp.com.intellij.openapi.util.RecursionGuard;
import ksp.com.intellij.openapi.util.RecursionManager;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public abstract class VolatileNullableLazyValue<T>
extends NullableLazyValue<T> {
    private volatile boolean myComputed;
    @Nullable
    private volatile T myValue;

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    VolatileNullableLazyValue() {
    }

    @Override
    @Nullable
    public T getValue() {
        boolean computed = this.myComputed;
        T value2 = this.myValue;
        if (!computed) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            value2 = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = value2;
                this.myComputed = true;
            }
        }
        return value2;
    }

    @Override
    public boolean isComputed() {
        return this.myComputed;
    }
}

