/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.codeInsight;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.util.Comparing;
import ksp.com.intellij.psi.PsiComment;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiReference;
import ksp.com.intellij.psi.PsiWhiteSpace;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.com.intellij.psi.util.PsiUtilCore;
import ksp.com.intellij.util.PairConsumer;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class PsiEquivalenceUtil {
    private static final Logger LOG = Logger.getInstance(PsiEquivalenceUtil.class);

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean areElementsEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2, @Nullable Comparator<? super PsiElement> resolvedElementsComparator, boolean areCommentsSignificant) {
        if (element1 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(1);
        }
        return PsiEquivalenceUtil.areEquivalent(element1, element2, PsiEquivalenceUtil.adapt(resolvedElementsComparator), areCommentsSignificant);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean areElementsEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2, @Nullable Comparator<? super PsiElement> resolvedElementsComparator, @Nullable Comparator<? super PsiElement> leafElementsComparator) {
        if (element1 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(3);
        }
        return PsiEquivalenceUtil.areEquivalent(element1, element2, PsiEquivalenceUtil.adapt(resolvedElementsComparator), PsiEquivalenceUtil.adapt(leafElementsComparator));
    }

    public static boolean areEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2, @Nullable BiPredicate<? super PsiElement, ? super PsiElement> resolvedElementsEqual, boolean areCommentsSignificant) {
        if (element1 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(4);
        }
        if (element2 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(5);
        }
        return PsiEquivalenceUtil.areEquivalent(element1, element2, new ReferenceComparator(resolvedElementsEqual), null, null, areCommentsSignificant);
    }

    public static boolean areEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2, @Nullable BiPredicate<? super PsiElement, ? super PsiElement> resolvedElementsEqual, @Nullable BiPredicate<? super PsiElement, ? super PsiElement> leafsEqual) {
        if (element1 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(6);
        }
        if (element2 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(7);
        }
        return PsiEquivalenceUtil.areEquivalent(element1, element2, new ReferenceComparator(resolvedElementsEqual), leafsEqual, null, false);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean areElementsEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2, @NotNull Comparator<? super PsiReference> referenceComparator, @Nullable Comparator<? super PsiElement> leafElementsComparator, @Nullable Predicate<? super PsiElement> isElementSignificantCondition, boolean areCommentsSignificant) {
        if (element1 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(8);
        }
        if (element2 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(9);
        }
        if (referenceComparator == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(10);
        }
        return PsiEquivalenceUtil.areEquivalent(element1, element2, PsiEquivalenceUtil.adapt(referenceComparator), PsiEquivalenceUtil.adapt(leafElementsComparator), isElementSignificantCondition, areCommentsSignificant);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    private static <T> BiPredicate<T, T> adapt(@Nullable Comparator<? super T> comparator) {
        return comparator == null ? null : (l1, l2) -> comparator.compare(l1, l2) == 0;
    }

    public static boolean areEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2, @NotNull BiPredicate<? super PsiReference, ? super PsiReference> refsAreEqual, @Nullable BiPredicate<? super PsiElement, ? super PsiElement> leafsAreEqual, @Nullable Predicate<? super PsiElement> isElementSignificantCondition, boolean areCommentsSignificant) {
        PsiElement[] children2;
        if (element1 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(11);
        }
        if (element2 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(12);
        }
        if (refsAreEqual == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(13);
        }
        if (element1 == element2) {
            return true;
        }
        ASTNode node1 = element1.getNode();
        ASTNode node2 = element2.getNode();
        if (node1 == null || node2 == null) {
            return false;
        }
        if (node1.getElementType() != node2.getElementType()) {
            return false;
        }
        PsiElement[] children1 = PsiEquivalenceUtil.getFilteredChildren(element1, isElementSignificantCondition, areCommentsSignificant);
        if (children1.length != (children2 = PsiEquivalenceUtil.getFilteredChildren(element2, isElementSignificantCondition, areCommentsSignificant)).length) {
            return false;
        }
        for (int i = 0; i < children1.length; ++i) {
            PsiElement child1 = children1[i];
            PsiElement child2 = children2[i];
            if (PsiEquivalenceUtil.areEquivalent(child1, child2, refsAreEqual, leafsAreEqual, isElementSignificantCondition, areCommentsSignificant)) continue;
            return false;
        }
        if (children1.length == 0 && (leafsAreEqual != null ? !leafsAreEqual.test(element1, element2) : !element1.textMatches(element2))) {
            return false;
        }
        PsiReference ref1 = element1.getReference();
        if (ref1 != null) {
            PsiReference ref2 = element2.getReference();
            if (ref2 == null) {
                return false;
            }
            if (!refsAreEqual.test(ref1, ref2)) {
                return false;
            }
        }
        return true;
    }

    public static boolean areElementsEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(14);
        }
        if (element2 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(15);
        }
        return PsiEquivalenceUtil.areEquivalent(element1, element2, null, false);
    }

    public static PsiElement @NotNull [] getFilteredChildren(@NotNull PsiElement element2, @Nullable Predicate<? super PsiElement> isElementSignificantCondition, boolean areCommentsSignificant) {
        if (element2 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(16);
        }
        ASTNode[] children1 = element2.getNode().getChildren(null);
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        for (ASTNode node : children1) {
            PsiElement child = node.getPsi();
            if (child instanceof PsiWhiteSpace || !areCommentsSignificant && child instanceof PsiComment || isElementSignificantCondition != null && !isElementSignificantCondition.test(child)) continue;
            array.add(child);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(17);
        }
        return psiElementArray;
    }

    public static void findChildRangeDuplicates(PsiElement first, PsiElement last, PsiElement scope, PairConsumer<? super PsiElement, ? super PsiElement> consumer2) {
        LOG.assertTrue(first.getParent() == last.getParent());
        LOG.assertTrue(!(first instanceof PsiWhiteSpace) && !(last instanceof PsiWhiteSpace));
        PsiEquivalenceUtil.addRangeDuplicates(scope, first, last, consumer2);
    }

    private static void addRangeDuplicates(PsiElement scope, PsiElement first, PsiElement last, PairConsumer<? super PsiElement, ? super PsiElement> result2) {
        PsiElement[] children2 = PsiEquivalenceUtil.getFilteredChildren(scope, null, true);
        int i = 0;
        block0: while (i < children2.length) {
            PsiElement child = children2[i];
            if (child != first) {
                int j = i;
                PsiElement next2 = first;
                while (PsiEquivalenceUtil.areElementsEquivalent(children2[j], next2)) {
                    ++j;
                    if (next2 == last) {
                        result2.consume(child, children2[j - 1]);
                        i = j + 1;
                        continue block0;
                    }
                    next2 = PsiTreeUtil.skipWhitespacesForward(next2);
                }
                if (i == j) {
                    PsiEquivalenceUtil.addRangeDuplicates(child, first, last, result2);
                }
            }
            ++i;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceComparator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refsAreEqual";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/codeInsight/PsiEquivalenceUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/codeInsight/PsiEquivalenceUtil";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areElementsEquivalent";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "areEquivalent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredChildren";
                break;
            }
            case 17: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReferenceComparator
    implements BiPredicate<PsiReference, PsiReference> {
        @Nullable
        private final BiPredicate<? super PsiElement, ? super PsiElement> myResolvedElementsComparator;

        ReferenceComparator(@Nullable BiPredicate<? super PsiElement, ? super PsiElement> resolvedElementsComparator) {
            this.myResolvedElementsComparator = resolvedElementsComparator;
        }

        @Override
        public boolean test(PsiReference ref1, PsiReference ref2) {
            PsiElement resolved2;
            PsiElement resolved1 = ref1.resolve();
            return Comparing.equal(resolved1, resolved2 = ref2.resolve()) || this.myResolvedElementsComparator != null && this.myResolvedElementsComparator.test(resolved1, resolved2);
        }
    }
}

