/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.psi.stubs.elements;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import ksp.com.intellij.psi.stubs.IndexSink;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.psi.stubs.StubInputStream;
import ksp.com.intellij.psi.stubs.StubOutputStream;
import ksp.com.intellij.util.io.StringRef;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.constant.ConstantValue;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationEntry;
import ksp.org.jetbrains.kotlin.psi.KtValueArgumentList;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinAnnotationEntryStub;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import ksp.org.jetbrains.kotlin.psi.stubs.impl.KotlinAnnotationEntryStubImpl;
import ksp.org.jetbrains.kotlin.psi.stubs.impl.KotlinConstantValueKt;

public class KtAnnotationEntryElementType
extends KtStubElementType<KotlinAnnotationEntryStub, KtAnnotationEntry> {
    public KtAnnotationEntryElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            KtAnnotationEntryElementType.$$$reportNull$$$0(0);
        }
        super(debugName, KtAnnotationEntry.class, KotlinAnnotationEntryStub.class);
    }

    @Override
    @NotNull
    public KotlinAnnotationEntryStub createStub(@NotNull KtAnnotationEntry psi2, StubElement parentStub) {
        Name shortName2;
        if (psi2 == null) {
            KtAnnotationEntryElementType.$$$reportNull$$$0(1);
        }
        String resultName = (shortName2 = psi2.getShortName()) != null ? shortName2.asString() : null;
        KtValueArgumentList valueArgumentList = psi2.getValueArgumentList();
        boolean hasValueArguments = valueArgumentList != null && !valueArgumentList.getArguments().isEmpty();
        return new KotlinAnnotationEntryStubImpl(parentStub, StringRef.fromString(resultName), hasValueArguments, null);
    }

    @Override
    public void serialize(@NotNull KotlinAnnotationEntryStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            KtAnnotationEntryElementType.$$$reportNull$$$0(2);
        }
        if (dataStream == null) {
            KtAnnotationEntryElementType.$$$reportNull$$$0(3);
        }
        dataStream.writeName(stub.getShortName());
        dataStream.writeBoolean(stub.hasValueArguments());
        if (stub instanceof KotlinAnnotationEntryStubImpl) {
            Map<Name, ConstantValue<?>> arguments2 = ((KotlinAnnotationEntryStubImpl)stub).getValueArguments();
            dataStream.writeInt(arguments2 != null ? arguments2.size() : 0);
            if (arguments2 != null) {
                for (Map.Entry<Name, ConstantValue<?>> valueEntry : arguments2.entrySet()) {
                    dataStream.writeName(valueEntry.getKey().asString());
                    ConstantValue<?> value2 = valueEntry.getValue();
                    KotlinConstantValueKt.serialize(value2, dataStream);
                }
            }
        }
    }

    @Override
    @NotNull
    public KotlinAnnotationEntryStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            KtAnnotationEntryElementType.$$$reportNull$$$0(4);
        }
        StringRef text = dataStream.readName();
        boolean hasValueArguments = dataStream.readBoolean();
        int valueArgCount = dataStream.readInt();
        LinkedHashMap args = new LinkedHashMap();
        for (int i = 0; i < valueArgCount; ++i) {
            args.put(Name.identifier(Objects.requireNonNull(dataStream.readNameString())), KotlinConstantValueKt.createConstantValue(dataStream));
        }
        return new KotlinAnnotationEntryStubImpl(parentStub, text, hasValueArguments, args.isEmpty() ? null : args);
    }

    @Override
    public void indexStub(@NotNull KotlinAnnotationEntryStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            KtAnnotationEntryElementType.$$$reportNull$$$0(5);
        }
        if (sink == null) {
            KtAnnotationEntryElementType.$$$reportNull$$$0(6);
        }
        StubIndexService.getInstance().indexAnnotation(stub, sink);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "ksp/org/jetbrains/kotlin/psi/stubs/elements/KtAnnotationEntryElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "indexStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

