/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeObjCRefinementOverridesChecker;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J,\u0010\u0012\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0018"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCallableDeclarationChecker;", "()V", "hidesFromObjCClassId", "Lksp/org/jetbrains/kotlin/name/ClassId;", "getHidesFromObjCClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "refinesInSwiftClassId", "getRefinesInSwiftClassId", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "findRefinedAnnotations", "Lkotlin/Pair;", "", "Lksp/org/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "checkers.native"})
public final class FirNativeObjCRefinementChecker
extends FirDeclarationChecker<FirCallableDeclaration> {
    @NotNull
    public static final FirNativeObjCRefinementChecker INSTANCE = new FirNativeObjCRefinementChecker();
    @NotNull
    private static final ClassId hidesFromObjCClassId = ClassId.Companion.topLevel(new FqName("kotlin.native.HidesFromObjC"));
    @NotNull
    private static final ClassId refinesInSwiftClassId = ClassId.Companion.topLevel(new FqName("kotlin.native.RefinesInSwift"));

    private FirNativeObjCRefinementChecker() {
        super(MppCheckerKind.Common);
    }

    @NotNull
    public final ClassId getHidesFromObjCClassId() {
        return hidesFromObjCClassId;
    }

    @NotNull
    public final ClassId getRefinesInSwiftClassId() {
        return refinesInSwiftClassId;
    }

    @Override
    public void check(@NotNull FirCallableDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirClass containingClass;
        Object swiftAnnotation2;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(declaration2 instanceof FirSimpleFunction) && !(declaration2 instanceof FirProperty)) {
            return;
        }
        Pair<List<FirAnnotation>, List<FirAnnotation>> pair = this.findRefinedAnnotations(declaration2, context2.getSession());
        List objCAnnotations = (List)pair.component1();
        List swiftAnnotations = (List)pair.component2();
        if (!((Collection)objCAnnotations).isEmpty() && !((Collection)swiftAnnotations).isEmpty()) {
            for (Object swiftAnnotation2 : swiftAnnotations) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirAnnotation)swiftAnnotation2).getSource(), FirNativeErrors.INSTANCE.getREDUNDANT_SWIFT_REFINEMENT(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        FirClass firClass = containingClass = (swiftAnnotation2 = CollectionsKt.lastOrNull(context2.getContainingDeclarations())) instanceof FirClass ? (FirClass)swiftAnnotation2 : null;
        if (containingClass != null) {
            FirTypeScope firTypeScope = FirHelpersKt.unsubstitutedScope(containingClass, context2);
            FirNativeObjCRefinementOverridesChecker.Companion.check(firTypeScope, declaration2.getSymbol(), declaration2, context2, reporter, objCAnnotations, swiftAnnotations);
        }
    }

    private final Pair<List<FirAnnotation>, List<FirAnnotation>> findRefinedAnnotations(FirCallableDeclaration $this$findRefinedAnnotations, FirSession session2) {
        List objCAnnotations = new ArrayList();
        List swiftAnnotations = new ArrayList();
        block0: for (FirAnnotation annotation2 : $this$findRefinedAnnotations.getAnnotations()) {
            FirClassLikeSymbol<?> firClassLikeSymbol = FirAnnotationUtilsKt.toAnnotationClassLikeSymbol(annotation2, session2);
            List list2 = firClassLikeSymbol != null ? firClassLikeSymbol.getResolvedAnnotationsWithClassIds() : null;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            List metaAnnotations = list2;
            for (FirAnnotation metaAnnotation : metaAnnotations) {
                ClassId classId = FirAnnotationUtilsKt.toAnnotationClassId(metaAnnotation, session2);
                if (Intrinsics.areEqual((Object)classId, (Object)hidesFromObjCClassId)) {
                    objCAnnotations.add(annotation2);
                    continue block0;
                }
                if (!Intrinsics.areEqual((Object)classId, (Object)refinesInSwiftClassId)) continue;
                swiftAnnotations.add(annotation2);
                continue block0;
            }
        }
        return TuplesKt.to((Object)objCAnnotations, (Object)swiftAnnotations);
    }
}

