/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.asJava.elements;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiLiteral;
import ksp.com.intellij.psi.PsiLiteralExpression;
import ksp.com.intellij.psi.PsiReference;
import ksp.com.intellij.psi.PsiType;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import ksp.org.jetbrains.kotlin.asJava.UtilsKt;
import ksp.org.jetbrains.kotlin.asJava.elements.KtLightAnnotationsValuesKt;
import ksp.org.jetbrains.kotlin.asJava.elements.KtLightElementBase;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtPsiFactory;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u0006H\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0015\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lksp/org/jetbrains/kotlin/asJava/elements/KtLightPsiLiteral;", "Lksp/org/jetbrains/kotlin/asJava/elements/KtLightElementBase;", "Lksp/com/intellij/psi/PsiLiteralExpression;", "kotlinOrigin", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "lightParent", "Lksp/com/intellij/psi/PsiElement;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/intellij/psi/PsiElement;)V", "getKotlinOrigin", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getParent", "getReference", "Lksp/com/intellij/psi/PsiReference;", "getReferences", "", "()[Lcom/intellij/psi/PsiReference;", "getType", "Lksp/com/intellij/psi/PsiType;", "getValue", "", "isPhysical", "", "replace", "newElement", "light-classes"})
public class KtLightPsiLiteral
extends KtLightElementBase
implements PsiLiteralExpression {
    @NotNull
    private final KtExpression kotlinOrigin;
    @NotNull
    private final PsiElement lightParent;

    public KtLightPsiLiteral(@NotNull KtExpression kotlinOrigin2, @NotNull PsiElement lightParent) {
        Intrinsics.checkNotNullParameter((Object)kotlinOrigin2, (String)"kotlinOrigin");
        Intrinsics.checkNotNullParameter((Object)lightParent, (String)"lightParent");
        super(lightParent);
        this.kotlinOrigin = kotlinOrigin2;
        this.lightParent = lightParent;
    }

    @Override
    @NotNull
    public KtExpression getKotlinOrigin() {
        return this.kotlinOrigin;
    }

    @Override
    @Nullable
    public Object getValue() {
        return UtilsKt.computeExpression(this);
    }

    @Override
    @Nullable
    public PsiType getType() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        BindingContext bindingContext = LightClassGenerationSupport.Companion.getInstance(project).analyze(this.getKotlinOrigin());
        KotlinType kotlinType = (KotlinType)bindingContext.get(BindingContext.EXPECTED_EXPRESSION_TYPE, this.getKotlinOrigin());
        if (kotlinType == null) {
            return null;
        }
        KotlinType kotlinType2 = kotlinType;
        Object object = kotlinType2.getConstructor().getDeclarationDescriptor();
        if (object == null || (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) == null || (object = ((FqName)object).asString()) == null) {
            return null;
        }
        Object typeFqName2 = object;
        return KtLightAnnotationsValuesKt.psiType$default((String)typeFqName2, this.getKotlinOrigin(), false, 4, null);
    }

    @Override
    @NotNull
    public PsiElement getParent() {
        return this.lightParent;
    }

    @Override
    public boolean isPhysical() {
        return false;
    }

    @Override
    @NotNull
    public PsiElement replace(@NotNull PsiElement newElement) {
        Intrinsics.checkNotNullParameter((Object)newElement, (String)"newElement");
        PsiLiteral psiLiteral = newElement instanceof PsiLiteral ? (PsiLiteral)newElement : null;
        Object object = psiLiteral != null ? psiLiteral.getValue() : null;
        String string2 = object instanceof String ? (String)object : null;
        if (string2 == null) {
            return this;
        }
        String value2 = string2;
        KtExpression ktExpression = this.getKotlinOrigin();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ktExpression.replace(new KtPsiFactory(project, false, 2, null).createExpression('\"' + StringUtil.escapeStringCharacters(value2) + '\"'));
        return this;
    }

    @Override
    @Nullable
    public PsiReference getReference() {
        return (PsiReference)ArraysKt.singleOrNull((Object[])this.getReferences());
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = this.getKotlinOrigin().getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        return psiReferenceArray;
    }
}

