/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.wasm.resolve.diagnostics;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.MemberDescriptor;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.wasm.resolve.diagnostics.ErrorsWasm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/wasm/resolve/diagnostics/WasmExternalInheritanceChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "wasm.frontend"})
public final class WasmExternalInheritanceChecker
implements DeclarationChecker {
    @NotNull
    public static final WasmExternalInheritanceChecker INSTANCE = new WasmExternalInheritanceChecker();

    private WasmExternalInheritanceChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (descriptor2 instanceof ClassDescriptor && !DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2)) {
            List superClasses2 = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)descriptor2)), (Iterable)DescriptorUtilsKt.getSuperInterfaces((ClassDescriptor)descriptor2));
            for (ClassDescriptor superClass : superClasses2) {
                if (!DescriptorUtilsKt.isEffectivelyExternal(superClass)) continue;
                context2.getTrace().report(ErrorsWasm.NON_EXTERNAL_TYPE_EXTENDS_EXTERNAL_TYPE.on((KtElement)((PsiElement)((KtClassOrObject)declaration2)), superClass.getDefaultType()));
            }
        }
    }
}

