/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.backend;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.fir.PrimitivesKt;
import ksp.org.jetbrains.kotlin.fir.StandardTypes;
import ksp.org.jetbrains.kotlin.fir.UtilsKt;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverterKt;
import ksp.org.jetbrains.kotlin.fir.backend.PrimitiveConeNumericComparisonInfo;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.types.ConeCapturedType;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a!\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001R\u00020\t\u00a2\u0006\u0002\u0010\n\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002\u001a\u0017\u0010\u000f\u001a\u0004\u0018\u00010\f*\u00020\u0010H\u0002R\u00020\t\u00a2\u0006\u0002\u0010\u0011\u001a\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0002R\u00020\t\u00a2\u0006\u0002\u0010\u0012\u001a\f\u0010\u0013\u001a\u00020\f*\u00020\fH\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\u0014"}, d2={"left", "Lksp/org/jetbrains/kotlin/fir/expressions/FirExpression;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "getLeft", "(Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "right", "getRight", "inferPrimitiveNumericComparisonInfo", "Lksp/org/jetbrains/kotlin/fir/backend/PrimitiveConeNumericComparisonInfo;", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/backend/PrimitiveConeNumericComparisonInfo;", "leastCommonPrimitiveNumericType", "Lksp/org/jetbrains/kotlin/fir/types/ConeClassLikeType;", "t1", "t2", "getPrimitiveTypeOrSupertype", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;)Lorg/jetbrains/kotlin/fir/backend/PrimitiveConeNumericComparisonInfo;", "promoteIntegerTypeToIntIfRequired", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nPrimitiveComparison.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrimitiveComparison.kt\norg/jetbrains/kotlin/fir/backend/PrimitiveComparisonKt\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,78:1\n43#2:79\n*S KotlinDebug\n*F\n+ 1 PrimitiveComparison.kt\norg/jetbrains/kotlin/fir/backend/PrimitiveComparisonKt\n*L\n25#1:79\n*E\n"})
public final class PrimitiveComparisonKt {
    @NotNull
    public static final FirExpression getLeft(@NotNull FirComparisonExpression $this$left) {
        Intrinsics.checkNotNullParameter((Object)$this$left, (String)"<this>");
        FirExpression firExpression2 = $this$left.getCompareToCall().getExplicitReceiver();
        if (firExpression2 == null) {
            throw new IllegalStateException(("There should be an explicit receiver for " + UtilsKt.render($this$left.getCompareToCall())).toString());
        }
        return firExpression2;
    }

    @NotNull
    public static final FirExpression getRight(@NotNull FirComparisonExpression $this$right) {
        Intrinsics.checkNotNullParameter((Object)$this$right, (String)"<this>");
        FirCall $this$arguments$iv = $this$right.getCompareToCall();
        boolean $i$f$getArguments = false;
        FirExpression firExpression2 = (FirExpression)CollectionsKt.getOrNull($this$arguments$iv.getArgumentList().getArguments(), (int)0);
        if (firExpression2 == null) {
            throw new IllegalStateException(("There should be a first arg for " + UtilsKt.render($this$right.getCompareToCall())).toString());
        }
        return firExpression2;
    }

    @Nullable
    public static final PrimitiveConeNumericComparisonInfo inferPrimitiveNumericComparisonInfo(@NotNull Fir2IrComponents $context_receiver_0, @NotNull FirComparisonExpression $this$inferPrimitiveNumericComparisonInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$inferPrimitiveNumericComparisonInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        return PrimitiveComparisonKt.inferPrimitiveNumericComparisonInfo($context_receiver_0, PrimitiveComparisonKt.getLeft($this$inferPrimitiveNumericComparisonInfo), PrimitiveComparisonKt.getRight($this$inferPrimitiveNumericComparisonInfo));
    }

    @Nullable
    public static final PrimitiveConeNumericComparisonInfo inferPrimitiveNumericComparisonInfo(@NotNull Fir2IrComponents $context_receiver_0, @NotNull FirExpression left, @NotNull FirExpression right) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        ConeKotlinType leftType = FirTypeUtilsKt.getResolvedType(left);
        ConeKotlinType rightType = FirTypeUtilsKt.getResolvedType(right);
        ConeClassLikeType coneClassLikeType = PrimitiveComparisonKt.getPrimitiveTypeOrSupertype($context_receiver_0, leftType);
        if (coneClassLikeType == null) {
            return null;
        }
        ConeClassLikeType leftPrimitiveOrNullableType = coneClassLikeType;
        ConeClassLikeType coneClassLikeType2 = PrimitiveComparisonKt.getPrimitiveTypeOrSupertype($context_receiver_0, rightType);
        if (coneClassLikeType2 == null) {
            return null;
        }
        ConeClassLikeType rightPrimitiveOrNullableType = coneClassLikeType2;
        ConeClassLikeType leastCommonType = PrimitiveComparisonKt.leastCommonPrimitiveNumericType(leftPrimitiveOrNullableType, rightPrimitiveOrNullableType);
        return new PrimitiveConeNumericComparisonInfo(leastCommonType, leftPrimitiveOrNullableType, rightPrimitiveOrNullableType);
    }

    private static final ConeClassLikeType leastCommonPrimitiveNumericType(ConeClassLikeType t1, ConeClassLikeType t2) {
        ConeClassLikeType coneClassLikeType;
        ConeClassLikeType pt1 = PrimitiveComparisonKt.promoteIntegerTypeToIntIfRequired(t1);
        ConeClassLikeType pt2 = PrimitiveComparisonKt.promoteIntegerTypeToIntIfRequired(t2);
        if (PrimitivesKt.isDouble(pt1) || PrimitivesKt.isDouble(pt2)) {
            coneClassLikeType = StandardTypes.INSTANCE.getDouble();
        } else if (PrimitivesKt.isFloat(pt1) || PrimitivesKt.isFloat(pt2)) {
            coneClassLikeType = StandardTypes.INSTANCE.getFloat();
        } else if (PrimitivesKt.isLong(pt1) || PrimitivesKt.isLong(pt2)) {
            coneClassLikeType = StandardTypes.INSTANCE.getLong();
        } else if (PrimitivesKt.isInt(pt1) || PrimitivesKt.isInt(pt2)) {
            coneClassLikeType = StandardTypes.INSTANCE.getInt();
        } else {
            throw new IllegalStateException(("Unexpected types: t1=" + t1 + ", t2=" + t2).toString());
        }
        return coneClassLikeType;
    }

    private static final ConeClassLikeType promoteIntegerTypeToIntIfRequired(ConeClassLikeType $this$promoteIntegerTypeToIntIfRequired) {
        ConeClassLikeType coneClassLikeType;
        ClassId classId = $this$promoteIntegerTypeToIntIfRequired.getLookupTag().getClassId();
        if (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getByte()) ? true : Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getShort())) {
            coneClassLikeType = StandardTypes.INSTANCE.getInt();
        } else if ((((Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getLong()) ? true : Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getInt())) ? true : Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getFloat())) ? true : Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getDouble())) ? true : Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getChar())) {
            coneClassLikeType = $this$promoteIntegerTypeToIntIfRequired;
        } else {
            throw new IllegalStateException(("Primitive number type expected: " + $this$promoteIntegerTypeToIntIfRequired).toString());
        }
        return coneClassLikeType;
    }

    private static final ConeClassLikeType getPrimitiveTypeOrSupertype(Fir2IrComponents $context_receiver_0, ConeKotlinType $this$getPrimitiveTypeOrSupertype) {
        ConeClassLikeType coneClassLikeType;
        block3: {
            if ($this$getPrimitiveTypeOrSupertype instanceof ConeTypeParameterType) {
                for (FirTypeRef it : (Iterable)((FirTypeParameter)((ConeTypeParameterType)$this$getPrimitiveTypeOrSupertype).getLookupTag().getTypeParameterSymbol().getFir()).getBounds()) {
                    boolean bl = false;
                    ConeClassLikeType coneClassLikeType2 = PrimitiveComparisonKt.getPrimitiveTypeOrSupertype($context_receiver_0, FirTypeUtilsKt.getConeType(it));
                    if (coneClassLikeType2 == null) continue;
                    coneClassLikeType = coneClassLikeType2;
                    break block3;
                }
                coneClassLikeType = null;
            } else {
                coneClassLikeType = $this$getPrimitiveTypeOrSupertype instanceof ConeClassLikeType && PrimitivesKt.isPrimitiveNumberType((ConeClassLikeType)$this$getPrimitiveTypeOrSupertype) ? (ConeClassLikeType)$this$getPrimitiveTypeOrSupertype : ($this$getPrimitiveTypeOrSupertype instanceof ConeFlexibleType ? PrimitiveComparisonKt.getPrimitiveTypeOrSupertype($context_receiver_0, ((ConeFlexibleType)$this$getPrimitiveTypeOrSupertype).getLowerBound()) : ($this$getPrimitiveTypeOrSupertype instanceof ConeCapturedType ? PrimitiveComparisonKt.getPrimitiveTypeOrSupertype($context_receiver_0, Fir2IrTypeConverterKt.approximateForIrOrSelf($context_receiver_0, $this$getPrimitiveTypeOrSupertype)) : null));
            }
        }
        return coneClassLikeType;
    }
}

