/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.serialization.js;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiFile;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.SourceFile;
import ksp.org.jetbrains.kotlin.metadata.ProtoBuf;
import ksp.org.jetbrains.kotlin.metadata.js.JsProtoBuf;
import ksp.org.jetbrains.kotlin.metadata.serialization.MutableVersionRequirementTable;
import ksp.org.jetbrains.kotlin.psi.KtFile;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.source.PsiSourceFile;
import ksp.org.jetbrains.kotlin.serialization.ApproximatingStringTable;
import ksp.org.jetbrains.kotlin.serialization.DescriptorSerializer;
import ksp.org.jetbrains.kotlin.serialization.KotlinSerializerExtensionBase;
import ksp.org.jetbrains.kotlin.serialization.js.JsSerializerProtocol;
import ksp.org.jetbrains.kotlin.serialization.js.KotlinDeserializedFileMetadata;
import ksp.org.jetbrains.kotlin.serialization.js.KotlinFileRegistry;
import ksp.org.jetbrains.kotlin.serialization.js.KotlinJavascriptPackageFragment;
import ksp.org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtilKt;
import ksp.org.jetbrains.kotlin.serialization.js.KotlinPsiFileMetadata;
import ksp.org.jetbrains.kotlin.types.FlexibleType;
import ksp.org.jetbrains.kotlin.utils.JsMetadataVersion;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016J*\u0010#\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020%2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J*\u0010&\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020(2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006)"}, d2={"Lksp/org/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializerExtension;", "Lksp/org/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "fileRegistry", "Lksp/org/jetbrains/kotlin/serialization/js/KotlinFileRegistry;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "metadataVersion", "Lksp/org/jetbrains/kotlin/utils/JsMetadataVersion;", "(Lorg/jetbrains/kotlin/serialization/js/KotlinFileRegistry;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/utils/JsMetadataVersion;)V", "getMetadataVersion", "()Lorg/jetbrains/kotlin/utils/JsMetadataVersion;", "stringTable", "Lksp/org/jetbrains/kotlin/serialization/ApproximatingStringTable;", "getStringTable", "()Lorg/jetbrains/kotlin/serialization/ApproximatingStringTable;", "getFileId", "", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Ljava/lang/Integer;", "serializeClass", "", "Lksp/org/jetbrains/kotlin/descriptors/ClassDescriptor;", "proto", "Lksp/org/jetbrains/kotlin/metadata/ProtoBuf$Class$Builder;", "versionRequirementTable", "Lksp/org/jetbrains/kotlin/metadata/serialization/MutableVersionRequirementTable;", "childSerializer", "Lksp/org/jetbrains/kotlin/serialization/DescriptorSerializer;", "serializeFlexibleType", "flexibleType", "Lksp/org/jetbrains/kotlin/types/FlexibleType;", "lowerProto", "Lksp/org/jetbrains/kotlin/metadata/ProtoBuf$Type$Builder;", "upperProto", "serializeFunction", "Lksp/org/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lksp/org/jetbrains/kotlin/metadata/ProtoBuf$Function$Builder;", "serializeProperty", "Lksp/org/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lksp/org/jetbrains/kotlin/metadata/ProtoBuf$Property$Builder;", "js.serializer"})
@SourceDebugExtension(value={"SMAP\nKotlinJavascriptSerializerExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinJavascriptSerializerExtension.kt\norg/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializerExtension\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class KotlinJavascriptSerializerExtension
extends KotlinSerializerExtensionBase {
    @NotNull
    private final KotlinFileRegistry fileRegistry;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final JsMetadataVersion metadataVersion;
    @NotNull
    private final ApproximatingStringTable stringTable;

    public KotlinJavascriptSerializerExtension(@NotNull KotlinFileRegistry fileRegistry, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull JsMetadataVersion metadataVersion2) {
        Intrinsics.checkNotNullParameter((Object)fileRegistry, (String)"fileRegistry");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)metadataVersion2, (String)"metadataVersion");
        super(JsSerializerProtocol.INSTANCE);
        this.fileRegistry = fileRegistry;
        this.languageVersionSettings = languageVersionSettings2;
        this.metadataVersion = metadataVersion2;
        this.stringTable = new ApproximatingStringTable();
    }

    @Override
    @NotNull
    public JsMetadataVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    @Override
    @NotNull
    public ApproximatingStringTable getStringTable() {
        return this.stringTable;
    }

    @Override
    public void serializeFlexibleType(@NotNull FlexibleType flexibleType, @NotNull ProtoBuf.Type.Builder lowerProto, @NotNull ProtoBuf.Type.Builder upperProto) {
        Intrinsics.checkNotNullParameter((Object)flexibleType, (String)"flexibleType");
        Intrinsics.checkNotNullParameter((Object)lowerProto, (String)"lowerProto");
        Intrinsics.checkNotNullParameter((Object)upperProto, (String)"upperProto");
        lowerProto.setFlexibleTypeCapabilitiesId(this.getStringTable().getStringIndex("kotlin.DynamicType"));
    }

    @Override
    public void serializeClass(@NotNull ClassDescriptor descriptor2, @NotNull ProtoBuf.Class.Builder proto, @NotNull MutableVersionRequirementTable versionRequirementTable, @NotNull DescriptorSerializer childSerializer) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)versionRequirementTable, (String)"versionRequirementTable");
        Intrinsics.checkNotNullParameter((Object)childSerializer, (String)"childSerializer");
        Integer id = this.getFileId(descriptor2);
        if (id != null) {
            proto.setExtension(JsProtoBuf.classContainingFileId, id);
        }
        super.serializeClass(descriptor2, proto, versionRequirementTable, childSerializer);
    }

    @Override
    public void serializeProperty(@NotNull PropertyDescriptor descriptor2, @NotNull ProtoBuf.Property.Builder proto, @Nullable MutableVersionRequirementTable versionRequirementTable, @NotNull DescriptorSerializer childSerializer) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)childSerializer, (String)"childSerializer");
        Integer id = this.getFileId(descriptor2);
        if (id != null) {
            proto.setExtension(JsProtoBuf.propertyContainingFileId, id);
        }
        super.serializeProperty(descriptor2, proto, versionRequirementTable, childSerializer);
    }

    @Override
    public void serializeFunction(@NotNull FunctionDescriptor descriptor2, @NotNull ProtoBuf.Function.Builder proto, @Nullable MutableVersionRequirementTable versionRequirementTable, @NotNull DescriptorSerializer childSerializer) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)childSerializer, (String)"childSerializer");
        Integer id = this.getFileId(descriptor2);
        if (id != null) {
            proto.setExtension(JsProtoBuf.functionContainingFileId, id);
        }
        super.serializeFunction(descriptor2, proto, versionRequirementTable, childSerializer);
    }

    private final Integer getFileId(DeclarationDescriptor descriptor2) {
        Integer n;
        SourceFile sourceFile;
        if (!DescriptorUtils.isTopLevelDeclaration(descriptor2) || !(descriptor2 instanceof DeclarationDescriptorWithSource)) {
            return null;
        }
        Integer fileId = KotlinJavascriptSerializationUtilKt.extractFileId(descriptor2);
        if (fileId != null) {
            KotlinJavascriptPackageFragment kotlinJavascriptPackageFragment;
            DeclarationDescriptor declarationDescriptor = ((DeclarationDescriptorWithSource)descriptor2).getContainingDeclaration();
            KotlinJavascriptPackageFragment kotlinJavascriptPackageFragment2 = kotlinJavascriptPackageFragment = declarationDescriptor instanceof KotlinJavascriptPackageFragment ? (KotlinJavascriptPackageFragment)declarationDescriptor : null;
            if (kotlinJavascriptPackageFragment != null) {
                KotlinJavascriptPackageFragment packageFragment = kotlinJavascriptPackageFragment;
                boolean bl = false;
                return this.fileRegistry.lookup(new KotlinDeserializedFileMetadata(packageFragment, fileId));
            }
        }
        PsiSourceFile psiSourceFile = (sourceFile = ((DeclarationDescriptorWithSource)descriptor2).getSource().getContainingFile()) instanceof PsiSourceFile ? (PsiSourceFile)sourceFile : null;
        if (psiSourceFile == null) {
            return null;
        }
        PsiSourceFile file2 = psiSourceFile;
        PsiFile psiFile = file2.getPsiFile();
        KtFile ktFile = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile != null) {
            KtFile it = ktFile;
            boolean bl = false;
            n = this.fileRegistry.lookup(new KotlinPsiFileMetadata(it));
        } else {
            n = null;
        }
        return n;
    }
}

