/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm.multiplatform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.builtins.PrimitiveType;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.load.java.components.JavaPropertyInitializerEvaluatorImpl;
import ksp.org.jetbrains.kotlin.load.java.sources.JavaSourceElement;
import ksp.org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import ksp.org.jetbrains.kotlin.load.java.structure.JavaAnnotationAsAnnotationArgument;
import ksp.org.jetbrains.kotlin.load.java.structure.JavaArrayAnnotationArgument;
import ksp.org.jetbrains.kotlin.load.java.structure.JavaArrayType;
import ksp.org.jetbrains.kotlin.load.java.structure.JavaClassObjectAnnotationArgument;
import ksp.org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import ksp.org.jetbrains.kotlin.load.java.structure.JavaElement;
import ksp.org.jetbrains.kotlin.load.java.structure.JavaEnumValueAnnotationArgument;
import ksp.org.jetbrains.kotlin.load.java.structure.JavaLiteralAnnotationArgument;
import ksp.org.jetbrains.kotlin.load.java.structure.JavaMethod;
import ksp.org.jetbrains.kotlin.load.java.structure.JavaPrimitiveType;
import ksp.org.jetbrains.kotlin.load.java.structure.JavaType;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.constants.ConstantValue;
import ksp.org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import ksp.org.jetbrains.kotlin.resolve.constants.EnumValue;
import ksp.org.jetbrains.kotlin.resolve.constants.KClassValue;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b*\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/multiplatform/JavaActualAnnotationArgumentExtractor;", "Lksp/org/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker$ActualAnnotationArgumentExtractor;", "()V", "convertTypeToKClassValue", "Lksp/org/jetbrains/kotlin/resolve/constants/KClassValue;", "javaType", "Lksp/org/jetbrains/kotlin/load/java/structure/JavaType;", "extractDefaultValue", "Lksp/org/jetbrains/kotlin/resolve/constants/ConstantValue;", "parameter", "Lksp/org/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "expectedType", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "convert", "Lksp/org/jetbrains/kotlin/load/java/structure/JavaAnnotationArgument;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nJavaActualAnnotationArgumentExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaActualAnnotationArgumentExtractor.kt\norg/jetbrains/kotlin/resolve/jvm/multiplatform/JavaActualAnnotationArgumentExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1601#2,9:89\n1853#2:98\n1854#2:100\n1610#2:101\n1#3:99\n*S KotlinDebug\n*F\n+ 1 JavaActualAnnotationArgumentExtractor.kt\norg/jetbrains/kotlin/resolve/jvm/multiplatform/JavaActualAnnotationArgumentExtractor\n*L\n46#1:89,9\n46#1:98\n46#1:100\n46#1:101\n46#1:99\n*E\n"})
public final class JavaActualAnnotationArgumentExtractor
implements ExpectedActualDeclarationChecker.ActualAnnotationArgumentExtractor {
    @Override
    @Nullable
    public ConstantValue<?> extractDefaultValue(@NotNull ValueParameterDescriptor parameter2, @NotNull KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        SourceElement sourceElement = parameter2.getSource();
        JavaSourceElement javaSourceElement = sourceElement instanceof JavaSourceElement ? (JavaSourceElement)sourceElement : null;
        JavaElement element2 = javaSourceElement != null ? javaSourceElement.getJavaElement() : null;
        Object object = element2 instanceof JavaMethod ? (JavaMethod)element2 : null;
        return object != null && (object = object.getAnnotationParameterDefaultValue()) != null ? this.convert((JavaAnnotationArgument)object, expectedType) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final ConstantValue<?> convert(JavaAnnotationArgument $this$convert, KotlinType expectedType) {
        ConstantValue constantValue;
        JavaAnnotationArgument javaAnnotationArgument = $this$convert;
        if (javaAnnotationArgument instanceof JavaLiteralAnnotationArgument) {
            Object object = ((JavaLiteralAnnotationArgument)$this$convert).getValue();
            if (object != null) {
                Object it = object;
                boolean bl = false;
                constantValue = JavaPropertyInitializerEvaluatorImpl.INSTANCE.convertLiteralValue$frontend_java(it, expectedType);
            } else {
                constantValue = null;
            }
        } else if (javaAnnotationArgument instanceof JavaEnumValueAnnotationArgument) {
            EnumValue enumValue;
            ClassId classId = ((JavaEnumValueAnnotationArgument)$this$convert).getEnumClassId();
            if (classId != null) {
                ClassId enumClassId = classId;
                boolean bl = false;
                Name name2 = ((JavaEnumValueAnnotationArgument)$this$convert).getEntryName();
                if (name2 != null) {
                    Name entryName = name2;
                    boolean bl2 = false;
                    enumValue = new EnumValue(enumClassId, entryName);
                } else {
                    enumValue = null;
                }
            } else {
                enumValue = null;
            }
            constantValue = enumValue;
        } else if (javaAnnotationArgument instanceof JavaArrayAnnotationArgument) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            KotlinType kotlinType = TypeUtilsKt.getBuiltIns(expectedType).getArrayElementType(expectedType);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getArrayElementType(...)");
            KotlinType elementType = kotlinType;
            Iterable iterable = ((JavaArrayAnnotationArgument)$this$convert).getElements();
            ConstantValueFactory constantValueFactory = ConstantValueFactory.INSTANCE;
            boolean $i$f$mapNotNull = false;
            void bl = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ConstantValue<?> it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl3 = false;
                JavaAnnotationArgument it = (JavaAnnotationArgument)element$iv$iv;
                boolean bl4 = false;
                if (this.convert(it, elementType) == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            constantValue = constantValueFactory.createArrayValue((List)destination$iv$iv, expectedType);
        } else {
            constantValue = javaAnnotationArgument instanceof JavaAnnotationAsAnnotationArgument ? null : (javaAnnotationArgument instanceof JavaClassObjectAnnotationArgument ? (ConstantValue)this.convertTypeToKClassValue(((JavaClassObjectAnnotationArgument)$this$convert).getReferencedType()) : null);
        }
        return constantValue;
    }

    private final KClassValue convertTypeToKClassValue(JavaType javaType) {
        KClassValue kClassValue;
        JavaType type2 = javaType;
        int arrayDimensions = 0;
        while (type2 instanceof JavaArrayType) {
            type2 = ((JavaArrayType)type2).getComponentType();
            ++arrayDimensions;
        }
        JavaType javaType2 = type2;
        if (javaType2 instanceof JavaPrimitiveType) {
            PrimitiveType primitiveType = ((JavaPrimitiveType)type2).getType();
            if (primitiveType == null) {
                FqName fqName2 = StandardNames.FqNames.unit.toSafe();
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"toSafe(...)");
                return new KClassValue(ClassId.Companion.topLevel(fqName2), 0);
            }
            PrimitiveType primitiveType2 = primitiveType;
            kClassValue = arrayDimensions > 0 ? new KClassValue(ClassId.Companion.topLevel(primitiveType2.getArrayTypeFqName()), arrayDimensions - 1) : new KClassValue(ClassId.Companion.topLevel(primitiveType2.getTypeFqName()), arrayDimensions);
        } else if (javaType2 instanceof JavaClassifierType) {
            FqName fqName3 = new FqName(((JavaClassifierType)type2).getClassifierQualifiedName());
            ClassId classId = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName3);
            if (classId == null) {
                classId = ClassId.Companion.topLevel(fqName3);
            }
            ClassId classId2 = classId;
            kClassValue = new KClassValue(classId2, arrayDimensions);
        } else {
            kClassValue = null;
        }
        return kClassValue;
    }
}

