/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import ksp.org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import ksp.org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.FqNamesUtilKt;
import ksp.org.jetbrains.kotlin.name.JvmStandardClassIds;
import ksp.org.jetbrains.kotlin.psi.KtAnnotated;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationEntry;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtFunction;
import ksp.org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import ksp.org.jetbrains.kotlin.psi.KtTypeAlias;
import ksp.org.jetbrains.kotlin.psi.ValueArgument;
import ksp.org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import ksp.org.jetbrains.kotlin.resolve.AnnotationChecker;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/checkers/FileClassAnnotationsChecker;", "Lksp/org/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "()V", "alwaysApplicable", "Ljava/util/HashSet;", "Lksp/org/jetbrains/kotlin/name/FqName;", "Lkotlin/collections/HashSet;", "checkEntries", "", "entries", "", "Lksp/org/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lksp/org/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "annotated", "Lksp/org/jetbrains/kotlin/psi/KtAnnotated;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nFileClassAnnotationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileClassAnnotationsChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/FileClassAnnotationsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1745#2,3:93\n1745#2,3:96\n*S KotlinDebug\n*F\n+ 1 FileClassAnnotationsChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/FileClassAnnotationsChecker\n*L\n60#1:93,3\n83#1:96,3\n*E\n"})
public final class FileClassAnnotationsChecker
implements AdditionalAnnotationChecker {
    @NotNull
    public static final FileClassAnnotationsChecker INSTANCE = new FileClassAnnotationsChecker();
    @NotNull
    private static final HashSet<FqName> alwaysApplicable;

    private FileClassAnnotationsChecker() {
    }

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace, @Nullable KtAnnotated annotated, @NotNull LanguageVersionSettings languageVersionSettings2) {
        KtAnnotationEntry entry;
        boolean isMultifileClass;
        ArrayList<Pair> fileAnnotationsToCheck;
        block13: {
            boolean bl;
            Intrinsics.checkNotNullParameter(entries, (String)"entries");
            Intrinsics.checkNotNullParameter(actualTargets, (String)"actualTargets");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
            fileAnnotationsToCheck = new ArrayList<Pair>();
            for (KtAnnotationEntry ktAnnotationEntry : entries) {
                Object classDescriptor3;
                Set<KotlinTarget> applicableTargets;
                AnnotationDescriptor descriptor2;
                KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = ktAnnotationEntry.getUseSiteTarget();
                if ((ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null) != AnnotationUseSiteTarget.FILE || (AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, ktAnnotationEntry) == null || DescriptorUtilsKt.getAnnotationClass(descriptor2) == null || (applicableTargets = AnnotationChecker.Companion.applicableTargetSetFromTargetAnnotationOrNull((ClassDescriptor)classDescriptor3)) == null || !applicableTargets.contains((Object)KotlinTarget.FILE)) continue;
                fileAnnotationsToCheck.add(new Pair((Object)ktAnnotationEntry, classDescriptor3));
            }
            Iterable iterable = fileAnnotationsToCheck;
            boolean $i$f$any = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : iterable) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)it.getSecond()), (Object)JvmStandardClassIds.INSTANCE.getJVM_MULTIFILE_CLASS())) continue;
                    bl = true;
                    break block13;
                }
                bl = isMultifileClass = false;
            }
        }
        if (isMultifileClass) {
            for (Pair pair : fileAnnotationsToCheck) {
                entry = (KtAnnotationEntry)pair.component1();
                ClassDescriptor classDescriptor2 = (ClassDescriptor)pair.component2();
                FqName classFqName = DescriptorUtilsKt.getFqNameSafe(classDescriptor2);
                if (alwaysApplicable.contains(classFqName) || DescriptorUtilsKt.getAnnotationRetention(classDescriptor2) == KotlinRetention.SOURCE) continue;
                trace.report(ErrorsJvm.ANNOTATION_IS_NOT_APPLICABLE_TO_MULTIFILE_CLASSES.on((KtAnnotationEntry)((PsiElement)entry), classFqName));
            }
        } else {
            for (Pair pair : fileAnnotationsToCheck) {
                boolean bl;
                block14: {
                    String value2;
                    Object[] stringTemplateEntries;
                    entry = (KtAnnotationEntry)pair.component1();
                    ClassDescriptor classDescriptor2 = (ClassDescriptor)pair.component2();
                    if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(classDescriptor2), (Object)JvmStandardClassIds.INSTANCE.getJVM_PACKAGE_NAME())) continue;
                    List<? extends ValueArgument> list2 = entry.getValueArguments();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueArguments(...)");
                    Object object = (ValueArgument)CollectionsKt.firstOrNull(list2);
                    if (object == null || (object = object.getArgumentExpression()) == null) continue;
                    Object argumentExpression = object;
                    Object[] objectArray = argumentExpression instanceof KtStringTemplateExpression ? (Object[])argumentExpression : null;
                    if (objectArray == null) continue;
                    if ((objectArray = objectArray.getEntries()) == null || (stringTemplateEntries = objectArray).length > 1) continue;
                    Object object2 = ArraysKt.singleOrNull((Object[])stringTemplateEntries);
                    KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = object2 instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)object2 : null;
                    String string2 = value2 = ktLiteralStringTemplateEntry != null ? ktLiteralStringTemplateEntry.getText() : null;
                    if (value2 == null) {
                        trace.report(ErrorsJvm.JVM_PACKAGE_NAME_CANNOT_BE_EMPTY.on((KtAnnotationEntry)((PsiElement)entry)));
                        continue;
                    }
                    if (!FqNamesUtilKt.isValidJavaFqName(value2)) {
                        trace.report(ErrorsJvm.JVM_PACKAGE_NAME_MUST_BE_VALID_NAME.on((KtAnnotationEntry)((PsiElement)entry)));
                        continue;
                    }
                    Iterable $this$any$iv = entry.getContainingKtFile().getDeclarations();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KtDeclaration it = (KtDeclaration)element$iv;
                            boolean bl3 = false;
                            if (!(!(it instanceof KtFunction) && !(it instanceof KtProperty) && !(it instanceof KtTypeAlias))) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                trace.report(ErrorsJvm.JVM_PACKAGE_NAME_NOT_SUPPORTED_IN_FILES_WITH_CLASSES.on((KtAnnotationEntry)((PsiElement)entry)));
            }
        }
    }

    static {
        Object[] objectArray = new FqName[]{JvmStandardClassIds.JVM_NAME, JvmStandardClassIds.INSTANCE.getJVM_MULTIFILE_CLASS()};
        alwaysApplicable = SetsKt.hashSetOf((Object[])objectArray);
    }
}

