/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.platform.TargetPlatformKt;
import ksp.org.jetbrains.kotlin.psi.KtFile;
import ksp.org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.checkers.UsageCheckerUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.multiplatform.IsCommonSourceKt;
import ksp.org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/OptionalExpectationUsageChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "()V", "check", "", "targetDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend"})
public final class OptionalExpectationUsageChecker
implements ClassifierUsageChecker {
    @Override
    public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element2, @NotNull ClassifierUsageCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)targetDescriptor, (String)"targetDescriptor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!OptionalAnnotationUtil.isOptionalAnnotationClass(targetDescriptor)) {
            return;
        }
        if (!UsageCheckerUtilsKt.isUsageAsAnnotationOrImport(element2)) {
            context2.getTrace().report(Errors.OPTIONAL_DECLARATION_OUTSIDE_OF_ANNOTATION_ENTRY.on(element2));
        }
        PsiFile psiFile = element2.getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        KtFile ktFile = (KtFile)psiFile;
        if (!Intrinsics.areEqual((Object)IsCommonSourceKt.isCommonSource(ktFile), (Object)true) && !TargetPlatformKt.isCommon(DescriptorUtilsKt.getPlatform(targetDescriptor))) {
            context2.getTrace().report(Errors.OPTIONAL_DECLARATION_USAGE_IN_NON_COMMON_SOURCE.on(element2));
        }
    }
}

