/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ArgumentPassedTwice;
import ksp.org.jetbrains.kotlin.resolve.calls.model.KotlinCall;
import ksp.org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import ksp.org.jetbrains.kotlin.resolve.calls.model.MixingNamedAndPositionArguments;
import ksp.org.jetbrains.kotlin.resolve.calls.model.NameForAmbiguousParameter;
import ksp.org.jetbrains.kotlin.resolve.calls.model.NameNotFound;
import ksp.org.jetbrains.kotlin.resolve.calls.model.NamedArgumentNotAllowed;
import ksp.org.jetbrains.kotlin.resolve.calls.model.NamedArgumentReference;
import ksp.org.jetbrains.kotlin.resolve.calls.model.NoValueForParameter;
import ksp.org.jetbrains.kotlin.resolve.calls.model.NonVarargSpread;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCallArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.TooManyArguments;
import ksp.org.jetbrains.kotlin.resolve.calls.model.VarargArgumentOutsideParentheses;
import ksp.org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u000b\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper;", "", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "EmptyArgumentMapping", "Lksp/org/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$ArgumentMapping;", "getEmptyArgumentMapping", "()Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$ArgumentMapping;", "allowMixedNamedAndPositionArguments", "", "mapArguments", "argumentsInParenthesis", "", "Lksp/org/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "externalArgument", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/CallableDescriptor;", "call", "Lksp/org/jetbrains/kotlin/resolve/calls/model/KotlinCall;", "ArgumentMapping", "CallArgumentProcessor", "resolution"})
public final class ArgumentsToParametersMapper {
    private final boolean allowMixedNamedAndPositionArguments;
    @NotNull
    private final ArgumentMapping EmptyArgumentMapping;

    public ArgumentsToParametersMapper(@NotNull LanguageVersionSettings languageVersionSettings2) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        this.allowMixedNamedAndPositionArguments = languageVersionSettings2.supportsFeature(LanguageFeature.MixedNamedArgumentsInTheirOwnPosition);
        this.EmptyArgumentMapping = new ArgumentMapping(MapsKt.emptyMap(), CollectionsKt.emptyList());
    }

    @NotNull
    public final ArgumentMapping getEmptyArgumentMapping() {
        return this.EmptyArgumentMapping;
    }

    @NotNull
    public final ArgumentMapping mapArguments(@NotNull KotlinCall call2, @NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return this.mapArguments(call2.getArgumentsInParenthesis(), call2.getExternalArgument(), descriptor2);
    }

    @NotNull
    public final ArgumentMapping mapArguments(@NotNull List<? extends KotlinCallArgument> argumentsInParenthesis, @Nullable KotlinCallArgument externalArgument, @NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(argumentsInParenthesis, (String)"argumentsInParenthesis");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (argumentsInParenthesis.isEmpty() && externalArgument == null && descriptor2.getValueParameters().isEmpty()) {
            return this.EmptyArgumentMapping;
        }
        CallArgumentProcessor processor2 = new CallArgumentProcessor(descriptor2, this.allowMixedNamedAndPositionArguments);
        processor2.processArgumentsInParenthesis(argumentsInParenthesis);
        if (externalArgument != null) {
            processor2.processExternalArgument(externalArgument);
        }
        processor2.processDefaultsAndRunChecks();
        return new ArgumentMapping(AddToStdlibKt.compactIfPossible(processor2.getResult()), processor2.getDiagnostics());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J/\u0010\u0010\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$ArgumentMapping;", "", "parameterToCallArgumentMap", "", "Lksp/org/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCallArgument;", "diagnostics", "", "Lksp/org/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "(Ljava/util/Map;Ljava/util/List;)V", "getDiagnostics", "()Ljava/util/List;", "getParameterToCallArgumentMap", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "resolution"})
    public static final class ArgumentMapping {
        @NotNull
        private final Map<ValueParameterDescriptor, ResolvedCallArgument> parameterToCallArgumentMap;
        @NotNull
        private final List<KotlinCallDiagnostic> diagnostics;

        public ArgumentMapping(@NotNull Map<ValueParameterDescriptor, ? extends ResolvedCallArgument> parameterToCallArgumentMap, @NotNull List<? extends KotlinCallDiagnostic> diagnostics2) {
            Intrinsics.checkNotNullParameter(parameterToCallArgumentMap, (String)"parameterToCallArgumentMap");
            Intrinsics.checkNotNullParameter(diagnostics2, (String)"diagnostics");
            this.parameterToCallArgumentMap = parameterToCallArgumentMap;
            this.diagnostics = diagnostics2;
        }

        @NotNull
        public final Map<ValueParameterDescriptor, ResolvedCallArgument> getParameterToCallArgumentMap() {
            return this.parameterToCallArgumentMap;
        }

        @NotNull
        public final List<KotlinCallDiagnostic> getDiagnostics() {
            return this.diagnostics;
        }

        @NotNull
        public final Map<ValueParameterDescriptor, ResolvedCallArgument> component1() {
            return this.parameterToCallArgumentMap;
        }

        @NotNull
        public final List<KotlinCallDiagnostic> component2() {
            return this.diagnostics;
        }

        @NotNull
        public final ArgumentMapping copy(@NotNull Map<ValueParameterDescriptor, ? extends ResolvedCallArgument> parameterToCallArgumentMap, @NotNull List<? extends KotlinCallDiagnostic> diagnostics2) {
            Intrinsics.checkNotNullParameter(parameterToCallArgumentMap, (String)"parameterToCallArgumentMap");
            Intrinsics.checkNotNullParameter(diagnostics2, (String)"diagnostics");
            return new ArgumentMapping(parameterToCallArgumentMap, diagnostics2);
        }

        public static /* synthetic */ ArgumentMapping copy$default(ArgumentMapping argumentMapping2, Map map, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                map = argumentMapping2.parameterToCallArgumentMap;
            }
            if ((n & 2) != 0) {
                list2 = argumentMapping2.diagnostics;
            }
            return argumentMapping2.copy(map, list2);
        }

        @NotNull
        public String toString() {
            return "ArgumentMapping(parameterToCallArgumentMap=" + this.parameterToCallArgumentMap + ", diagnostics=" + this.diagnostics + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.parameterToCallArgumentMap).hashCode();
            result2 = result2 * 31 + ((Object)this.diagnostics).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArgumentMapping)) {
                return false;
            }
            ArgumentMapping argumentMapping2 = (ArgumentMapping)other;
            if (!Intrinsics.areEqual(this.parameterToCallArgumentMap, argumentMapping2.parameterToCallArgumentMap)) {
                return false;
            }
            return Intrinsics.areEqual(this.diagnostics, argumentMapping2.diagnostics);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0012\b\u0002\u0018\u00002\u00020\u0001:\u00013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\rH\u0002J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020 H\u0002J\b\u0010&\u001a\u00020\"H\u0002J\u001a\u0010'\u001a\u0004\u0018\u00010\u00132\u0006\u0010%\u001a\u00020 2\u0006\u0010(\u001a\u00020\u0012H\u0002J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0\u0015J\u0012\u0010*\u001a\u0004\u0018\u00010\u00132\u0006\u0010(\u001a\u00020\u0012H\u0002J\u0014\u0010+\u001a\u00020\"2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020 0\u0015J\u0006\u0010-\u001a\u00020\"J\u000e\u0010.\u001a\u00020\"2\u0006\u0010/\u001a\u00020 J\u0018\u00100\u001a\u00020\"2\u0006\u0010%\u001a\u00020 2\u0006\u0010(\u001a\u00020\u0012H\u0002J\u0010\u00101\u001a\u00020\u00052\u0006\u0010%\u001a\u00020 H\u0002J\u000e\u00102\u001a\u0004\u0018\u00010\u0013*\u00020\u0013H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$CallArgumentProcessor;", "", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/CallableDescriptor;", "languageSettingsAllowMixedNamedAndPositionArguments", "", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Z)V", "currentPositionedParameterIndex", "", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "diagnostics", "", "Lksp/org/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "getLanguageSettingsAllowMixedNamedAndPositionArguments", "()Z", "nameToParameter", "", "Lksp/org/jetbrains/kotlin/name/Name;", "Lksp/org/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameters", "", "getParameters", "()Ljava/util/List;", "result", "", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCallArgument;", "getResult", "()Ljava/util/Map;", "state", "Lksp/org/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$CallArgumentProcessor$State;", "varargArguments", "Lksp/org/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "addDiagnostic", "", "diagnostic", "addVarargArgument", "argument", "completeVarargPositionArguments", "findParameterByName", "name", "getDiagnostics", "getParameterByName", "processArgumentsInParenthesis", "arguments", "processDefaultsAndRunChecks", "processExternalArgument", "externalArgument", "processNamedArgument", "processPositionArgument", "getOverriddenParameterWithOtherName", "State", "resolution"})
    @SourceDebugExtension(value={"SMAP\nArgumentsToParametersMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArgumentsToParametersMapper.kt\norg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$CallArgumentProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,279:1\n1192#2,2:280\n1220#2,4:282\n288#2,2:287\n288#2,2:289\n1#3:286\n*S KotlinDebug\n*F\n+ 1 ArgumentsToParametersMapper.kt\norg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$CallArgumentProcessor\n*L\n96#1:280,2\n96#1:282,4\n172#1:287,2\n182#1:289,2\n*E\n"})
    private static final class CallArgumentProcessor {
        @NotNull
        private final CallableDescriptor descriptor;
        private final boolean languageSettingsAllowMixedNamedAndPositionArguments;
        @NotNull
        private final Map<ValueParameterDescriptor, ResolvedCallArgument> result;
        @NotNull
        private State state;
        @Nullable
        private List<KotlinCallDiagnostic> diagnostics;
        @Nullable
        private Map<Name, ? extends ValueParameterDescriptor> nameToParameter;
        @Nullable
        private List<KotlinCallArgument> varargArguments;
        private int currentPositionedParameterIndex;

        public CallArgumentProcessor(@NotNull CallableDescriptor descriptor2, boolean languageSettingsAllowMixedNamedAndPositionArguments) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            this.descriptor = descriptor2;
            this.languageSettingsAllowMixedNamedAndPositionArguments = languageSettingsAllowMixedNamedAndPositionArguments;
            this.result = new LinkedHashMap();
            this.state = State.POSITION_ARGUMENTS;
        }

        @NotNull
        public final CallableDescriptor getDescriptor() {
            return this.descriptor;
        }

        public final boolean getLanguageSettingsAllowMixedNamedAndPositionArguments() {
            return this.languageSettingsAllowMixedNamedAndPositionArguments;
        }

        @NotNull
        public final Map<ValueParameterDescriptor, ResolvedCallArgument> getResult() {
            return this.result;
        }

        private final List<ValueParameterDescriptor> getParameters() {
            List<ValueParameterDescriptor> list2 = this.descriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueParameters(...)");
            return list2;
        }

        private final void addDiagnostic(KotlinCallDiagnostic diagnostic) {
            if (this.diagnostics == null) {
                this.diagnostics = new ArrayList();
            }
            List<KotlinCallDiagnostic> list2 = this.diagnostics;
            Intrinsics.checkNotNull(list2);
            list2.add(diagnostic);
        }

        @NotNull
        public final List<KotlinCallDiagnostic> getDiagnostics() {
            List list2 = this.diagnostics;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }

        /*
         * WARNING - void declaration
         */
        private final ValueParameterDescriptor getParameterByName(Name name2) {
            if (this.nameToParameter == null) {
                void $this$associateByTo$iv$iv;
                void $this$associateBy$iv;
                Iterable iterable = this.getParameters();
                CallArgumentProcessor callArgumentProcessor = this;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                void var5_6 = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl = false;
                    Name name3 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"getName(...)");
                    map.put(name3, element$iv$iv);
                }
                callArgumentProcessor.nameToParameter = destination$iv$iv;
            }
            Map<Name, ? extends ValueParameterDescriptor> map = this.nameToParameter;
            Intrinsics.checkNotNull(map);
            return map.get(name2);
        }

        private final void addVarargArgument(KotlinCallArgument argument2) {
            if (this.varargArguments == null) {
                this.varargArguments = new ArrayList();
            }
            List<KotlinCallArgument> list2 = this.varargArguments;
            Intrinsics.checkNotNull(list2);
            list2.add(argument2);
        }

        private final void completeVarargPositionArguments() {
            boolean bl;
            boolean bl2 = bl = this.state == State.VARARG_POSITION;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Incorrect state: " + (Object)((Object)this.state);
                throw new AssertionError((Object)string2);
            }
            ValueParameterDescriptor parameter2 = this.getParameters().get(this.currentPositionedParameterIndex);
            ValueParameterDescriptor valueParameterDescriptor = parameter2.getOriginal();
            List<KotlinCallArgument> list2 = this.varargArguments;
            Intrinsics.checkNotNull(list2);
            this.result.put(valueParameterDescriptor, new ResolvedCallArgument.VarargArgument(list2));
        }

        private final boolean processPositionArgument(KotlinCallArgument argument2) {
            if (this.state == State.NAMED_ONLY_ARGUMENTS) {
                this.addDiagnostic(new MixingNamedAndPositionArguments(argument2));
                return false;
            }
            ValueParameterDescriptor parameter2 = (ValueParameterDescriptor)CollectionsKt.getOrNull(this.getParameters(), (int)this.currentPositionedParameterIndex);
            if (parameter2 == null) {
                this.addDiagnostic(new TooManyArguments(argument2, this.descriptor));
                return false;
            }
            if (!ArgumentsUtilsKt.isVararg(parameter2)) {
                int n = this.currentPositionedParameterIndex;
                this.currentPositionedParameterIndex = n + 1;
                this.result.put(parameter2.getOriginal(), new ResolvedCallArgument.SimpleArgument(argument2));
                return false;
            }
            this.addVarargArgument(argument2);
            return true;
        }

        private final void processNamedArgument(KotlinCallArgument argument2, Name name2) {
            if (!this.descriptor.hasStableParameterNames()) {
                this.addDiagnostic(new NamedArgumentNotAllowed(argument2, this.descriptor));
            }
            boolean stateAllowsMixedNamedAndPositionArguments = this.state != State.NAMED_ONLY_ARGUMENTS;
            this.state = State.NAMED_ONLY_ARGUMENTS;
            ValueParameterDescriptor valueParameterDescriptor = this.findParameterByName(argument2, name2);
            if (valueParameterDescriptor == null) {
                return;
            }
            ValueParameterDescriptor parameter2 = valueParameterDescriptor;
            this.addDiagnostic(new NamedArgumentReference(argument2, parameter2));
            ResolvedCallArgument resolvedCallArgument = this.result.get(parameter2.getOriginal());
            if (resolvedCallArgument != null) {
                ResolvedCallArgument it = resolvedCallArgument;
                boolean bl = false;
                this.addDiagnostic(new ArgumentPassedTwice(argument2, parameter2, it));
                return;
            }
            this.result.put(parameter2.getOriginal(), new ResolvedCallArgument.SimpleArgument(argument2));
            if (stateAllowsMixedNamedAndPositionArguments && this.languageSettingsAllowMixedNamedAndPositionArguments) {
                ValueParameterDescriptor valueParameterDescriptor2 = (ValueParameterDescriptor)CollectionsKt.getOrNull(this.getParameters(), (int)this.currentPositionedParameterIndex);
                if (Intrinsics.areEqual((Object)(valueParameterDescriptor2 != null ? valueParameterDescriptor2.getOriginal() : null), (Object)parameter2.getOriginal())) {
                    this.state = State.POSITION_ARGUMENTS;
                    int n = this.currentPositionedParameterIndex;
                    this.currentPositionedParameterIndex = n + 1;
                }
            }
        }

        private final ValueParameterDescriptor getOverriddenParameterWithOtherName(ValueParameterDescriptor $this$getOverriddenParameterWithOtherName) {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = $this$getOverriddenParameterWithOtherName.getOverriddenDescriptors();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl = false;
                    if (!(it.getContainingDeclaration().hasStableParameterNames() && !Intrinsics.areEqual((Object)it.getName(), (Object)$this$getOverriddenParameterWithOtherName.getName()))) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private final ValueParameterDescriptor findParameterByName(KotlinCallArgument argument2, Name name2) {
            ValueParameterDescriptor parameter2 = this.getParameterByName(name2);
            if (this.descriptor instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)this.descriptor).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                if (parameter2 == null) {
                    for (ValueParameterDescriptor valueParameter2 : ((CallableMemberDescriptor)this.descriptor).getValueParameters()) {
                        ValueParameterDescriptor matchedParameter;
                        Object v0;
                        block7: {
                            Iterable $this$firstOrNull$iv = valueParameter2.getOverriddenDescriptors();
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                                boolean bl = false;
                                if (!(it.getContainingDeclaration().hasStableParameterNames() && Intrinsics.areEqual((Object)it.getName(), (Object)name2))) continue;
                                v0 = element$iv;
                                break block7;
                            }
                            v0 = null;
                        }
                        if ((matchedParameter = (ValueParameterDescriptor)v0) == null) continue;
                        Intrinsics.checkNotNull((Object)valueParameter2);
                        this.addDiagnostic(new NamedArgumentReference(argument2, valueParameter2));
                        this.addDiagnostic(new NameForAmbiguousParameter(argument2, valueParameter2, matchedParameter));
                        return valueParameter2;
                    }
                } else {
                    ValueParameterDescriptor valueParameterDescriptor = this.getOverriddenParameterWithOtherName(parameter2);
                    if (valueParameterDescriptor != null) {
                        ValueParameterDescriptor it = valueParameterDescriptor;
                        boolean bl = false;
                        this.addDiagnostic(new NameForAmbiguousParameter(argument2, parameter2, it));
                    }
                }
            }
            if (parameter2 == null) {
                this.addDiagnostic(new NameNotFound(argument2, this.descriptor));
            }
            return parameter2;
        }

        public final void processArgumentsInParenthesis(@NotNull List<? extends KotlinCallArgument> arguments2) {
            Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
            for (KotlinCallArgument kotlinCallArgument : arguments2) {
                Name argumentName = kotlinCallArgument.getArgumentName();
                if (argumentName == null) {
                    if (!this.processPositionArgument(kotlinCallArgument)) continue;
                    this.state = State.VARARG_POSITION;
                    continue;
                }
                if (this.state == State.VARARG_POSITION) {
                    this.completeVarargPositionArguments();
                }
                this.processNamedArgument(kotlinCallArgument, argumentName);
            }
            if (this.state == State.VARARG_POSITION) {
                this.completeVarargPositionArguments();
            }
        }

        public final void processExternalArgument(@NotNull KotlinCallArgument externalArgument) {
            Intrinsics.checkNotNullParameter((Object)externalArgument, (String)"externalArgument");
            ValueParameterDescriptor lastParameter = (ValueParameterDescriptor)CollectionsKt.lastOrNull(this.getParameters());
            if (lastParameter == null) {
                this.addDiagnostic(new TooManyArguments(externalArgument, this.descriptor));
                return;
            }
            if (ArgumentsUtilsKt.isVararg(lastParameter)) {
                this.addDiagnostic(new VarargArgumentOutsideParentheses(externalArgument, lastParameter));
                return;
            }
            ResolvedCallArgument previousOccurrence = this.result.get(lastParameter.getOriginal());
            if (previousOccurrence != null) {
                this.addDiagnostic(new TooManyArguments(externalArgument, this.descriptor));
                return;
            }
            this.result.put(lastParameter.getOriginal(), new ResolvedCallArgument.SimpleArgument(externalArgument));
        }

        public final void processDefaultsAndRunChecks() {
            for (Map.Entry<ValueParameterDescriptor, ResolvedCallArgument> entry : this.result.entrySet()) {
                ValueParameterDescriptor parameter2 = entry.getKey();
                ResolvedCallArgument resolvedArgument = entry.getValue();
                if (ArgumentsUtilsKt.isVararg(parameter2)) continue;
                if (!(resolvedArgument instanceof ResolvedCallArgument.SimpleArgument)) {
                    throw new IllegalStateException(("Incorrect resolved argument for parameter " + parameter2 + " :" + resolvedArgument).toString());
                }
                if (!((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument().isSpread()) continue;
                this.addDiagnostic(new NonVarargSpread(((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument()));
            }
            for (ValueParameterDescriptor parameter3 : this.getParameters()) {
                if (this.result.containsKey(parameter3.getOriginal())) continue;
                if (ArgumentsUtilsKt.hasDefaultValue(parameter3)) {
                    this.result.put(parameter3.getOriginal(), ResolvedCallArgument.DefaultArgument.INSTANCE);
                    continue;
                }
                if (ArgumentsUtilsKt.isVararg(parameter3)) {
                    this.result.put(parameter3.getOriginal(), new ResolvedCallArgument.VarargArgument(CollectionsKt.emptyList()));
                    continue;
                }
                this.addDiagnostic(new NoValueForParameter(parameter3, this.descriptor));
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$CallArgumentProcessor$State;", "", "(Ljava/lang/String;I)V", "POSITION_ARGUMENTS", "VARARG_POSITION", "NAMED_ONLY_ARGUMENTS", "resolution"})
        private static final class State
        extends Enum<State> {
            public static final /* enum */ State POSITION_ARGUMENTS = new State();
            public static final /* enum */ State VARARG_POSITION = new State();
            public static final /* enum */ State NAMED_ONLY_ARGUMENTS = new State();
            private static final /* synthetic */ State[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value2) {
                return Enum.valueOf(State.class, value2);
            }

            @NotNull
            public static EnumEntries<State> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = stateArray = new State[]{State.POSITION_ARGUMENTS, State.VARARG_POSITION, State.NAMED_ONLY_ARGUMENTS};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

