/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.impl.source.tree.LeafPsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableTypeConstructor;
import ksp.org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCallArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl;
import ksp.org.jetbrains.kotlin.resolve.calls.tower.SimplePSIKotlinCallArgument;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import ksp.org.jetbrains.kotlin.types.FlexibleType;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.TypeUtils;
import ksp.org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/NullableVarargArgumentCallChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class NullableVarargArgumentCallChecker
implements CallChecker {
    @NotNull
    public static final NullableVarargArgumentCallChecker INSTANCE = new NullableVarargArgumentCallChecker();

    private NullableVarargArgumentCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference)) {
            return;
        }
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            this.check(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall(), reportOn, context2);
            return;
        }
        if (!(resolvedCall2 instanceof NewResolvedCallImpl)) {
            return;
        }
        for (ResolvedCallArgument argument2 : ((NewResolvedCallImpl)resolvedCall2).getArgumentMappingByOriginal().values()) {
            for (KotlinCallArgument arg : argument2.getArguments()) {
                LeafPsiElement spreadElement;
                KotlinType type2;
                Object object;
                if (!arg.isSpread() || !(arg instanceof SimplePSIKotlinCallArgument) || ((SimplePSIKotlinCallArgument)arg).getValueArgument().getSpreadElement() == null) continue;
                ReceiverValueWithSmartCastInfo receiver = ((SimplePSIKotlinCallArgument)arg).getReceiver();
                if (ArgumentsUtilsKt.getStableType(receiver).getConstructor() instanceof TypeVariableTypeConstructor) {
                    object = (KotlinTypeInfo)context2.getTrace().getBindingContext().get(BindingContext.EXPRESSION_TYPE_INFO, ((SimplePSIKotlinCallArgument)arg).getValueArgument().getArgumentExpression());
                    if (object == null || (object = ((KotlinTypeInfo)object).getType()) == null) {
                        object = ArgumentsUtilsKt.getStableType(receiver);
                    }
                } else {
                    object = ArgumentsUtilsKt.getStableType(receiver);
                }
                if ((type2 = object) instanceof FlexibleType || !TypeUtils.isNullableType(type2)) continue;
                context2.getTrace().report(Errors.SPREAD_OF_NULLABLE.on((LeafPsiElement)((PsiElement)spreadElement)));
            }
        }
    }
}

