/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.ir.overrides;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.overrides.IrExternalOverridabilityCondition;
import ksp.org.jetbrains.kotlin.ir.overrides.IrOverrideCheckerKt;
import ksp.org.jetbrains.kotlin.ir.overrides.MemberWithOriginal;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeCheckerStateKt;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeSystemContextWithAdditionalAxioms;
import ksp.org.jetbrains.kotlin.resolve.OverridingUtil;
import ksp.org.jetbrains.kotlin.types.AbstractTypeChecker;
import ksp.org.jetbrains.kotlin.types.TypeCheckerState;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\tJ \u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\tH\u0002J \u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0015H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lksp/org/jetbrains/kotlin/ir/overrides/IrOverrideChecker;", "", "typeSystem", "Lksp/org/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "externalOverridabilityConditions", "", "Lksp/org/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition;", "(Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;Ljava/util/List;)V", "areTypeParametersEquivalent", "", "superTypeParameter", "Lksp/org/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "subTypeParameter", "typeCheckerState", "Lksp/org/jetbrains/kotlin/types/TypeCheckerState;", "getBothWaysOverridability", "Lksp/org/jetbrains/kotlin/resolve/OverridingUtil$OverrideCompatibilityInfo$Result;", "overrider", "Lksp/org/jetbrains/kotlin/ir/overrides/MemberWithOriginal;", "candidate", "isOverridableBy", "Lksp/org/jetbrains/kotlin/resolve/OverridingUtil$OverrideCompatibilityInfo;", "superMember", "subMember", "checkIsInlineFlag", "isOverridableByWithoutExternalConditions", "Lksp/org/jetbrains/kotlin/ir/declarations/IrOverridableMember;", "runExternalOverridabilityConditions", "basicResult", "ir.tree"})
public final class IrOverrideChecker {
    @NotNull
    private final IrTypeSystemContext typeSystem;
    @NotNull
    private final List<IrExternalOverridabilityCondition> externalOverridabilityConditions;

    public IrOverrideChecker(@NotNull IrTypeSystemContext typeSystem, @NotNull List<? extends IrExternalOverridabilityCondition> externalOverridabilityConditions) {
        Intrinsics.checkNotNullParameter((Object)typeSystem, (String)"typeSystem");
        Intrinsics.checkNotNullParameter(externalOverridabilityConditions, (String)"externalOverridabilityConditions");
        this.typeSystem = typeSystem;
        this.externalOverridabilityConditions = externalOverridabilityConditions;
    }

    @NotNull
    public final OverridingUtil.OverrideCompatibilityInfo.Result getBothWaysOverridability(@NotNull MemberWithOriginal overrider, @NotNull MemberWithOriginal candidate2) {
        Intrinsics.checkNotNullParameter((Object)overrider, (String)"overrider");
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        OverridingUtil.OverrideCompatibilityInfo.Result result2 = this.isOverridableBy(candidate2, overrider, false).getResult();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)result2), (String)"getResult(...)");
        OverridingUtil.OverrideCompatibilityInfo.Result result1 = result2;
        OverridingUtil.OverrideCompatibilityInfo.Result result3 = this.isOverridableBy(overrider, candidate2, false).getResult();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)result3), (String)"getResult(...)");
        OverridingUtil.OverrideCompatibilityInfo.Result result22 = result3;
        return result1 == result22 ? result1 : OverridingUtil.OverrideCompatibilityInfo.Result.INCOMPATIBLE;
    }

    @NotNull
    public final OverridingUtil.OverrideCompatibilityInfo isOverridableBy(@NotNull MemberWithOriginal superMember, @NotNull MemberWithOriginal subMember, boolean checkIsInlineFlag) {
        Intrinsics.checkNotNullParameter((Object)superMember, (String)"superMember");
        Intrinsics.checkNotNullParameter((Object)subMember, (String)"subMember");
        OverridingUtil.OverrideCompatibilityInfo basicResult2 = this.isOverridableByWithoutExternalConditions(superMember.getMember(), subMember.getMember(), checkIsInlineFlag);
        return this.runExternalOverridabilityConditions(superMember, subMember, basicResult2);
    }

    private final OverridingUtil.OverrideCompatibilityInfo isOverridableByWithoutExternalConditions(IrOverridableMember superMember, IrOverridableMember subMember, boolean checkIsInlineFlag) {
        int index2;
        List<IrTypeParameter> superTypeParameters = null;
        List<IrTypeParameter> subTypeParameters = null;
        List superValueParameters = null;
        List subValueParameters = null;
        IrOverridableMember irOverridableMember = superMember;
        if (irOverridableMember instanceof IrSimpleFunction) {
            if (!(subMember instanceof IrSimpleFunction)) {
                OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Member kind mismatch");
                Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                return overrideCompatibilityInfo;
            }
            if (IrOverrideCheckerKt.access$getHasExtensionReceiver((IrSimpleFunction)superMember) != IrOverrideCheckerKt.access$getHasExtensionReceiver((IrSimpleFunction)subMember)) {
                OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Receiver presence mismatch");
                Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                return overrideCompatibilityInfo;
            }
            if (((IrSimpleFunction)superMember).isSuspend() != ((IrSimpleFunction)subMember).isSuspend()) {
                OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Incompatible suspendability");
                Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                return overrideCompatibilityInfo;
            }
            if (checkIsInlineFlag && ((IrSimpleFunction)superMember).isInline()) {
                OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Inline function can't be overridden");
                Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                return overrideCompatibilityInfo;
            }
            superTypeParameters = ((IrSimpleFunction)superMember).getTypeParameters();
            subTypeParameters = ((IrSimpleFunction)subMember).getTypeParameters();
            superValueParameters = IrOverrideCheckerKt.access$getCompiledValueParameters((IrSimpleFunction)superMember);
            subValueParameters = IrOverrideCheckerKt.access$getCompiledValueParameters((IrSimpleFunction)subMember);
        } else if (irOverridableMember instanceof IrProperty) {
            if (!(subMember instanceof IrProperty)) {
                OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Member kind mismatch");
                Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                return overrideCompatibilityInfo;
            }
            if (IrOverrideCheckerKt.access$getHasExtensionReceiver(((IrProperty)superMember).getGetter()) != IrOverrideCheckerKt.access$getHasExtensionReceiver(((IrProperty)subMember).getGetter())) {
                OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Receiver presence mismatch");
                Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                return overrideCompatibilityInfo;
            }
            if (checkIsInlineFlag && IrOverrideCheckerKt.access$isInline((IrProperty)superMember)) {
                OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Inline property can't be overridden");
                Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                return overrideCompatibilityInfo;
            }
            superTypeParameters = IrOverrideCheckerKt.access$getTypeParameters((IrProperty)superMember);
            subTypeParameters = IrOverrideCheckerKt.access$getTypeParameters((IrProperty)subMember);
            superValueParameters = IrOverrideCheckerKt.access$getCompiledValueParameters((IrProperty)superMember);
            subValueParameters = IrOverrideCheckerKt.access$getCompiledValueParameters((IrProperty)subMember);
        } else {
            throw new IllegalStateException(("Unexpected type of declaration: " + superMember.getClass() + ", " + superMember).toString());
        }
        if (!Intrinsics.areEqual((Object)superMember.getName(), (Object)subMember.getName())) {
            OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Name mismatch");
            Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
            return overrideCompatibilityInfo;
        }
        if (superTypeParameters.size() != subTypeParameters.size()) {
            OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Type parameter number mismatch");
            Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
            return overrideCompatibilityInfo;
        }
        if (superValueParameters.size() != subValueParameters.size()) {
            OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Value parameter number mismatch");
            Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
            return overrideCompatibilityInfo;
        }
        TypeCheckerState typeCheckerState2 = IrTypeCheckerStateKt.createIrTypeCheckerState(new IrTypeSystemContextWithAdditionalAxioms(this.typeSystem, superTypeParameters, subTypeParameters));
        Iterator iterator2 = ((Iterable)superTypeParameters).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            index2 = n++;
            IrTypeParameter superTypeParameter = (IrTypeParameter)iterator2.next();
            if (this.areTypeParametersEquivalent(superTypeParameter, subTypeParameters.get(index2), typeCheckerState2)) continue;
            OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Type parameter bounds mismatch");
            Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
            return overrideCompatibilityInfo;
        }
        iterator2 = ((Iterable)superValueParameters).iterator();
        n = 0;
        while (iterator2.hasNext()) {
            index2 = n++;
            IrValueParameter superValueParameter = (IrValueParameter)iterator2.next();
            if (AbstractTypeChecker.INSTANCE.equalTypes(typeCheckerState2, ((IrValueParameter)subValueParameters.get(index2)).getType(), superValueParameter.getType())) continue;
            OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Value parameter type mismatch");
            Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
            return overrideCompatibilityInfo;
        }
        OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.success();
        Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"success(...)");
        return overrideCompatibilityInfo;
    }

    private final boolean areTypeParametersEquivalent(IrTypeParameter superTypeParameter, IrTypeParameter subTypeParameter, TypeCheckerState typeCheckerState2) {
        List<IrType> superBounds = superTypeParameter.getSuperTypes();
        List subBounds = CollectionsKt.toMutableList((Collection)subTypeParameter.getSuperTypes());
        if (superBounds.size() != subBounds.size()) {
            return false;
        }
        block0: for (IrType superBound : superBounds) {
            ListIterator it = subBounds.listIterator();
            while (it.hasNext()) {
                IrType subBound = (IrType)it.next();
                if (!AbstractTypeChecker.INSTANCE.equalTypes(typeCheckerState2, superBound, subBound)) continue;
                it.remove();
                continue block0;
            }
            return false;
        }
        return true;
    }

    private final OverridingUtil.OverrideCompatibilityInfo runExternalOverridabilityConditions(MemberWithOriginal superMember, MemberWithOriginal subMember, OverridingUtil.OverrideCompatibilityInfo basicResult2) {
        IrExternalOverridabilityCondition.Result result2;
        boolean wasSuccess = basicResult2.getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE;
        block8: for (IrExternalOverridabilityCondition externalCondition : this.externalOverridabilityConditions) {
            if (externalCondition.getContract() == IrExternalOverridabilityCondition.Contract.CONFLICTS_ONLY || wasSuccess && externalCondition.getContract() == IrExternalOverridabilityCondition.Contract.SUCCESS_ONLY) continue;
            result2 = externalCondition.isOverridable(superMember, subMember);
            switch (WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
                case 1: {
                    wasSuccess = true;
                    continue block8;
                }
                case 2: {
                    OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("External condition");
                    Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                    return overrideCompatibilityInfo;
                }
            }
        }
        if (!wasSuccess) {
            return basicResult2;
        }
        for (IrExternalOverridabilityCondition externalCondition : this.externalOverridabilityConditions) {
            if (externalCondition.getContract() != IrExternalOverridabilityCondition.Contract.CONFLICTS_ONLY) continue;
            result2 = externalCondition.isOverridable(superMember, subMember);
            switch (WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
                case 2: {
                    OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("External condition");
                    Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                    return overrideCompatibilityInfo;
                }
                case 1: {
                    throw new IllegalStateException(("Contract violation in " + externalCondition.getClass() + " condition. It's not supposed to end with success").toString());
                }
            }
        }
        OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.success();
        Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"success(...)");
        return overrideCompatibilityInfo;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrExternalOverridabilityCondition.Result.values().length];
            try {
                nArray[IrExternalOverridabilityCondition.Result.OVERRIDABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrExternalOverridabilityCondition.Result.INCOMPATIBLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrExternalOverridabilityCondition.Result.UNKNOWN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

