/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.web.common.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.Visibilities;
import ksp.org.jetbrains.kotlin.descriptors.Visibility;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.web.common.FirWebCommonErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import ksp.org.jetbrains.kotlin.fir.declarations.FirField;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirVariable;
import ksp.org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirBlock;
import ksp.org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.name.CallableId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H&J\u001c\u0010\u0014\u001a\u00020\u000e2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u000f\u001a\u00020\u0010H&J \u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\u001c\u0010\u0018\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u0019\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u001a\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u001b\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u001c\u001a\u00020\u000e*\u00020\u0002H\u0002J\f\u0010\u001d\u001a\u00020\u000e*\u00020\u001eH\u0002J\u0014\u0010\u001f\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010 \u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010!\u001a\u00020\u000e*\u00020\"H\u0002J\u0014\u0010#\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006$"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/web/common/checkers/declaration/FirWebCommonExternalChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "additionalCheck", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "check", "hasExternalLikeAnnotations", "", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "isDefinedExternallyCallableId", "callableId", "Lksp/org/jetbrains/kotlin/name/CallableId;", "isNativeOrEffectivelyExternal", "symbol", "Lksp/org/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "reportExternalEnum", "checkAnonymousInitializer", "checkBody", "checkConstructorPropertyParam", "checkDelegation", "hasValidExternalBody", "isDefinedExternallyExpression", "Lksp/org/jetbrains/kotlin/fir/FirElement;", "isDirectlyExternal", "isNonAbstractMemberIfInterface", "isNullableProperty", "Lksp/org/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "isPrivateMemberOfExternalClass", "checkers.web.common"})
@SourceDebugExtension(value={"SMAP\nFirWebCommonExternalChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWebCommonExternalChecker.kt\norg/jetbrains/kotlin/fir/analysis/web/common/checkers/declaration/FirWebCommonExternalChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 7 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,257:1\n60#2:258\n21#2:276\n21#2:278\n11#2:279\n37#3:259\n1601#4,9:260\n1853#4:269\n1854#4:271\n1610#4:272\n1#5:270\n20#6,2:273\n57#7:275\n18#7:277\n*S KotlinDebug\n*F\n+ 1 FirWebCommonExternalChecker.kt\norg/jetbrains/kotlin/fir/analysis/web/common/checkers/declaration/FirWebCommonExternalChecker\n*L\n71#1:258\n217#1:276\n218#1:278\n226#1:279\n71#1:259\n154#1:260,9\n154#1:269\n154#1:271\n154#1:272\n154#1:270\n166#1:273,2\n205#1:275\n217#1:277\n*E\n"})
public abstract class FirWebCommonExternalChecker
extends FirDeclarationChecker<FirDeclaration> {
    public FirWebCommonExternalChecker() {
        super(MppCheckerKind.Common);
    }

    public abstract boolean isNativeOrEffectivelyExternal(@NotNull FirBasedSymbol<?> var1, @NotNull FirSession var2);

    public abstract void reportExternalEnum(@NotNull FirDeclaration var1, @NotNull CheckerContext var2, @NotNull DiagnosticReporter var3);

    public abstract void additionalCheck(@NotNull FirDeclaration var1, @NotNull CheckerContext var2, @NotNull DiagnosticReporter var3);

    public abstract boolean isDefinedExternallyCallableId(@NotNull CallableId var1);

    public abstract boolean hasExternalLikeAnnotations(@NotNull FirDeclaration var1, @NotNull FirSession var2);

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!this.isNativeOrEffectivelyExternal(declaration2.getSymbol(), context2.getSession())) {
            return;
        }
        if (!FirHelpersKt.isTopLevel(context2) && !(declaration2 instanceof FirPropertyAccessor) && this.isDirectlyExternal(declaration2, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirWebCommonErrors.INSTANCE.getNESTED_EXTERNAL_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
        }
        if (declaration2 instanceof FirClass) {
            String classKind2;
            String string2 = ((FirClass)declaration2).getStatus().isData() ? "data class" : (((FirClass)declaration2).getStatus().isInner() ? "inner class" : (((FirClass)declaration2).getStatus().isInline() ? "value class" : (((FirClass)declaration2).getStatus().isFun() ? "fun interface" : (classKind2 = ((FirClass)declaration2).getClassKind() == ClassKind.ANNOTATION_CLASS ? "annotation class" : null))));
            if (classKind2 != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirWebCommonErrors.INSTANCE.getWRONG_EXTERNAL_DECLARATION(), (Object)classKind2, (DiagnosticContext)context2, null, 16, null);
            }
            FirClass $this$isEnumClass$iv = (FirClass)declaration2;
            boolean $i$f$isEnumClass = false;
            ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
            boolean $i$f$isEnumClass2 = false;
            boolean bl = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
            if (bl) {
                this.reportExternalEnum(declaration2, context2, reporter);
            }
        }
        if (declaration2 instanceof FirPropertyAccessor && this.isDirectlyExternal(declaration2, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirWebCommonErrors.INSTANCE.getWRONG_EXTERNAL_DECLARATION(), (Object)"property accessor", (DiagnosticContext)context2, null, 16, null);
        } else if (!(declaration2 instanceof FirPrimaryConstructor) && !(declaration2 instanceof FirField) && this.isPrivateMemberOfExternalClass(declaration2, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirWebCommonErrors.INSTANCE.getWRONG_EXTERNAL_DECLARATION(), (Object)"private member of class", (DiagnosticContext)context2, null, 16, null);
        }
        FirDeclaration container2 = (FirDeclaration)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        if (declaration2 instanceof FirClass && ((FirClass)declaration2).getClassKind() != ClassKind.INTERFACE && container2 instanceof FirClass && ((FirClass)container2).getClassKind() == ClassKind.INTERFACE) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirWebCommonErrors.INSTANCE.getNESTED_CLASS_IN_EXTERNAL_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
        }
        if (!(declaration2 instanceof FirPropertyAccessor) && declaration2 instanceof FirCallableDeclaration && FirDeclarationUtilKt.isExtension((FirCallableDeclaration)declaration2)) {
            FirCallableDeclaration firCallableDeclaration = (FirCallableDeclaration)declaration2;
            String target = firCallableDeclaration instanceof FirFunction ? "extension function" : (firCallableDeclaration instanceof FirProperty ? "extension property" : "extension member");
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirWebCommonErrors.INSTANCE.getWRONG_EXTERNAL_DECLARATION(), (Object)target, (DiagnosticContext)context2, null, 16, null);
        }
        if (declaration2 instanceof FirCallableDeclaration && this.isNonAbstractMemberIfInterface(declaration2, context2.getSession()) && !this.isNullableProperty((FirCallableDeclaration)declaration2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirWebCommonErrors.INSTANCE.getNON_ABSTRACT_MEMBER_OF_EXTERNAL_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
        }
        this.checkBody(declaration2, context2, reporter);
        this.checkDelegation(declaration2, context2, reporter);
        this.checkAnonymousInitializer(declaration2, context2, reporter);
        this.checkConstructorPropertyParam(declaration2, context2, reporter);
        this.additionalCheck(declaration2, context2, reporter);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkBody(FirDeclaration $this$checkBody, CheckerContext context2, DiagnosticReporter reporter) {
        boolean isWrong;
        FirExpression firExpression2;
        if ($this$checkBody instanceof FirDefaultPropertyAccessor) {
            return;
        }
        FirDeclaration firDeclaration = $this$checkBody;
        FirBlock body2 = firDeclaration instanceof FirFunction ? ((FirFunction)$this$checkBody).getBody() : (firDeclaration instanceof FirAnonymousInitializer ? ((FirAnonymousInitializer)$this$checkBody).getBody() : null);
        if ($this$checkBody instanceof FirEnumEntry) {
            firExpression2 = null;
        } else {
            KtSourceElement ktSourceElement = $this$checkBody.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) {
                firExpression2 = null;
            } else if ($this$checkBody instanceof FirVariable) {
                firExpression2 = ((FirVariable)$this$checkBody).getInitializer();
            } else if (body2 instanceof FirSingleExpressionBlock) {
                FirStatement firStatement = ((FirSingleExpressionBlock)body2).getStatement();
                FirReturnExpression firReturnExpression = firStatement instanceof FirReturnExpression ? (FirReturnExpression)firStatement : null;
                firExpression2 = firReturnExpression != null ? firReturnExpression.getResult() : null;
            } else {
                firExpression2 = null;
            }
        }
        FirExpression initializer2 = firExpression2;
        KtSourceElement ktSourceElement = $this$checkBody.getSource();
        if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind)) {
            return;
        }
        boolean bl = isWrong = !(body2 instanceof FirSingleExpressionBlock) && !this.hasValidExternalBody($this$checkBody) || initializer2 != null && !this.isDefinedExternallyExpression(initializer2);
        if (isWrong && body2 != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)body2.getSource(), FirWebCommonErrors.INSTANCE.getWRONG_BODY_OF_EXTERNAL_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
        } else if (isWrong && initializer2 != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)initializer2.getSource(), FirWebCommonErrors.INSTANCE.getWRONG_INITIALIZER_OF_EXTERNAL_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
        }
        if ($this$checkBody instanceof FirFunction) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = ((FirFunction)$this$checkBody).getValueParameters();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirExpression it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                FirValueParameter it = (FirValueParameter)element$iv$iv;
                boolean bl3 = false;
                if (it.getDefaultValue() == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            for (FirExpression defaultValue : (List)destination$iv$iv) {
                if (this.isDefinedExternallyExpression(defaultValue)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)defaultValue.getSource(), FirWebCommonErrors.INSTANCE.getWRONG_DEFAULT_VALUE_FOR_EXTERNAL_FUN_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final void checkDelegation(FirDeclaration $this$checkDelegation, CheckerContext context2, DiagnosticReporter reporter) {
        block8: {
            block9: {
                block7: {
                    Object v0;
                    block6: {
                        if (!($this$checkDelegation instanceof FirMemberDeclaration) || !this.isNativeOrEffectivelyExternal($this$checkDelegation.getSymbol(), context2.getSession())) {
                            return;
                        }
                        if (!($this$checkDelegation instanceof FirClass)) break block7;
                        Iterable $this$firstIsInstanceOrNull$iv = ((FirClass)$this$checkDelegation).getDeclarations();
                        boolean $i$f$firstIsInstanceOrNull = false;
                        for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                            if (!(element$iv instanceof FirPrimaryConstructor)) continue;
                            v0 = element$iv;
                            break block6;
                        }
                        v0 = null;
                    }
                    FirPrimaryConstructor firPrimaryConstructor = v0;
                    if (firPrimaryConstructor != null) {
                        FirPrimaryConstructor it = firPrimaryConstructor;
                        boolean bl = false;
                        FirDelegatedConstructorCall constructorCall = it.getDelegatedConstructor();
                        Object object = constructorCall;
                        if ((object != null && (object = ((FirDelegatedConstructorCall)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null) instanceof KtRealSourceElementKind) {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)constructorCall.getSource(), FirWebCommonErrors.INSTANCE.getEXTERNAL_DELEGATED_CONSTRUCTOR_CALL(), (DiagnosticContext)context2, null, 8, null);
                        }
                    }
                    for (Map.Entry<FirTypeRef, FirFieldSymbol> entry : FirHelpersKt.collectSupertypesWithDelegates((FirClass)$this$checkDelegation).entrySet()) {
                        FirTypeRef superType2 = entry.getKey();
                        FirFieldSymbol delegate2 = entry.getValue();
                        if (delegate2 == null) continue;
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superType2.getSource(), FirWebCommonErrors.INSTANCE.getEXTERNAL_DELEGATION(), (DiagnosticContext)context2, null, 8, null);
                    }
                    break block8;
                }
                if (!($this$checkDelegation instanceof FirConstructor) || ((FirConstructor)$this$checkDelegation).isPrimary()) break block9;
                FirDelegatedConstructorCall delegationCall = ((FirConstructor)$this$checkDelegation).getDelegatedConstructor();
                Object object = delegationCall;
                if (!((object != null && (object = ((FirDelegatedConstructorCall)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null) instanceof KtRealSourceElementKind)) break block8;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)delegationCall.getSource(), FirWebCommonErrors.INSTANCE.getEXTERNAL_DELEGATED_CONSTRUCTOR_CALL(), (DiagnosticContext)context2, null, 8, null);
                break block8;
            }
            if (!($this$checkDelegation instanceof FirProperty)) break block8;
            FirExpression firExpression2 = ((FirProperty)$this$checkDelegation).getDelegate();
            if (firExpression2 != null) {
                FirExpression it = firExpression2;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirWebCommonErrors.INSTANCE.getEXTERNAL_DELEGATION(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final void checkAnonymousInitializer(FirDeclaration $this$checkAnonymousInitializer, CheckerContext context2, DiagnosticReporter reporter) {
        if (!($this$checkAnonymousInitializer instanceof FirClass)) {
            return;
        }
        for (FirAnonymousInitializer anonymousInitializer : FirDeclarationUtilKt.getAnonymousInitializers((FirClass)$this$checkAnonymousInitializer)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)anonymousInitializer.getSource(), FirWebCommonErrors.INSTANCE.getEXTERNAL_ANONYMOUS_INITIALIZER(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkConstructorPropertyParam(FirDeclaration $this$checkConstructorPropertyParam, CheckerContext context2, DiagnosticReporter reporter) {
        block6: {
            block5: {
                if (!($this$checkConstructorPropertyParam instanceof FirProperty)) break block5;
                KtSourceElement ktSourceElement = $this$checkConstructorPropertyParam.getSource();
                if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) break block6;
            }
            return;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol($this$checkConstructorPropertyParam, context2.getSession());
        FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
        if (firClassSymbol == null) {
            return;
        }
        FirClassSymbol containingClass = firClassSymbol;
        FirClassLikeSymbol $this$isData$iv = containingClass;
        boolean $i$f$isData = false;
        if ($this$isData$iv.getRawStatus().isData() || containingClass.getClassKind() == ClassKind.ANNOTATION_CLASS) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkConstructorPropertyParam.getSource(), FirWebCommonErrors.INSTANCE.getEXTERNAL_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
    }

    private final boolean isDirectlyExternal(FirDeclaration $this$isDirectlyExternal, FirSession session2) {
        block3: {
            block2: {
                if ($this$isDirectlyExternal instanceof FirDefaultPropertyAccessor) break block2;
                KtSourceElement ktSourceElement = $this$isDirectlyExternal.getSource();
                if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind) break block3;
            }
            return false;
        }
        FirElement firElement = $this$isDirectlyExternal;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.EXTERNAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"EXTERNAL_KEYWORD");
        return FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken) || this.hasExternalLikeAnnotations($this$isDirectlyExternal, session2);
    }

    private final boolean isPrivateMemberOfExternalClass(FirDeclaration $this$isPrivateMemberOfExternalClass, FirSession session2) {
        block7: {
            block6: {
                boolean $i$f$getVisibility;
                Object $this$visibility$iv;
                if ($this$isPrivateMemberOfExternalClass instanceof FirPropertyAccessor) {
                    $this$visibility$iv = (FirMemberDeclaration)$this$isPrivateMemberOfExternalClass;
                    $i$f$getVisibility = false;
                    Visibility visibility2 = ((FirMemberDeclaration)$this$visibility$iv).getStatus().getVisibility();
                    $this$visibility$iv = ((FirPropertyAccessor)$this$isPrivateMemberOfExternalClass).getPropertySymbol();
                    $i$f$getVisibility = false;
                    if (Intrinsics.areEqual((Object)visibility2, (Object)((FirCallableSymbol)$this$visibility$iv).getResolvedStatus().getVisibility())) {
                        return false;
                    }
                }
                if (!($this$isPrivateMemberOfExternalClass instanceof FirMemberDeclaration)) break block6;
                $this$visibility$iv = (FirMemberDeclaration)$this$isPrivateMemberOfExternalClass;
                $i$f$getVisibility = false;
                if (Intrinsics.areEqual((Object)((FirMemberDeclaration)$this$visibility$iv).getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) break block7;
            }
            return false;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol($this$isPrivateMemberOfExternalClass, session2);
        if (firClassLikeSymbol == null) {
            return false;
        }
        FirClassLikeSymbol<?> containingDeclaration2 = firClassLikeSymbol;
        return this.isNativeOrEffectivelyExternal((FirBasedSymbol)containingDeclaration2, session2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNonAbstractMemberIfInterface(FirDeclaration $this$isNonAbstractMemberIfInterface, FirSession session2) {
        if (!($this$isNonAbstractMemberIfInterface instanceof FirCallableDeclaration)) return false;
        FirMemberDeclaration $this$modality$iv = (FirMemberDeclaration)$this$isNonAbstractMemberIfInterface;
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getStatus().getModality() == Modality.ABSTRACT) return false;
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol($this$isNonAbstractMemberIfInterface, session2);
        FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
        if ((firClassSymbol != null ? firClassSymbol.getClassKind() : null) != ClassKind.INTERFACE) return false;
        if ($this$isNonAbstractMemberIfInterface instanceof FirPropertyAccessor) return false;
        return true;
    }

    private final boolean isNullableProperty(FirCallableDeclaration $this$isNullableProperty) {
        return $this$isNullableProperty instanceof FirProperty && ConeTypeUtilsKt.isNullable(FirTypeUtilsKt.getConeType($this$isNullableProperty.getReturnTypeRef()));
    }

    private final boolean hasValidExternalBody(FirDeclaration $this$hasValidExternalBody) {
        boolean bl;
        FirBlock firBlock;
        FirDeclaration firDeclaration = $this$hasValidExternalBody;
        if (firDeclaration instanceof FirFunction) {
            firBlock = ((FirFunction)$this$hasValidExternalBody).getBody();
        } else if (firDeclaration instanceof FirAnonymousInitializer) {
            firBlock = ((FirAnonymousInitializer)$this$hasValidExternalBody).getBody();
        } else {
            return true;
        }
        FirBlock body2 = firBlock;
        if (body2 instanceof FirSingleExpressionBlock) {
            bl = this.isDefinedExternallyExpression(body2);
        } else if (body2 != null) {
            FirStatement firStatement = (FirStatement)CollectionsKt.singleOrNull(body2.getStatements());
            if (firStatement == null) {
                return false;
            }
            FirStatement statement2 = firStatement;
            bl = this.isDefinedExternallyExpression(statement2);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isDefinedExternallyExpression(FirElement $this$isDefinedExternallyExpression) {
        FirPropertySymbol firPropertySymbol;
        FirReference firReference;
        FirPropertyAccessExpression firPropertyAccessExpression;
        FirPropertyAccessExpression firPropertyAccessExpression2 = firPropertyAccessExpression = $this$isDefinedExternallyExpression instanceof FirPropertyAccessExpression ? (FirPropertyAccessExpression)$this$isDefinedExternallyExpression : null;
        if (firPropertyAccessExpression == null || (firReference = firPropertyAccessExpression.getCalleeReference()) == null || (firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(firReference, false, 1, null)) == null) {
            return false;
        }
        FirPropertySymbol declaration2 = firPropertySymbol;
        return this.isDefinedExternallyCallableId(declaration2.getCallableId());
    }
}

