/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactoryForDeprecation;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeCapturedType;
import ksp.org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import ksp.org.jetbrains.kotlin.fir.types.ConeDynamicType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J8\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u0014\u001a\u00020\u0012*\u00020\u000eH\u0002J\f\u0010\u0015\u001a\u00020\u0012*\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirReifiedChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkArgumentAndReport", "typeArgument", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "isExplicit", "", "isArray", "cannotBeReified", "isReifiedTypeParameterOrFromKotlinArray", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirReifiedChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReifiedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReifiedChecker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,100:1\n13291#2,2:101\n*S KotlinDebug\n*F\n+ 1 FirReifiedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReifiedChecker\n*L\n75#1:101,2\n*E\n"})
public final class FirReifiedChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirReifiedChecker INSTANCE = new FirReifiedChecker();

    private FirReifiedChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirReference calleeReference = expression2.getCalleeReference();
        List<FirTypeProjection> typeArguments2 = expression2.getTypeArguments();
        Object object = FirReferenceUtilsKt.toResolvedCallableSymbol$default(calleeReference, false, 1, null);
        if (object == null || (object = ((FirCallableSymbol)object).getTypeParameterSymbols()) == null) {
            return;
        }
        Object typeParameters2 = object;
        int count = Math.min(typeArguments2.size(), typeParameters2.size());
        for (int index2 = 0; index2 < count; ++index2) {
            ConeKotlinType typeArgument;
            FirTypeParameterSymbol typeParameter;
            FirTypeProjection typeArgumentProjection = typeArguments2.get(index2);
            KtSourceElement ktSourceElement = typeArgumentProjection.getSource();
            if (ktSourceElement == null && (ktSourceElement = calleeReference.getSource()) == null) continue;
            KtSourceElement source = ktSourceElement;
            if (ConeTypeProjectionKt.getType(FirTypeUtilsKt.toConeTypeProjection(typeArgumentProjection)) == null || !this.isReifiedTypeParameterOrFromKotlinArray(typeParameter = (FirTypeParameterSymbol)typeParameters2.get(index2))) continue;
            KtSourceElement ktSourceElement2 = typeArgumentProjection.getSource();
            this.checkArgumentAndReport(typeArgument, source, Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE), false, context2, reporter);
        }
    }

    private final boolean isReifiedTypeParameterOrFromKotlinArray(FirTypeParameterSymbol $this$isReifiedTypeParameterOrFromKotlinArray) {
        FirBasedSymbol<?> containingDeclaration2 = $this$isReifiedTypeParameterOrFromKotlinArray.getContainingDeclarationSymbol();
        return $this$isReifiedTypeParameterOrFromKotlinArray.isReified() || containingDeclaration2 instanceof FirRegularClassSymbol && Intrinsics.areEqual((Object)((FirRegularClassSymbol)containingDeclaration2).getClassId(), (Object)StandardClassIds.INSTANCE.getArray());
    }

    private final boolean cannotBeReified(ConeKotlinType $this$cannotBeReified) {
        ConeKotlinType coneKotlinType = $this$cannotBeReified;
        return coneKotlinType instanceof ConeCapturedType ? true : (coneKotlinType instanceof ConeDynamicType ? true : ConeBuiltinTypeUtilsKt.isNothing($this$cannotBeReified) || ConeBuiltinTypeUtilsKt.isNullableNothing($this$cannotBeReified));
    }

    private final void checkArgumentAndReport(ConeKotlinType typeArgument, KtSourceElement source, boolean isExplicit, boolean isArray, CheckerContext context2, DiagnosticReporter reporter) {
        ConeKotlinType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType(typeArgument, context2.getSession());
        if (Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(fullyExpandedType2), (Object)StandardClassIds.INSTANCE.getArray())) {
            ConeTypeProjection[] $this$forEach$iv = fullyExpandedType2.getTypeArguments();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                ConeTypeProjection element$iv;
                ConeTypeProjection it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (!(it instanceof ConeKotlinType)) continue;
                INSTANCE.checkArgumentAndReport((ConeKotlinType)it, source, isExplicit, true, context2, reporter);
            }
            return;
        }
        if (typeArgument instanceof ConeTypeParameterType) {
            FirTypeParameterSymbol symbol2 = ((ConeTypeParameterType)typeArgument).getLookupTag().getTypeParameterSymbol();
            if (!symbol2.isReified()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, isArray ? (KtDiagnosticFactory1)KtDiagnosticReportHelpersKt.chooseFactory((KtDiagnosticFactoryForDeprecation)FirErrors.INSTANCE.getTYPE_PARAMETER_AS_REIFIED_ARRAY(), context2) : FirErrors.INSTANCE.getTYPE_PARAMETER_AS_REIFIED(), (Object)symbol2, (DiagnosticContext)context2, null, 16, null);
            }
        } else if (typeArgument instanceof ConeDefinitelyNotNullType && isExplicit) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDEFINITELY_NON_NULLABLE_AS_REIFIED(), (DiagnosticContext)context2, null, 8, null);
        } else if (this.cannotBeReified(typeArgument)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getREIFIED_TYPE_FORBIDDEN_SUBSTITUTION(), (Object)typeArgument, (DiagnosticContext)context2, null, 16, null);
        }
    }
}

