/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.FileLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.lower.AbstractVariableRemapper;
import ksp.org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.HeaderProcessorKt;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmLoweredStatementOrigin;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocatorKt;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.IrInlineScopeResolver;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.IrFileEntry;
import ksp.org.jetbrains.kotlin.ir.IrStatement;
import ksp.org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import ksp.org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import ksp.org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import ksp.org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrField;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrScript;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrVariable;
import ksp.org.jetbrains.kotlin.ir.declarations.impl.IrVariableImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBlock;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBranch;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBreak;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCatch;
import ksp.org.jetbrains.kotlin.ir.expressions.IrClassReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrComposite;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConst;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstKind;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrContinue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import ksp.org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetClass;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetField;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import ksp.org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrLoop;
import ksp.org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrReturn;
import ksp.org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSetField;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSetValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import ksp.org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import ksp.org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrThrow;
import ksp.org.jetbrains.kotlin.ir.expressions.IrTry;
import ksp.org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrVararg;
import ksp.org.jetbrains.kotlin.ir.expressions.IrWhen;
import ksp.org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrConstImplKt;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImplKt;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import ksp.org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\u00a8\u0006\u0016"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering;", "Lksp/org/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "isObjectEquals", "", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "getOperandsIfCallToEQEQOrEquals", "Lkotlin/Pair;", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lksp/org/jetbrains/kotlin/ir/expressions/IrCall;", "lower", "", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "Companion", "Transformer", "backend.jvm.lower"})
public final class JvmOptimizationLowering
implements FileLoweringPass {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmBackendContext context;

    public JvmOptimizationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    private final boolean isObjectEquals(IrFunction $this$isObjectEquals) {
        return Intrinsics.areEqual((Object)$this$isObjectEquals.getName().asString(), (Object)"equals") && ((Collection)$this$isObjectEquals.getValueParameters()).size() == 1 && IrTypePredicatesKt.isNullableAny($this$isObjectEquals.getValueParameters().get(0).getType()) && $this$isObjectEquals.getExtensionReceiverParameter() == null && $this$isObjectEquals.getDispatchReceiverParameter() != null;
    }

    private final Pair<IrExpression, IrExpression> getOperandsIfCallToEQEQOrEquals(IrCall call2) {
        Pair pair;
        if (Intrinsics.areEqual((Object)call2.getSymbol(), (Object)this.context.getIrBuiltIns().getEqeqSymbol())) {
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            IrExpression left = irExpression;
            IrExpression irExpression2 = call2.getValueArgument(1);
            Intrinsics.checkNotNull((Object)irExpression2);
            IrExpression right = irExpression2;
            pair = TuplesKt.to((Object)left, (Object)right);
        } else if (this.isObjectEquals(call2.getSymbol().getOwner())) {
            IrExpression irExpression = call2.getDispatchReceiver();
            Intrinsics.checkNotNull((Object)irExpression);
            IrExpression left = irExpression;
            IrExpression irExpression3 = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression3);
            IrExpression right = irExpression3;
            pair = TuplesKt.to((Object)left, (Object)right);
        } else {
            pair = null;
        }
        return pair;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.transformChildren(new Transformer(irFile.getFileEntry(), IrInlineReferenceLocatorKt.findInlineCallSites(irFile, this.context)), null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$Companion;", "", "()V", "isNegation", "", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "backend.jvm.lower"})
    private static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isNegation(IrExpression expression2) {
            if (!(expression2 instanceof IrCall)) return false;
            IrSimpleFunction not = (IrSimpleFunction)((IrCall)expression2).getSymbol().getOwner();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)not.getName(), (Object)OperatorNameConventions.NOT)) return false;
            if (not.getExtensionReceiverParameter() != null) return false;
            if (!not.getValueParameters().isEmpty()) return false;
            IrValueParameter receiver = not.getDispatchReceiverParameter();
            boolean bl2 = false;
            if (receiver == null) return false;
            if (!IrTypePredicatesKt.isBoolean(receiver.getType())) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u001a\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0002H\u0002J\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000fH\u0002J\u0016\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110%H\u0002J\u0010\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u000eH\u0002J$\u0010(\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020 2\b\u0010)\u001a\u0004\u0018\u00010\u00132\u0006\u0010*\u001a\u00020\u0017H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020 H\u0002J\u001a\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00100\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00101\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u0002042\b\u0010\u001e\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00105\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u0002062\b\u0010\u001e\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00107\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020 2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00108\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u0002092\b\u0010\u001e\u001a\u0004\u0018\u00010\u0002H\u0016J\f\u0010:\u001a\u00020\u0017*\u00020\u0011H\u0002J\u000e\u0010;\u001a\u0004\u0018\u00010\u001d*\u00020\u000eH\u0002J\f\u0010<\u001a\u00020\u0013*\u00020\u0013H\u0002R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$Transformer;", "Lksp/org/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclaration;", "fileEntry", "Lksp/org/jetbrains/kotlin/ir/IrFileEntry;", "inlineScopeResolver", "Lksp/org/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering;Lorg/jetbrains/kotlin/ir/IrFileEntry;Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;)V", "dontTouchTemporaryVals", "Ljava/util/HashSet;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrVariable;", "Lkotlin/collections/HashSet;", "findLoopVariablePosition", "Lkotlin/Pair;", "Lksp/org/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "", "statement", "Lksp/org/jetbrains/kotlin/ir/IrStatement;", "getInlineableValueForTemporaryVal", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "getLineNumberForOffset", "offset", "hasSameLineNumber", "", "e1", "Lksp/org/jetbrains/kotlin/ir/IrElement;", "e2", "optimizePropertyAccess", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrCall;", "data", "prefixIncr", "Lksp/org/jetbrains/kotlin/ir/expressions/IrSetValue;", "delta", "removeUnnecessaryTemporaryVariables", "", "statements", "", "reuseLoopVariableAsInductionVariableIfPossible", "irForLoopBlock", "rewriteCompoundAssignmentAsPrefixIncrDecr", "value", "isMinus", "rewritePrefixIncrDecr", "visitBlockBody", "Lksp/org/jetbrains/kotlin/ir/expressions/IrBody;", "body", "Lksp/org/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitCall", "visitContainerExpression", "visitDeclaration", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitGetValue", "Lksp/org/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "visitWhen", "Lksp/org/jetbrains/kotlin/ir/expressions/IrWhen;", "isLoopVariable", "rewritePostfixIncrDecr", "unwrapSingleExpressionBlock", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nJvmOptimizationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmOptimizationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$Transformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LowerUtils.kt\norg/jetbrains/kotlin/backend/common/lower/LowerUtilsKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBuilderKt\n+ 5 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,505:1\n1#2:506\n82#3,6:507\n156#4,6:513\n98#5,2:519\n350#6,7:521\n350#6,7:528\n*S KotlinDebug\n*F\n+ 1 JvmOptimizationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$Transformer\n*L\n125#1:507,6\n125#1:513,6\n125#1:519,2\n324#1:521,7\n367#1:528,7\n*E\n"})
    private final class Transformer
    implements IrElementTransformer<IrDeclaration> {
        @NotNull
        private final IrFileEntry fileEntry;
        @NotNull
        private final IrInlineScopeResolver inlineScopeResolver;
        @NotNull
        private final HashSet<IrVariable> dontTouchTemporaryVals;

        public Transformer(@NotNull IrFileEntry fileEntry, IrInlineScopeResolver inlineScopeResolver) {
            Intrinsics.checkNotNullParameter((Object)fileEntry, (String)"fileEntry");
            Intrinsics.checkNotNullParameter((Object)inlineScopeResolver, (String)"inlineScopeResolver");
            this.fileEntry = fileEntry;
            this.inlineScopeResolver = inlineScopeResolver;
            this.dontTouchTemporaryVals = new HashSet();
        }

        @Override
        @NotNull
        public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable IrDeclaration data2) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration2, declaration2);
        }

        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2, @Nullable IrDeclaration data2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            expression2.transformChildren(this, data2);
            IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
            if (Intrinsics.areEqual((Object)callee.getOrigin(), (Object)IrDeclarationOrigin.Companion.getDEFAULT_PROPERTY_ACCESSOR())) {
                return this.optimizePropertyAccess(expression2, data2);
            }
            if (Companion.isNegation(expression2)) {
                Companion companion = Companion;
                IrExpression irExpression = expression2.getDispatchReceiver();
                Intrinsics.checkNotNull((Object)irExpression);
                if (companion.isNegation(irExpression)) {
                    IrExpression irExpression2 = expression2.getDispatchReceiver();
                    Intrinsics.checkNotNull((Object)irExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                    IrExpression irExpression3 = ((IrCall)irExpression2).getDispatchReceiver();
                    Intrinsics.checkNotNull((Object)irExpression3);
                    return irExpression3;
                }
            }
            Pair pair = JvmOptimizationLowering.this.getOperandsIfCallToEQEQOrEquals(expression2);
            if (pair != null) {
                Pair pair2 = pair;
                JvmOptimizationLowering jvmOptimizationLowering = JvmOptimizationLowering.this;
                Pair pair3 = pair2;
                boolean bl = false;
                IrExpression left = (IrExpression)pair3.component1();
                IrExpression right = (IrExpression)pair3.component2();
                if (IrUtilsKt.isNullConst(left) && IrUtilsKt.isNullConst(right)) {
                    return IrConstImpl.Companion.constTrue(expression2.getStartOffset(), expression2.getEndOffset(), jvmOptimizationLowering.getContext().getIrBuiltIns().getBooleanType());
                }
                if (IrUtilsKt.isNullConst(left) && right instanceof IrConst || IrUtilsKt.isNullConst(right) && left instanceof IrConst) {
                    return IrConstImpl.Companion.constFalse(expression2.getStartOffset(), expression2.getEndOffset(), jvmOptimizationLowering.getContext().getIrBuiltIns().getBooleanType());
                }
            }
            return expression2;
        }

        /*
         * WARNING - void declaration
         */
        private final IrExpression optimizePropertyAccess(IrCall expression2, IrDeclaration data2) {
            void $this$optimizePropertyAccess_u24lambda_u243;
            void this_$iv$iv$iv;
            void startOffset$iv$iv;
            void $this$irBlock$iv$iv;
            void $this$irBlock_u24default$iv;
            Object object;
            IrElement irElement;
            IrField backingField2;
            IrSimpleFunction accessor;
            block12: {
                block11: {
                    accessor = (IrSimpleFunction)expression2.getSymbol().getOwner();
                    if (accessor.getModality() != Modality.FINAL || accessor.isExternal()) {
                        return expression2;
                    }
                    Object object2 = accessor.getCorrespondingPropertySymbol();
                    if (object2 == null || (object2 = (IrProperty)object2.getOwner()) == null) {
                        return expression2;
                    }
                    Object property2 = object2;
                    if (((IrProperty)property2).isLateinit()) {
                        return expression2;
                    }
                    IrField irField = ((IrProperty)property2).getBackingField();
                    if (irField == null) {
                        return expression2;
                    }
                    backingField2 = irField;
                    irElement = data2;
                    if (irElement == null) break block11;
                    object = irElement;
                    IrInlineScopeResolver irInlineScopeResolver = this.inlineScopeResolver;
                    IrElement p0 = (IrElement)object;
                    boolean bl = false;
                    IrDeclarationContainer irDeclarationContainer = irInlineScopeResolver.findContainer(p0);
                    irElement = irDeclarationContainer;
                    if (irDeclarationContainer != null) break block12;
                }
                return expression2;
            }
            IrElement scope = irElement;
            if (!Intrinsics.areEqual((Object)scope, (Object)accessor.getParent()) || !Intrinsics.areEqual((Object)scope, (Object)backingField2.getParent())) {
                return expression2;
            }
            IrExpression receiver = expression2.getDispatchReceiver();
            object = LowerUtilsKt.createIrBuilder(JvmOptimizationLowering.this.getContext(), (IrSymbol)expression2.getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
            JvmOptimizationLowering jvmOptimizationLowering = JvmOptimizationLowering.this;
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = ((IrExpression)expression2).getType();
            boolean $i$f$irBlock = false;
            void var13_14 = $this$irBlock_u24default$iv;
            int n = ((IrExpression)expression2).getStartOffset();
            int endOffset$iv$iv = ((IrExpression)expression2).getEndOffset();
            boolean $i$f$irBlock2 = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void var19_20 = this_$iv$iv$iv;
            Transformer transformer2 = this;
            boolean bl = false;
            if (backingField2.isStatic() && receiver != null && !(receiver instanceof IrGetValue)) {
                $this$optimizePropertyAccess_u24lambda_u243.unaryPlus(IrUtilsKt.coerceToUnit(receiver, $this$optimizePropertyAccess_u24lambda_u243.getContext().getIrBuiltIns(), jvmOptimizationLowering.getContext().getTypeSystem()));
            }
            if (!((Collection)accessor.getValueParameters()).isEmpty()) {
                IrExpression irExpression;
                IrExpression irExpression2 = irExpression = receiver;
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$optimizePropertyAccess_u24lambda_u243;
                void var24_29 = $this$optimizePropertyAccess_u24lambda_u243;
                boolean bl2 = false;
                boolean bl3 = backingField2.isStatic();
                IrExpression irExpression3 = !bl3 ? irExpression : null;
                IrExpression irExpression4 = expression2.getValueArgument(expression2.getValueArgumentsCount() - 1);
                Intrinsics.checkNotNull((Object)irExpression4);
                var24_29.unaryPlus(ExpressionHelpersKt.irSetField$default(irBuilderWithScope, irExpression3, backingField2, irExpression4, null, 8, null));
            } else {
                IrExpression irExpression;
                IrExpression it = irExpression = receiver;
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$optimizePropertyAccess_u24lambda_u243;
                void var24_30 = $this$optimizePropertyAccess_u24lambda_u243;
                boolean bl4 = false;
                boolean bl5 = backingField2.isStatic();
                var24_30.unaryPlus(ExpressionHelpersKt.irGetField$default(irBuilderWithScope, !bl5 ? irExpression : null, backingField2, null, 4, null));
            }
            return transformer2.unwrapSingleExpressionBlock(this_$iv$iv$iv.doBuild());
        }

        private final IrExpression unwrapSingleExpressionBlock(IrExpression $this$unwrapSingleExpressionBlock) {
            IrStatement irStatement;
            Object object = $this$unwrapSingleExpressionBlock instanceof IrBlock ? (IrBlock)$this$unwrapSingleExpressionBlock : null;
            IrStatement irStatement2 = irStatement = object != null && (object = ((IrContainerExpression)object).getStatements()) != null ? (IrStatement)CollectionsKt.singleOrNull((List)object) : null;
            IrExpression irExpression = irStatement instanceof IrExpression ? (IrExpression)irStatement : null;
            if (irExpression == null) {
                irExpression = $this$unwrapSingleExpressionBlock;
            }
            return irExpression;
        }

        @Override
        @NotNull
        public IrExpression visitWhen(@NotNull IrWhen expression2, @Nullable IrDeclaration data2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            boolean isCompilerGenerated = expression2.getOrigin() == null;
            expression2.transformChildren(this, data2);
            expression2.getBranches().removeIf(arg_0 -> Transformer.visitWhen$lambda$4((Function1)new Function1<IrBranch, Boolean>(isCompilerGenerated){
                final /* synthetic */ boolean $isCompilerGenerated;
                {
                    this.$isCompilerGenerated = $isCompilerGenerated;
                    super(1);
                }

                public final Boolean invoke(IrBranch it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return IrUtilsKt.isFalseConst(it.getCondition()) && this.$isCompilerGenerated;
                }
            }, arg_0));
            if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getANDAND())) {
                IrCallImpl irCallImpl;
                boolean bl;
                boolean bl2 = bl = IrTypePredicatesKt.isBoolean(expression2.getType()) && expression2.getBranches().size() == 2 && IrUtilsKt.isTrueConst(expression2.getBranches().get(1).getCondition()) && IrUtilsKt.isFalseConst(expression2.getBranches().get(1).getResult());
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$32 = false;
                    String $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$32 = "ANDAND condition should have an 'if true then false' body on its second branch. Failing expression: " + DumpIrTreeKt.dump$default(expression2, null, 1, null);
                    throw new AssertionError((Object)$i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$32);
                }
                IrCallImpl $this$visitWhen_u24lambda_u246 = irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, expression2.getStartOffset(), expression2.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getBooleanType(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getAndandSymbol(), 0, 0, null, null, 240, null);
                boolean bl3 = false;
                $this$visitWhen_u24lambda_u246.putValueArgument(0, expression2.getBranches().get(0).getCondition());
                $this$visitWhen_u24lambda_u246.putValueArgument(1, expression2.getBranches().get(0).getResult());
                return irCallImpl;
            }
            if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getOROR())) {
                IrCallImpl irCallImpl;
                boolean bl;
                boolean bl4 = bl = IrTypePredicatesKt.isBoolean(expression2.getType()) && expression2.getBranches().size() == 2 && IrUtilsKt.isTrueConst(expression2.getBranches().get(0).getResult()) && IrUtilsKt.isTrueConst(expression2.getBranches().get(1).getCondition());
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$52 = false;
                    String $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$52 = "OROR condition should have an 'if a then true' body on its first branch, and an 'if true then b' body on its second branch. Failing expression: " + DumpIrTreeKt.dump$default(expression2, null, 1, null);
                    throw new AssertionError((Object)$i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$52);
                }
                IrCallImpl $this$visitWhen_u24lambda_u248 = irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, expression2.getStartOffset(), expression2.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getBooleanType(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getOrorSymbol(), 0, 0, null, null, 240, null);
                boolean bl5 = false;
                $this$visitWhen_u24lambda_u248.putValueArgument(0, expression2.getBranches().get(0).getCondition());
                $this$visitWhen_u24lambda_u248.putValueArgument(1, expression2.getBranches().get(1).getResult());
                return irCallImpl;
            }
            if (expression2.getBranches().size() == 0) {
                return new IrBlockImpl(expression2.getStartOffset(), expression2.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getUnitType(), null, 8, null);
            }
            IrBranch firstBranch = (IrBranch)CollectionsKt.first(expression2.getBranches());
            if (IrUtilsKt.isTrueConst(firstBranch.getCondition()) && isCompilerGenerated) {
                return firstBranch.getResult();
            }
            return expression2;
        }

        private final IrExpression getInlineableValueForTemporaryVal(IrStatement statement2) {
            IrVariable irVariable = statement2 instanceof IrVariable ? (IrVariable)statement2 : null;
            if (irVariable == null) {
                return null;
            }
            IrVariable variable2 = irVariable;
            if (!Intrinsics.areEqual((Object)variable2.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE()) || variable2.isVar()) {
                return null;
            }
            if (this.dontTouchTemporaryVals.contains(variable2)) {
                return null;
            }
            IrExpression initializer2 = variable2.getInitializer();
            if (initializer2 instanceof IrConst) {
                return initializer2;
            }
            if (initializer2 instanceof IrGetValue) {
                IrValueDeclaration initializerValue = ((IrGetValue)initializer2).getSymbol().getOwner();
                if (initializerValue instanceof IrVariable) {
                    IrExpression irExpression;
                    if (((IrVariable)initializerValue).isVar()) {
                        irExpression = null;
                    } else if (Intrinsics.areEqual((Object)initializerValue.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE())) {
                        irExpression = this.getInlineableValueForTemporaryVal(initializerValue);
                        if (irExpression == null) {
                            irExpression = initializer2;
                        }
                    } else {
                        irExpression = initializer2;
                    }
                    return irExpression;
                }
                if (initializerValue instanceof IrValueParameter) {
                    return initializerValue.isAssignable() ? null : initializer2;
                }
            }
            return null;
        }

        private final void removeUnnecessaryTemporaryVariables(List<IrStatement> statements2) {
            block2: {
                statements2.removeIf(arg_0 -> Transformer.removeUnnecessaryTemporaryVariables$lambda$9((Function1)new Function1<IrStatement, Boolean>(this){
                    final /* synthetic */ Transformer this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final Boolean invoke(IrStatement it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Transformer.access$getInlineableValueForTemporaryVal(this.this$0, it) != null;
                    }
                }, arg_0));
                if (statements2.size() != 2) break block2;
                IrStatement first = statements2.get(0);
                IrStatement second = statements2.get(1);
                if (first instanceof IrVariable && Intrinsics.areEqual((Object)((IrVariable)first).getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE()) && second instanceof IrGetValue && Intrinsics.areEqual((Object)((IrVariable)first).getSymbol(), (Object)((IrGetValue)second).getSymbol())) {
                    statements2.clear();
                    IrExpression irExpression = ((IrVariable)first).getInitializer();
                    if (irExpression != null) {
                        IrExpression it = irExpression;
                        boolean bl = false;
                        statements2.add(it);
                    }
                }
            }
        }

        @Override
        @NotNull
        public IrBody visitBlockBody(@NotNull IrBlockBody body2, @Nullable IrDeclaration data2) {
            Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
            body2.transformChildren(this, data2);
            this.removeUnnecessaryTemporaryVariables(body2.getStatements());
            return body2;
        }

        @Override
        @NotNull
        public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable IrDeclaration data2) {
            IrCall irCall;
            IrStatement subject;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getWHEN()) && (subject = (IrStatement)CollectionsKt.firstOrNull(expression2.getStatements())) instanceof IrVariable && ((IrVariable)subject).getInitializer() instanceof IrGetValue) {
                this.dontTouchTemporaryVals.add((IrVariable)subject);
            }
            if ((Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getPOSTFIX_DECR()) || Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getPOSTFIX_INCR())) && (irCall = this.rewritePostfixIncrDecr(expression2)) != null) {
                IrCall it = irCall;
                boolean bl = false;
                return it;
            }
            if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getFOR_LOOP())) {
                this.reuseLoopVariableAsInductionVariableIfPossible(expression2);
            }
            expression2.transformChildren(this, data2);
            this.removeUnnecessaryTemporaryVariables(expression2.getStatements());
            return expression2;
        }

        /*
         * WARNING - void declaration
         */
        private final void reuseLoopVariableAsInductionVariableIfPossible(IrContainerExpression irForLoopBlock) {
            int inductionVariableIndex;
            IrStatement it;
            IrComposite loopInitialization;
            block13: {
                int n;
                void $this$indexOfFirst$iv;
                if (irForLoopBlock.getStatements().size() != 2) {
                    return;
                }
                Object object = irForLoopBlock.getStatements().get(0);
                IrComposite irComposite = object instanceof IrComposite ? (IrComposite)object : null;
                if (irComposite == null) {
                    return;
                }
                loopInitialization = irComposite;
                object = loopInitialization.getStatements();
                JvmOptimizationLowering jvmOptimizationLowering = JvmOptimizationLowering.this;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    it = (IrStatement)item$iv;
                    boolean bl = false;
                    if (HeaderProcessorKt.isInductionVariable(it, jvmOptimizationLowering.getContext())) {
                        n = index$iv;
                        break block13;
                    }
                    ++index$iv;
                }
                n = inductionVariableIndex = -1;
            }
            if (inductionVariableIndex < 0) {
                return;
            }
            IrStatement $i$f$indexOfFirst = loopInitialization.getStatements().get(inductionVariableIndex);
            IrVariable irVariable = $i$f$indexOfFirst instanceof IrVariable ? (IrVariable)$i$f$indexOfFirst : null;
            if (irVariable == null) {
                return;
            }
            IrVariable inductionVariable = irVariable;
            Pair<IrContainerExpression, Integer> pair = this.findLoopVariablePosition(irForLoopBlock.getStatements().get(1));
            if (pair == null) {
                return;
            }
            Pair<IrContainerExpression, Integer> loopVariablePosition = pair;
            IrContainerExpression loopVariableContainer = (IrContainerExpression)loopVariablePosition.component1();
            int loopVariableIndex = ((Number)loopVariablePosition.component2()).intValue();
            it = loopVariableContainer.getStatements().get(loopVariableIndex);
            IrVariable irVariable2 = it instanceof IrVariable ? (IrVariable)it : null;
            if (irVariable2 == null) {
                return;
            }
            IrVariable loopVariable = irVariable2;
            IrExpression irExpression = loopVariable.getInitializer();
            if (irExpression == null) {
                return;
            }
            IrExpression loopVariableInitializer = irExpression;
            if (!(loopVariableInitializer instanceof IrGetValue)) {
                return;
            }
            if (!Intrinsics.areEqual((Object)((IrGetValue)loopVariableInitializer).getSymbol(), (Object)inductionVariable.getSymbol())) {
                return;
            }
            IrType inductionVariableType = inductionVariable.getType();
            IrType loopVariableType = loopVariable.getType();
            if (IrTypeUtilsKt.isNullable(loopVariableType)) {
                return;
            }
            if (!Intrinsics.areEqual((Object)IrTypesKt.getClassifierOrNull(loopVariableType), (Object)IrTypesKt.getClassifierOrNull(inductionVariableType))) {
                return;
            }
            IrVariableImpl newLoopVariable = new IrVariableImpl(loopVariable.getStartOffset(), loopVariable.getEndOffset(), loopVariable.getOrigin(), new IrVariableSymbolImpl(null, 1, null), loopVariable.getName(), loopVariableType, true, false, false);
            newLoopVariable.setInitializer(inductionVariable.getInitializer());
            newLoopVariable.setParent(inductionVariable.getParent());
            loopInitialization.getStatements().set(inductionVariableIndex, newLoopVariable);
            loopVariableContainer.getStatements().remove(loopVariableIndex);
            AbstractVariableRemapper remapper2 = new AbstractVariableRemapper(inductionVariable, loopVariable, newLoopVariable){
                final /* synthetic */ IrVariable $inductionVariable;
                final /* synthetic */ IrVariable $loopVariable;
                final /* synthetic */ IrVariableImpl $newLoopVariable;
                {
                    this.$inductionVariable = $inductionVariable;
                    this.$loopVariable = $loopVariable;
                    this.$newLoopVariable = $newLoopVariable;
                }

                protected IrValueDeclaration remapVariable(IrValueDeclaration value2) {
                    Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                    return Intrinsics.areEqual((Object)value2, (Object)this.$inductionVariable) || Intrinsics.areEqual((Object)value2, (Object)this.$loopVariable) ? (IrValueDeclaration)this.$newLoopVariable : null;
                }
            };
            irForLoopBlock.getStatements().get(1).transformChildren(remapper2, null);
        }

        private final Pair<IrContainerExpression, Integer> findLoopVariablePosition(IrStatement statement2) {
            IrStatement irStatement = statement2;
            if (irStatement instanceof IrDoWhileLoop) {
                int loopVariableIndex;
                IrComposite iterationInitialization;
                block10: {
                    int n;
                    if (!Intrinsics.areEqual((Object)((IrDoWhileLoop)statement2).getOrigin(), (Object)JvmLoweredStatementOrigin.INSTANCE.getDO_WHILE_COUNTER_LOOP())) {
                        return null;
                    }
                    IrExpression irExpression = ((IrDoWhileLoop)statement2).getBody();
                    IrComposite irComposite = irExpression instanceof IrComposite ? (IrComposite)irExpression : null;
                    if (irComposite == null) {
                        return null;
                    }
                    IrComposite doWhileLoopBody = irComposite;
                    if (!Intrinsics.areEqual((Object)doWhileLoopBody.getOrigin(), (Object)IrStatementOrigin.Companion.getFOR_LOOP_INNER_WHILE())) {
                        return null;
                    }
                    IrStatement irStatement2 = doWhileLoopBody.getStatements().get(0);
                    IrComposite irComposite2 = irStatement2 instanceof IrComposite ? (IrComposite)irStatement2 : null;
                    if (irComposite2 == null) {
                        return null;
                    }
                    iterationInitialization = irComposite2;
                    List<IrStatement> $this$indexOfFirst$iv = iterationInitialization.getStatements();
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<IrStatement> iterator2 = $this$indexOfFirst$iv.iterator();
                    while (iterator2.hasNext()) {
                        IrStatement item$iv;
                        IrStatement it = item$iv = iterator2.next();
                        boolean bl = false;
                        if (this.isLoopVariable(it)) {
                            n = index$iv;
                            break block10;
                        }
                        ++index$iv;
                    }
                    n = loopVariableIndex = -1;
                }
                if (loopVariableIndex < 0) {
                    return null;
                }
                return TuplesKt.to((Object)iterationInitialization, (Object)loopVariableIndex);
            }
            if (irStatement instanceof IrWhen) {
                IrExpression irExpression = ((IrWhen)statement2).getBranches().get(0).getResult();
                IrDoWhileLoop irDoWhileLoop = irExpression instanceof IrDoWhileLoop ? (IrDoWhileLoop)irExpression : null;
                if (irDoWhileLoop == null) {
                    return null;
                }
                IrDoWhileLoop doWhileLoop = irDoWhileLoop;
                return this.findLoopVariablePosition(doWhileLoop);
            }
            return null;
        }

        private final boolean isLoopVariable(IrStatement $this$isLoopVariable) {
            return $this$isLoopVariable instanceof IrVariable && Intrinsics.areEqual((Object)((IrVariable)$this$isLoopVariable).getOrigin(), (Object)IrDeclarationOrigin.Companion.getFOR_LOOP_VARIABLE());
        }

        private final IrCall rewritePostfixIncrDecr(IrContainerExpression $this$rewritePostfixIncrDecr) {
            if (!Intrinsics.areEqual((Object)$this$rewritePostfixIncrDecr.getOrigin(), (Object)IrStatementOrigin.Companion.getPOSTFIX_INCR()) && !Intrinsics.areEqual((Object)$this$rewritePostfixIncrDecr.getOrigin(), (Object)IrStatementOrigin.Companion.getPOSTFIX_DECR())) {
                return null;
            }
            IrStatement irStatement = $this$rewritePostfixIncrDecr.getStatements().get(0);
            IrVariable irVariable = irStatement instanceof IrVariable ? (IrVariable)irStatement : null;
            if (irVariable == null) {
                return null;
            }
            IrVariable tmpVar = irVariable;
            IrExpression irExpression = tmpVar.getInitializer();
            IrGetValue irGetValue = irExpression instanceof IrGetValue ? (IrGetValue)irExpression : null;
            if (irGetValue == null) {
                return null;
            }
            IrGetValue getIncrVar = irGetValue;
            if (!IrTypePredicatesKt.isInt(getIncrVar.getType())) {
                return null;
            }
            IrStatement irStatement2 = $this$rewritePostfixIncrDecr.getStatements().get(1);
            IrSetValue irSetValue = irStatement2 instanceof IrSetValue ? (IrSetValue)irStatement2 : null;
            if (irSetValue == null) {
                return null;
            }
            IrSetValue setVar = irSetValue;
            if (!Intrinsics.areEqual((Object)setVar.getSymbol(), (Object)getIncrVar.getSymbol())) {
                return null;
            }
            IrExpression irExpression2 = setVar.getValue();
            IrCall irCall = irExpression2 instanceof IrCall ? (IrCall)irExpression2 : null;
            if (irCall == null) {
                return null;
            }
            IrCall setVarValue = irCall;
            Name calleeName = ((IrSimpleFunction)setVarValue.getSymbol().getOwner()).getName();
            if (!Intrinsics.areEqual((Object)calleeName, (Object)OperatorNameConventions.INC) && !Intrinsics.areEqual((Object)calleeName, (Object)OperatorNameConventions.DEC)) {
                return null;
            }
            IrExpression irExpression3 = setVarValue.getDispatchReceiver();
            IrGetValue irGetValue2 = irExpression3 instanceof IrGetValue ? (IrGetValue)irExpression3 : null;
            if (irGetValue2 == null) {
                return null;
            }
            IrGetValue calleeArg = irGetValue2;
            if (!Intrinsics.areEqual((Object)calleeArg.getSymbol(), (Object)tmpVar.getSymbol())) {
                return null;
            }
            IrStatement irStatement3 = $this$rewritePostfixIncrDecr.getStatements().get(2);
            IrGetValue irGetValue3 = irStatement3 instanceof IrGetValue ? (IrGetValue)irStatement3 : null;
            if (irGetValue3 == null) {
                return null;
            }
            IrGetValue getTmpVar = irGetValue3;
            if (!Intrinsics.areEqual((Object)getTmpVar.getSymbol(), (Object)tmpVar.getSymbol())) {
                return null;
            }
            IrConstImpl<Integer> delta = Intrinsics.areEqual((Object)calleeName, (Object)OperatorNameConventions.INC) ? IrConstImpl.Companion.int($this$rewritePostfixIncrDecr.getStartOffset(), $this$rewritePostfixIncrDecr.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getIntType(), 1) : IrConstImpl.Companion.int($this$rewritePostfixIncrDecr.getStartOffset(), $this$rewritePostfixIncrDecr.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getIntType(), -1);
            IrStatement $this$rewritePostfixIncrDecr_u24lambda_u2414 = irStatement3 = IrCallImpl.Companion.fromSymbolOwner($this$rewritePostfixIncrDecr.getStartOffset(), $this$rewritePostfixIncrDecr.getEndOffset(), JvmOptimizationLowering.this.getContext().getIr().getSymbols().getIntPostfixIncrDecr());
            boolean bl = false;
            ((IrMemberAccessExpression)$this$rewritePostfixIncrDecr_u24lambda_u2414).putValueArgument(0, getIncrVar);
            ((IrMemberAccessExpression)$this$rewritePostfixIncrDecr_u24lambda_u2414).putValueArgument(1, delta);
            return (IrCall)irStatement3;
        }

        @Override
        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2, @Nullable IrDeclaration data2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrValueDeclaration variable2 = expression2.getSymbol().getOwner();
            IrExpression replacement = this.getInlineableValueForTemporaryVal(variable2);
            return replacement instanceof IrConst ? (IrExpression)IrConstImplKt.copyWithOffsets((IrConst)replacement, expression2.getStartOffset(), expression2.getEndOffset()) : (replacement instanceof IrGetValue ? (IrExpression)IrGetValueImplKt.copyWithOffsets((IrGetValue)replacement, expression2.getStartOffset(), expression2.getEndOffset()) : (IrExpression)expression2);
        }

        @Override
        @NotNull
        public IrExpression visitSetValue(@NotNull IrSetValue expression2, @Nullable IrDeclaration data2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            expression2.transformChildren(this, data2);
            IrExpression irExpression = this.rewritePrefixIncrDecr(expression2);
            if (irExpression == null) {
                irExpression = expression2;
            }
            return irExpression;
        }

        private final IrExpression rewritePrefixIncrDecr(IrSetValue expression2) {
            if (!IrTypePredicatesKt.isInt(expression2.getSymbol().getOwner().getType())) {
                return null;
            }
            IrStatementOrigin irStatementOrigin = expression2.getOrigin();
            if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getPREFIX_INCR()) ? true : Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getPREFIX_DECR())) {
                return this.prefixIncr(expression2, Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getPREFIX_INCR()) ? 1 : -1);
            }
            if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getPLUSEQ()) ? true : Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getMINUSEQ())) {
                IrExpression irExpression = expression2.getValue();
                Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                IrExpression irExpression2 = ((IrCall)irExpression).getValueArgument(0);
                Intrinsics.checkNotNull((Object)irExpression2);
                IrExpression argument2 = irExpression2;
                if (!this.hasSameLineNumber(argument2, expression2)) {
                    return null;
                }
                return this.rewriteCompoundAssignmentAsPrefixIncrDecr(expression2, argument2, Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getMINUSEQ()));
            }
            if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getEQ())) {
                IrExpression value2 = expression2.getValue();
                if (!this.hasSameLineNumber(value2, expression2)) {
                    return null;
                }
                if (value2 instanceof IrCall) {
                    IrExpression irExpression = ((IrCall)value2).getDispatchReceiver();
                    if (irExpression == null) {
                        return null;
                    }
                    IrExpression receiver = irExpression;
                    IrValueSymbol symbol2 = expression2.getSymbol();
                    if (!this.hasSameLineNumber(receiver, expression2)) {
                        return null;
                    }
                    if (Intrinsics.areEqual((Object)((IrCall)value2).getOrigin(), (Object)IrStatementOrigin.Companion.getPLUS()) || Intrinsics.areEqual((Object)((IrCall)value2).getOrigin(), (Object)IrStatementOrigin.Companion.getMINUS())) {
                        IrExpression irExpression3 = ((IrCall)value2).getValueArgument(0);
                        Intrinsics.checkNotNull((Object)irExpression3);
                        IrExpression argument3 = irExpression3;
                        if (receiver instanceof IrGetValue && Intrinsics.areEqual((Object)((IrGetValue)receiver).getSymbol(), (Object)symbol2) && this.hasSameLineNumber(argument3, expression2)) {
                            return this.rewriteCompoundAssignmentAsPrefixIncrDecr(expression2, argument3, Intrinsics.areEqual((Object)((IrCall)value2).getOrigin(), (Object)IrStatementOrigin.Companion.getMINUS()));
                        }
                    }
                }
            }
            return null;
        }

        private final IrExpression rewriteCompoundAssignmentAsPrefixIncrDecr(IrSetValue expression2, IrExpression value2, boolean isMinus) {
            if (value2 instanceof IrConst && Intrinsics.areEqual(((IrConst)value2).getKind(), (Object)IrConstKind.Int.INSTANCE)) {
                int delta = ((Number)IrConstKind.Int.INSTANCE.valueOf((IrConst)value2)).intValue();
                int upperBound = 127 + (isMinus ? 1 : 0);
                int lowerBound2 = -128 + (isMinus ? 1 : 0);
                boolean bl = lowerBound2 <= delta ? delta <= upperBound : false;
                if (bl) {
                    return this.prefixIncr(expression2, isMinus ? -delta : delta);
                }
            }
            return null;
        }

        private final IrExpression prefixIncr(IrSetValue expression2, int delta) {
            int startOffset = expression2.getStartOffset();
            int endOffset = expression2.getEndOffset();
            IrCallImpl irCallImpl = IrCallImpl.Companion.fromSymbolOwner(startOffset, endOffset, JvmOptimizationLowering.this.getContext().getIr().getSymbols().getIntPrefixIncrDecr());
            JvmOptimizationLowering jvmOptimizationLowering = JvmOptimizationLowering.this;
            IrCallImpl $this$prefixIncr_u24lambda_u2415 = irCallImpl;
            boolean bl = false;
            $this$prefixIncr_u24lambda_u2415.putValueArgument(0, new IrGetValueImpl(startOffset, endOffset, expression2.getSymbol(), null, 8, null));
            $this$prefixIncr_u24lambda_u2415.putValueArgument(1, IrConstImpl.Companion.int(startOffset, endOffset, jvmOptimizationLowering.getContext().getIrBuiltIns().getIntType(), delta));
            return irCallImpl;
        }

        private final boolean hasSameLineNumber(IrElement e1, IrElement e2) {
            return this.getLineNumberForOffset(e1.getStartOffset()) == this.getLineNumberForOffset(e2.getStartOffset());
        }

        private final int getLineNumberForOffset(int offset) {
            return this.fileEntry.getLineNumber(offset) + 1;
        }

        @Override
        @NotNull
        public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitBlock(@NotNull IrBlock expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrBody visitBody(@NotNull IrBody body2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitBody(this, body2, data2);
        }

        @Override
        @NotNull
        public IrBranch visitBranch(@NotNull IrBranch branch, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data2);
        }

        @Override
        @NotNull
        public IrExpression visitBreak(@NotNull IrBreak jump, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data2);
        }

        @Override
        @NotNull
        public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data2);
        }

        @Override
        @NotNull
        public IrElement visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrCatch visitCatch(@NotNull IrCatch aCatch, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data2);
        }

        @Override
        @NotNull
        public IrStatement visitClass(@NotNull IrClass declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitClass(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitClassReference(@NotNull IrClassReference expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitComposite(@NotNull IrComposite expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitConst(@NotNull IrConst<?> expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrConstantValue visitConstantArray(@NotNull IrConstantArray expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitConstantArray(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrConstantValue visitConstantObject(@NotNull IrConstantObject expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitConstantObject(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrConstantValue visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrConstantValue visitConstantValue(@NotNull IrConstantValue expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitConstantValue(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitConstructor(@NotNull IrConstructor declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrElement visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitConstructorCall(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitContinue(@NotNull IrContinue jump, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data2);
        }

        @Override
        @NotNull
        public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrElement visitElement(@NotNull IrElement element2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitElement(this, element2, data2);
        }

        @Override
        @NotNull
        public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data2);
        }

        @Override
        @NotNull
        public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitExpression(@NotNull IrExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body2, data2);
        }

        @Override
        @NotNull
        public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitField(@NotNull IrField declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitField(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrFile visitFile(@NotNull IrFile declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitFile(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitFunction(@NotNull IrFunction declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitFunction(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitFunctionExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitGetClass(@NotNull IrGetClass expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitGetField(@NotNull IrGetField expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data2);
        }

        @Override
        @NotNull
        public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitLoop(@NotNull IrLoop loop2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitLoop(this, loop2, data2);
        }

        @Override
        @NotNull
        public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitProperty(@NotNull IrProperty declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitProperty(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitReturn(@NotNull IrReturn expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitReturnableBlock(@NotNull IrReturnableBlock expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitReturnableBlock(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitScript(@NotNull IrScript declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitScript(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitSetField(@NotNull IrSetField expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data2);
        }

        @Override
        @NotNull
        public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitThrow(@NotNull IrThrow expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitTry(@NotNull IrTry aTry, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data2);
        }

        @Override
        @NotNull
        public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitVararg(@NotNull IrVararg expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitVariable(@NotNull IrVariable declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitVariable(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop2, data2);
        }

        private static final boolean visitWhen$lambda$4(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean removeUnnecessaryTemporaryVariables$lambda$9(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ IrExpression access$getInlineableValueForTemporaryVal(Transformer $this, IrStatement statement2) {
            return $this.getInlineableValueForTemporaryVal(statement2);
        }
    }
}

