/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.FileLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import ksp.org.jetbrains.kotlin.backend.common.phaser.NamedCompilerPhase;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PerformByIrFileKt;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseBuildersKt;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseConfigurationService;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaserState;
import ksp.org.jetbrains.kotlin.backend.common.phaser.SameTypeCompilerPhase;
import ksp.org.jetbrains.kotlin.backend.jvm.FileCodegen;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmLoweringPhasesKt;
import ksp.org.jetbrains.kotlin.ir.declarations.IrModuleFragment;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\u001a,\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002\"*\u0010\u0000\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"0\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"-\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\r"}, d2={"generateAdditionalClassesPhase", "Lksp/org/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "Lksp/org/jetbrains/kotlin/backend/common/phaser/SameTypeNamedCompilerPhase;", "jvmCodegenPhases", "getJvmCodegenPhases", "()Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "jvmPhases", "getJvmPhases", "codegenPhase", "generateMultifileFacade", "", "backend.jvm.entrypoint"})
public final class JvmPhasesKt {
    @NotNull
    private static final NamedCompilerPhase<JvmBackendContext, IrModuleFragment> generateAdditionalClassesPhase = new NamedCompilerPhase("GenerateAdditionalClasses", "Generate additional classes that were requested during codegen", null, new SameTypeCompilerPhase<JvmBackendContext, IrModuleFragment>(){

        public IrModuleFragment invoke(PhaseConfigurationService phaseConfig, PhaserState<IrModuleFragment> phaserState, JvmBackendContext context2, IrModuleFragment input) {
            Intrinsics.checkNotNullParameter((Object)phaseConfig, (String)"phaseConfig");
            Intrinsics.checkNotNullParameter(phaserState, (String)"phaserState");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            context2.getEnumEntriesIntrinsicMappingsCache().generateMappingsClasses();
            return input;
        }
    }, null, null, null, null, 0, 500, null);
    @NotNull
    private static final NamedCompilerPhase<JvmBackendContext, IrModuleFragment> jvmCodegenPhases;

    private static final NamedCompilerPhase<JvmBackendContext, IrModuleFragment> codegenPhase(boolean generateMultifileFacade) {
        String suffix = generateMultifileFacade ? "MultifileFacades" : "Regular";
        String descriptionSuffix = generateMultifileFacade ? ", multifile facades" : ", regular files";
        return PerformByIrFileKt.performByIrFile("CodegenByIrFile" + suffix, "Code generation by IrFile" + descriptionSuffix, false, CollectionsKt.listOf((Object)PhaseBuildersKt.makeIrFilePhase$default((Function1)new Function1<JvmBackendContext, FileLoweringPass>(generateMultifileFacade){
            final /* synthetic */ boolean $generateMultifileFacade;
            {
                this.$generateMultifileFacade = $generateMultifileFacade;
                super(1);
            }

            public final FileLoweringPass invoke(JvmBackendContext context2) {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                return new FileCodegen(context2, this.$generateMultifileFacade);
            }
        }, "Codegen" + suffix, "Code generation", null, null, null, 56, null)));
    }

    @NotNull
    public static final NamedCompilerPhase<JvmBackendContext, IrModuleFragment> getJvmCodegenPhases() {
        return jvmCodegenPhases;
    }

    @NotNull
    public static final NamedCompilerPhase<JvmBackendContext, IrModuleFragment> getJvmPhases() {
        return JvmLoweringPhasesKt.getJvmLoweringPhases();
    }

    static {
        CompilerPhase compilerPhase = PhaseBuildersKt.then(PhaseBuildersKt.then((CompilerPhase)JvmPhasesKt.codegenPhase(true), (CompilerPhase)JvmPhasesKt.codegenPhase(false)), (CompilerPhase)generateAdditionalClassesPhase);
        jvmCodegenPhases = new NamedCompilerPhase("Codegen", "Code generation", null, compilerPhase, null, null, null, null, 1, 244, null);
    }
}

