/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.serialization.DeclarationTableKt;
import ksp.org.jetbrains.kotlin.backend.common.serialization.DeserializationStrategy;
import ksp.org.jetbrains.kotlin.backend.common.serialization.FunctionalInterfacesUtilsKt;
import ksp.org.jetbrains.kotlin.backend.common.serialization.IdSignatureDeserializer;
import ksp.org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializer;
import ksp.org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import ksp.org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerKind;
import ksp.org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerKt;
import ksp.org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import ksp.org.jetbrains.kotlin.ir.IrBuiltIns;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import ksp.org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol;
import ksp.org.jetbrains.kotlin.ir.util.IdSignature;
import ksp.org.jetbrains.kotlin.library.IrLibrary;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\bH\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001cH\u0002J\u0011\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020\bH\u0096\u0002J\u0010\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\tH\u0016J\b\u0010*\u001a\u00020!H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010\"\u001a\u00020\bH\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0013H\u0016J\b\u0010/\u001a\u00020!H\u0016J\b\u00100\u001a\u00020!H\u0016J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\bH\u0016J\u0018\u00106\u001a\u0002072\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\bH\u0016J\u0018\u00108\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\b2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u001cH\u0016J\u001a\u0010>\u001a\u0004\u0018\u00010\t2\u0006\u0010\"\u001a\u00020\b2\u0006\u00109\u001a\u00020:H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006?"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerWithBuiltIns;", "Lksp/org/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "builtIns", "Lksp/org/jetbrains/kotlin/ir/IrBuiltIns;", "delegate", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;)V", "irBuiltInsMap", "", "Lksp/org/jetbrains/kotlin/ir/util/IdSignature;", "Lksp/org/jetbrains/kotlin/ir/symbols/IrSymbol;", "kind", "Lksp/org/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerKind;", "getKind", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerKind;", "klib", "Lksp/org/jetbrains/kotlin/library/IrLibrary;", "getKlib", "()Lorg/jetbrains/kotlin/library/IrLibrary;", "moduleDependencies", "", "getModuleDependencies", "()Ljava/util/Collection;", "moduleFragment", "Lksp/org/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getModuleFragment", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "strategyResolver", "Lkotlin/Function1;", "", "Lksp/org/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "getStrategyResolver", "()Lkotlin/jvm/functions/Function1;", "addModuleReachableTopLevel", "", "idSig", "computeFunctionClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "className", "contains", "", "declareIrSymbol", "symbol", "deserializeReachableDeclarations", "deserializedSymbolNotFound", "", "fileDeserializers", "Lksp/org/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer;", "init", "postProcess", "referencePropertyByLocalSignature", "Lksp/org/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "file", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "idSignature", "referenceSimpleFunctionByLocalSignature", "Lksp/org/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "resolveFunctionalInterface", "symbolKind", "Lksp/org/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "signatureDeserializerForFile", "Lksp/org/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer;", "fileName", "tryDeserializeIrSymbol", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIrModuleDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrModuleDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerWithBuiltIns\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,262:1\n1177#2,2:263\n1251#2,4:265\n616#2,12:276\n798#2,11:288\n616#2,12:299\n1#3:269\n151#4,6:270\n*S KotlinDebug\n*F\n+ 1 IrModuleDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerWithBuiltIns\n*L\n121#1:263,2\n121#1:265,4\n178#1:276,12\n187#1:288,11\n187#1:299,12\n146#1:270,6\n*E\n"})
public final class IrModuleDeserializerWithBuiltIns
extends IrModuleDeserializer {
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final IrModuleDeserializer delegate;
    @NotNull
    private final Map<IdSignature, IrSymbol> irBuiltInsMap;

    /*
     * WARNING - void declaration
     */
    public IrModuleDeserializerWithBuiltIns(@NotNull IrBuiltIns builtIns2, @NotNull IrModuleDeserializer delegate2) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)builtIns2, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
        super(delegate2.getModuleDescriptor(), delegate2.getLibraryAbiVersion());
        this.builtIns = builtIns2;
        this.delegate = delegate2;
        Iterable iterable = DeclarationTableKt.getKnownBuiltins(this.builtIns);
        IrModuleDeserializerWithBuiltIns irModuleDeserializerWithBuiltIns = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var6_7 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            IrDeclaration it = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
            IrSymbol symbol2 = ((IrSymbolOwner)it).getSymbol();
            Pair pair = TuplesKt.to((Object)symbol2.getSignature(), (Object)symbol2);
            map.put(pair.getFirst(), pair.getSecond());
        }
        irModuleDeserializerWithBuiltIns.irBuiltInsMap = destination$iv$iv;
    }

    @Override
    public boolean contains(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
        IdSignature topLevel = idSig.topLevelSignature();
        if (this.irBuiltInsMap.containsKey(topLevel)) {
            return true;
        }
        return FunctionalInterfacesUtilsKt.checkIsFunctionInterface(topLevel) || this.delegate.contains(idSig);
    }

    @Override
    @NotNull
    public IrSimpleFunctionSymbol referenceSimpleFunctionByLocalSignature(@NotNull IrFile file2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)idSignature, (String)"idSignature");
        return this.delegate.referenceSimpleFunctionByLocalSignature(file2, idSignature);
    }

    @Override
    @NotNull
    public IrPropertySymbol referencePropertyByLocalSignature(@NotNull IrFile file2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)idSignature, (String)"idSignature");
        return this.delegate.referencePropertyByLocalSignature(file2, idSignature);
    }

    @Override
    public void deserializeReachableDeclarations() {
        this.delegate.deserializeReachableDeclarations();
    }

    private final IrClass computeFunctionClass(String className2) {
        int n;
        String string2;
        boolean isSuspend;
        boolean isK;
        block1: {
            isK = className2.charAt(0) == 'K';
            isSuspend = (isK ? className2.charAt(1) : className2.charAt(0)) == 'S';
            String $this$computeFunctionClass_u24lambda_u242 = className2;
            boolean bl = false;
            string2 = $this$computeFunctionClass_u24lambda_u242;
            CharSequence $this$indexOfFirst$iv = $this$computeFunctionClass_u24lambda_u242;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl2 = false;
                if (!Character.isDigit(it)) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        int n3 = n;
        String string3 = string2.substring(n3);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        string2 = string3;
        n3 = 10;
        int arity = Integer.parseInt(string2, CharsKt.checkRadix((int)n3));
        IrBuiltIns $this$computeFunctionClass_u24lambda_u243 = this.builtIns;
        boolean bl = false;
        return isK && isSuspend ? $this$computeFunctionClass_u24lambda_u243.kSuspendFunctionN(arity) : (isK ? $this$computeFunctionClass_u24lambda_u243.kFunctionN(arity) : (isSuspend ? $this$computeFunctionClass_u24lambda_u243.suspendFunctionN(arity) : $this$computeFunctionClass_u24lambda_u243.functionN(arity)));
    }

    /*
     * WARNING - void declaration
     */
    private final IrSymbol resolveFunctionalInterface(IdSignature idSig, BinarySymbolData.SymbolKind symbolKind) {
        IrSymbol irSymbol2;
        if (symbolKind == BinarySymbolData.SymbolKind.TYPE_PARAMETER_SYMBOL) {
            Intrinsics.checkNotNull((Object)idSig, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.util.IdSignature.CompositeSignature");
            IdSignature.CompositeSignature composite = (IdSignature.CompositeSignature)idSig;
            IdSignature classSignature = ((IdSignature.CompositeSignature)idSig).getContainer();
            IrSymbol irSymbol3 = this.resolveFunctionalInterface(classSignature, BinarySymbolData.SymbolKind.CLASS_SYMBOL);
            Intrinsics.checkNotNull((Object)irSymbol3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrClassSymbol");
            IrClassSymbol classSymbol2 = (IrClassSymbol)irSymbol3;
            IdSignature idSignature = composite.getInner();
            Intrinsics.checkNotNull((Object)idSignature, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.util.IdSignature.LocalSignature");
            IdSignature.LocalSignature typeParameterSig = (IdSignature.LocalSignature)idSignature;
            int typeParameterIndex = typeParameterSig.index();
            IrTypeParameter typeParameter = ((IrClass)classSymbol2.getOwner()).getTypeParameters().get(typeParameterIndex);
            return typeParameter.getSymbol();
        }
        IdSignature.CommonSignature commonSignature = idSig.asPublic();
        if (commonSignature == null) {
            throw new IllegalStateException((idSig + " has to be public").toString());
        }
        IdSignature.CommonSignature publicSig = commonSignature;
        List<String> fqnParts = publicSig.getNameSegments();
        String string2 = (String)CollectionsKt.firstOrNull(fqnParts);
        if (string2 == null) {
            throw new IllegalStateException(("Expected class name for " + idSig).toString());
        }
        String className2 = string2;
        IrClass functionClass2 = this.computeFunctionClass(className2);
        switch (fqnParts.size()) {
            case 1: {
                boolean bl;
                IrClassSymbol typeParameter;
                IrClassSymbol it = typeParameter = functionClass2.getSymbol();
                boolean bl2 = false;
                boolean bl3 = bl = symbolKind == BinarySymbolData.SymbolKind.CLASS_SYMBOL;
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                irSymbol2 = typeParameter;
                break;
            }
            case 2: {
                String memberName = fqnParts.get(1);
                Iterable $this$single$iv2 = functionClass2.getDeclarations();
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv2) {
                    IrDeclaration it = (IrDeclaration)element$iv;
                    boolean bl = false;
                    if (!(it instanceof IrDeclarationWithName && Intrinsics.areEqual((Object)((IrDeclarationWithName)it).getName().asString(), (Object)memberName))) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                IrDeclaration it = single$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
                irSymbol2 = ((IrSymbolOwner)it).getSymbol();
                break;
            }
            case 3: {
                void $this$single$iv;
                void $this$filterIsInstanceTo$iv$iv;
                boolean memberName = idSig instanceof IdSignature.AccessorSignature;
                if (_Assertions.ENABLED && !memberName) {
                    String $this$single$iv2 = "Assertion failed";
                    throw new AssertionError((Object)$this$single$iv2);
                }
                boolean bl = memberName = symbolKind == BinarySymbolData.SymbolKind.FUNCTION_SYMBOL;
                if (_Assertions.ENABLED && !memberName) {
                    String $this$single$iv2 = "Assertion failed";
                    throw new AssertionError((Object)$this$single$iv2);
                }
                String propertyName = fqnParts.get(1);
                String accessorName = fqnParts.get(2);
                Iterable $this$filterIsInstance$iv = functionClass2.getDeclarations();
                boolean $i$f$filterIsInstance = false;
                Iterable found$iv = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof IrProperty)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv2 = false;
                for (Object element$iv : $this$single$iv) {
                    IrProperty it = (IrProperty)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)propertyName)) continue;
                    if (found$iv2) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv2 = true;
                }
                if (!found$iv2) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                IrProperty p = single$iv;
                boolean bl5 = false;
                IrSimpleFunction irSimpleFunction = p.getGetter();
                if (irSimpleFunction != null) {
                    IrSimpleFunction g = irSimpleFunction;
                    boolean bl6 = false;
                    if (Intrinsics.areEqual((Object)g.getName().asString(), (Object)accessorName)) {
                        return g.getSymbol();
                    }
                }
                IrSimpleFunction irSimpleFunction2 = p.getSetter();
                if (irSimpleFunction2 != null) {
                    IrSimpleFunction s = irSimpleFunction2;
                    boolean bl7 = false;
                    if (Intrinsics.areEqual((Object)s.getName().asString(), (Object)accessorName)) {
                        return s.getSymbol();
                    }
                }
                throw new IllegalStateException(("No accessor found for signature " + idSig).toString());
            }
            default: {
                throw new IllegalStateException(("No member found for signature " + idSig).toString());
            }
        }
        return irSymbol2;
    }

    @Override
    @Nullable
    public IrSymbol tryDeserializeIrSymbol(@NotNull IdSignature idSig, @NotNull BinarySymbolData.SymbolKind symbolKind) {
        Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
        Intrinsics.checkNotNullParameter((Object)((Object)symbolKind), (String)"symbolKind");
        IrSymbol irSymbol2 = this.irBuiltInsMap.get(idSig);
        if (irSymbol2 != null) {
            IrSymbol it = irSymbol2;
            boolean bl = false;
            return it;
        }
        IdSignature topLevel = idSig.topLevelSignature();
        if (FunctionalInterfacesUtilsKt.checkIsFunctionInterface(topLevel)) {
            return this.resolveFunctionalInterface(idSig, symbolKind);
        }
        return this.delegate.tryDeserializeIrSymbol(idSig, symbolKind);
    }

    @Override
    @NotNull
    public Void deserializedSymbolNotFound(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
        this.delegate.deserializedSymbolNotFound(idSig);
        throw null;
    }

    @Override
    public void declareIrSymbol(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        IdSignature signature = symbol2.getSignature();
        if (signature != null && FunctionalInterfacesUtilsKt.checkIsFunctionInterface(signature)) {
            this.resolveFunctionalInterface(signature, IrModuleDeserializerKt.kind(symbol2));
        } else {
            this.delegate.declareIrSymbol(symbol2);
        }
    }

    @Override
    public void init() {
        this.delegate.init(this);
    }

    @Override
    @NotNull
    public IrLibrary getKlib() {
        return this.delegate.getKlib();
    }

    @Override
    @NotNull
    public Function1<String, DeserializationStrategy> getStrategyResolver() {
        return this.delegate.getStrategyResolver();
    }

    @Override
    public void addModuleReachableTopLevel(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
        this.delegate.addModuleReachableTopLevel(idSig);
    }

    @Override
    @NotNull
    public IrModuleFragment getModuleFragment() {
        return this.delegate.getModuleFragment();
    }

    @Override
    @NotNull
    public Collection<IrModuleDeserializer> getModuleDependencies() {
        return this.delegate.getModuleDependencies();
    }

    @Override
    @NotNull
    public IrModuleDeserializerKind getKind() {
        return this.delegate.getKind();
    }

    @Override
    @NotNull
    public Collection<IrFileDeserializer> fileDeserializers() {
        return this.delegate.fileDeserializers();
    }

    @Override
    public void postProcess() {
        this.delegate.postProcess();
    }

    @Override
    @NotNull
    public IdSignatureDeserializer signatureDeserializerForFile(@NotNull String fileName2) {
        Intrinsics.checkNotNullParameter((Object)fileName2, (String)"fileName");
        return this.delegate.signatureDeserializerForFile(fileName2);
    }
}

