/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.project.structure;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.analysis.project.structure.DanglingFileResolutionMode;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtModule;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtModuleInternalUtilsKt;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtNotUnderContentRootModule;
import ksp.org.jetbrains.kotlin.analysis.project.structure.ProjectStructureProviderKt;
import ksp.org.jetbrains.kotlin.analysis.project.structure.impl.KtDanglingFileModuleImpl;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import ksp.org.jetbrains.kotlin.psi.KtFile;
import ksp.org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0004J\u001a\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\nH&J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H$R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lksp/org/jetbrains/kotlin/analysis/project/structure/ProjectStructureProvider;", "", "()V", "globalLanguageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "getGlobalLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "libraryLanguageVersionSettings", "getLibraryLanguageVersionSettings", "computeContextModule", "Lksp/org/jetbrains/kotlin/analysis/project/structure/KtModule;", "file", "Lksp/org/jetbrains/kotlin/psi/KtFile;", "computeDefaultDanglingFileResolutionMode", "Lksp/org/jetbrains/kotlin/analysis/project/structure/DanglingFileResolutionMode;", "computeSpecialModule", "Lksp/com/intellij/psi/PsiFile;", "getModule", "element", "Lksp/com/intellij/psi/PsiElement;", "contextualModule", "getNotUnderContentRootModule", "Lksp/org/jetbrains/kotlin/analysis/project/structure/KtNotUnderContentRootModule;", "project", "Lksp/com/intellij/openapi/project/Project;", "Companion", "project-structure"})
@SourceDebugExtension(value={"SMAP\nProjectStructureProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectStructureProvider.kt\norg/jetbrains/kotlin/analysis/project/structure/ProjectStructureProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n1#2:171\n*E\n"})
public abstract class ProjectStructureProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract KtModule getModule(@NotNull PsiElement var1, @Nullable KtModule var2);

    @NotNull
    protected abstract KtNotUnderContentRootModule getNotUnderContentRootModule(@NotNull Project var1);

    @Nullable
    protected final KtModule computeSpecialModule(@NotNull PsiFile file2) {
        KtModule contextModule;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 != null && (contextModule = KtModuleInternalUtilsKt.getAnalysisExtensionFileContextModule(virtualFile2)) != null) {
            return contextModule;
        }
        if (file2 instanceof KtFile && ProjectStructureProviderKt.isDangling((KtFile)file2)) {
            contextModule = this.computeContextModule((KtFile)file2);
            DanglingFileResolutionMode danglingFileResolutionMode = ProjectStructureProviderKt.getDanglingFileResolutionMode((KtFile)file2);
            if (danglingFileResolutionMode == null) {
                danglingFileResolutionMode = this.computeDefaultDanglingFileResolutionMode((KtFile)file2);
            }
            DanglingFileResolutionMode resolutionMode2 = danglingFileResolutionMode;
            return new KtDanglingFileModuleImpl((KtFile)file2, contextModule, resolutionMode2);
        }
        return null;
    }

    private final DanglingFileResolutionMode computeDefaultDanglingFileResolutionMode(KtFile file2) {
        if (!(file2.isPhysical() || file2.getViewProvider().isEventSystemEnabled() || Intrinsics.areEqual((Object)file2.getOriginalFile(), (Object)file2))) {
            return DanglingFileResolutionMode.IGNORE_SELF;
        }
        return DanglingFileResolutionMode.PREFER_SELF;
    }

    private final KtModule computeContextModule(KtFile file2) {
        PsiElement contextElement;
        PsiElement psiElement = file2.getContext();
        if (psiElement == null && (psiElement = KtPsiFactoryKt.getAnalysisContext(file2)) == null) {
            PsiFile psiFile;
            PsiFile it = psiFile = file2.getOriginalFile();
            boolean bl = false;
            psiElement = it != file2 ? psiFile : null;
        }
        if ((contextElement = psiElement) != null) {
            return this.getModule(contextElement, null);
        }
        Project project = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this.getNotUnderContentRootModule(project);
    }

    @NotNull
    public LanguageVersionSettings getGlobalLanguageVersionSettings() {
        return LanguageVersionSettingsImpl.DEFAULT;
    }

    @NotNull
    public LanguageVersionSettings getLibraryLanguageVersionSettings() {
        return this.getGlobalLanguageVersionSettings();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\b\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/analysis/project/structure/ProjectStructureProvider$Companion;", "", "()V", "getInstance", "Lksp/org/jetbrains/kotlin/analysis/project/structure/ProjectStructureProvider;", "project", "Lksp/com/intellij/openapi/project/Project;", "getModule", "Lksp/org/jetbrains/kotlin/analysis/project/structure/KtModule;", "element", "Lksp/com/intellij/psi/PsiElement;", "contextualModule", "project-structure"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProjectStructureProvider getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ProjectStructureProvider projectStructureProvider2 = project.getService(ProjectStructureProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)projectStructureProvider2, (String)"getService(...)");
            return projectStructureProvider2;
        }

        @NotNull
        public final KtModule getModule(@NotNull Project project, @NotNull PsiElement element2, @Nullable KtModule contextualModule) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            return this.getInstance(project).getModule(element2, contextualModule);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

