/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.api.fir.components;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.analysis.api.components.KtSymbolInfoProvider;
import ksp.org.jetbrains.kotlin.analysis.api.fir.FirUtilsKt;
import ksp.org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSession;
import ksp.org.jetbrains.kotlin.analysis.api.fir.components.KtFirAnalysisSessionComponent;
import ksp.org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirNamedClassOrObjectSymbolBase;
import ksp.org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirPackageSymbol;
import ksp.org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirPsiJavaClassSymbol;
import ksp.org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirSymbol;
import ksp.org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirSyntheticJavaPropertySymbol;
import ksp.org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KtClassOrObjectSymbol;
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KtFunctionSymbol;
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KtPropertySymbol;
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KtReceiverParameterSymbol;
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import ksp.org.jetbrains.kotlin.config.ApiVersion;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import ksp.org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import ksp.org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import ksp.org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationsPlatformSpecificSupportComponentKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirBackingField;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.load.java.JvmAbi;
import ksp.org.jetbrains.kotlin.name.JvmStandardClassIds;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0015H\u0016J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0019H\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0011\u001a\u00020\u0019H\u0016J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0019H\u0016J\f\u0010%\u001a\u00020!*\u00020&H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006'"}, d2={"Lksp/org/jetbrains/kotlin/analysis/api/fir/components/KtFirSymbolInfoProvider;", "Lksp/org/jetbrains/kotlin/analysis/api/components/KtSymbolInfoProvider;", "Lksp/org/jetbrains/kotlin/analysis/api/fir/components/KtFirAnalysisSessionComponent;", "analysisSession", "Lksp/org/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "token", "Lksp/org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "(Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "apiVersion", "Lksp/org/jetbrains/kotlin/config/ApiVersion;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "getAnnotationApplicableTargets", "", "Lksp/org/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "symbol", "Lksp/org/jetbrains/kotlin/analysis/api/symbols/KtClassOrObjectSymbol;", "getDeprecation", "Lksp/org/jetbrains/kotlin/resolve/deprecation/DeprecationInfo;", "Lksp/org/jetbrains/kotlin/analysis/api/symbols/KtSymbol;", "annotationUseSiteTarget", "Lksp/org/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "getGetterDeprecation", "Lksp/org/jetbrains/kotlin/analysis/api/symbols/KtPropertySymbol;", "getJavaGetterName", "Lksp/org/jetbrains/kotlin/name/Name;", "getJavaSetterName", "getJvmName", "property", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "isSetter", "", "getJvmNameAsString", "", "getSetterDeprecation", "mayHaveDeprecation", "Lksp/org/jetbrains/kotlin/analysis/api/fir/symbols/KtFirPsiJavaClassSymbol;", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKtFirSymbolInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFirSymbolInfoProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KtFirSymbolInfoProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 checks.kt\norg/jetbrains/kotlin/analysis/utils/errors/ChecksKt\n*L\n1#1,156:1\n1#2:157\n1#2:165\n1#2:171\n1#2:177\n1745#3,3:158\n13#4,4:161\n17#4:166\n13#4,4:167\n17#4:172\n13#4,4:173\n17#4:178\n*S KotlinDebug\n*F\n+ 1 KtFirSymbolInfoProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KtFirSymbolInfoProvider\n*L\n106#1:165\n118#1:171\n126#1:177\n67#1:158,3\n106#1:161,4\n106#1:166\n118#1:167,4\n118#1:172\n126#1:173,4\n126#1:178\n*E\n"})
public final class KtFirSymbolInfoProvider
extends KtSymbolInfoProvider
implements KtFirAnalysisSessionComponent {
    @NotNull
    private final KtFirAnalysisSession analysisSession;
    @NotNull
    private final KtLifetimeToken token;
    @NotNull
    private final ApiVersion apiVersion;

    public KtFirSymbolInfoProvider(@NotNull KtFirAnalysisSession analysisSession, @NotNull KtLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.analysisSession = analysisSession;
        this.token = token;
        this.apiVersion = FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.getAnalysisSession().getUseSiteSession$analysis_api_fir()).getApiVersion();
    }

    @Override
    @NotNull
    public KtFirAnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KtLifetimeToken getToken() {
        return this.token;
    }

    @Override
    @Nullable
    public DeprecationInfo getDeprecation(@NotNull KtSymbol symbol2) {
        DeprecationInfo deprecationInfo;
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (symbol2 instanceof KtFirPackageSymbol || symbol2 instanceof KtReceiverParameterSymbol) {
            return null;
        }
        if (!(symbol2 instanceof KtFirSymbol)) {
            boolean bl = false;
            String string2 = String.valueOf(Reflection.getOrCreateKotlinClass(this.getClass()));
            throw new IllegalArgumentException(string2.toString());
        }
        if (symbol2 instanceof KtFirPsiJavaClassSymbol && !this.mayHaveDeprecation((KtFirPsiJavaClassSymbol)symbol2)) {
            return null;
        }
        Object firSymbol2 = ((KtFirSymbol)symbol2).getFirSymbol();
        if (firSymbol2 instanceof FirPropertySymbol) {
            AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY};
            deprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(firSymbol2, this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), annotationUseSiteTargetArray);
        } else if (firSymbol2 instanceof FirBackingFieldSymbol) {
            AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.FIELD};
            deprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(firSymbol2, this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), annotationUseSiteTargetArray);
        } else {
            deprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(firSymbol2, this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), new AnnotationUseSiteTarget[0]);
        }
        return deprecationInfo;
    }

    private final boolean mayHaveDeprecation(KtFirPsiJavaClassSymbol $this$mayHaveDeprecation) {
        boolean bl;
        block4: {
            if (!$this$mayHaveDeprecation.getHasAnnotations()) {
                return false;
            }
            Set<String> deprecationAnnotationSimpleNames = FirAnnotationsPlatformSpecificSupportComponentKt.getAnnotationPlatformSupport($this$mayHaveDeprecation.getAnalysisSession().getUseSiteSession$analysis_api_fir()).getDeprecationAnnotationsSimpleNames();
            Iterable $this$any$iv = $this$mayHaveDeprecation.getAnnotationSimpleNames();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(it != null && deprecationAnnotationSimpleNames.contains(it))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public DeprecationInfo getDeprecation(@NotNull KtSymbol symbol2, @Nullable AnnotationUseSiteTarget annotationUseSiteTarget) {
        DeprecationInfo deprecationInfo;
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!(symbol2 instanceof KtFirSymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (annotationUseSiteTarget != null) {
            AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{annotationUseSiteTarget};
            deprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(((KtFirSymbol)symbol2).getFirSymbol(), this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), annotationUseSiteTargetArray);
        } else {
            deprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(((KtFirSymbol)symbol2).getFirSymbol(), this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), new AnnotationUseSiteTarget[0]);
        }
        return deprecationInfo;
    }

    @Override
    @Nullable
    public DeprecationInfo getGetterDeprecation(@NotNull KtPropertySymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!(symbol2 instanceof KtFirSymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY_GETTER, AnnotationUseSiteTarget.PROPERTY};
        return DeprecationUtilsKt.getDeprecationForCallSite(((KtFirSymbol)((Object)symbol2)).getFirSymbol(), this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), annotationUseSiteTargetArray);
    }

    @Override
    @Nullable
    public DeprecationInfo getSetterDeprecation(@NotNull KtPropertySymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!(symbol2 instanceof KtFirSymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY_SETTER, AnnotationUseSiteTarget.PROPERTY};
        return DeprecationUtilsKt.getDeprecationForCallSite(((KtFirSymbol)((Object)symbol2)).getFirSymbol(), this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), annotationUseSiteTargetArray);
    }

    @Override
    @NotNull
    public Name getJavaGetterName(@NotNull KtPropertySymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!(symbol2 instanceof KtFirSymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (symbol2 instanceof KtFirSyntheticJavaPropertySymbol) {
            return ((KtFirSyntheticJavaPropertySymbol)symbol2).getJavaGetterSymbol().getName();
        }
        Object firProperty = ((FirBasedSymbol)((KtFirSymbol)((Object)symbol2)).getFirSymbol()).getFir();
        boolean $i$f$requireIsInstance = false;
        if (!(firProperty instanceof FirProperty)) {
            boolean bl = false;
            String string3 = "Expected " + Reflection.getOrCreateKotlinClass(FirProperty.class) + " instead of " + Reflection.getOrCreateKotlinClass(firProperty.getClass()) + " for " + firProperty;
            throw new IllegalArgumentException(string3.toString());
        }
        return this.getJvmName((FirProperty)firProperty, false);
    }

    @Override
    @Nullable
    public Name getJavaSetterName(@NotNull KtPropertySymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!(symbol2 instanceof KtFirSymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (symbol2 instanceof KtFirSyntheticJavaPropertySymbol) {
            KtFunctionSymbol ktFunctionSymbol = ((KtFirSyntheticJavaPropertySymbol)symbol2).getJavaSetterSymbol();
            return ktFunctionSymbol != null ? ktFunctionSymbol.getName() : null;
        }
        Object firProperty = ((FirBasedSymbol)((KtFirSymbol)((Object)symbol2)).getFirSymbol()).getFir();
        boolean $i$f$requireIsInstance = false;
        if (!(firProperty instanceof FirProperty)) {
            boolean bl = false;
            String string3 = "Expected " + Reflection.getOrCreateKotlinClass(FirProperty.class) + " instead of " + Reflection.getOrCreateKotlinClass(firProperty.getClass()) + " for " + firProperty;
            throw new IllegalArgumentException(string3.toString());
        }
        if (((FirProperty)firProperty).isVal()) {
            return null;
        }
        return this.getJvmName((FirProperty)firProperty, true);
    }

    @Override
    @Nullable
    public Set<KotlinTarget> getAnnotationApplicableTargets(@NotNull KtClassOrObjectSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        boolean $i$f$requireIsInstance = false;
        if (!(symbol2 instanceof KtFirSymbol)) {
            boolean bl = false;
            String string2 = "Expected " + Reflection.getOrCreateKotlinClass(KtFirSymbol.class) + " instead of " + Reflection.getOrCreateKotlinClass(symbol2.getClass()) + " for " + symbol2;
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(symbol2 instanceof KtFirNamedClassOrObjectSymbolBase)) {
            return null;
        }
        if (((FirRegularClassSymbol)((KtFirNamedClassOrObjectSymbolBase)symbol2).getFirSymbol()).getClassKind() != ClassKind.ANNOTATION_CLASS) {
            return null;
        }
        return FirAnnotationHelpersKt.getAllowedAnnotationTargets((FirClassLikeSymbol)((KtFirNamedClassOrObjectSymbolBase)symbol2).getFirSymbol(), this.getAnalysisSession().getUseSiteSession$analysis_api_fir());
    }

    private final Name getJvmName(FirProperty property2, boolean isSetter) {
        Object object = property2.getBackingField();
        boolean bl = object != null && (object = ((FirBackingField)object).getSymbol()) != null ? FirAnnotationUtilsKt.hasAnnotation((FirBasedSymbol)object, JvmStandardClassIds.Annotations.INSTANCE.getJvmField(), this.getAnalysisSession().getUseSiteSession$analysis_api_fir()) : false;
        if (bl) {
            return property2.getName();
        }
        Name name2 = Name.identifier(this.getJvmNameAsString(property2, isSetter));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        return name2;
    }

    private final String getJvmNameAsString(FirProperty property2, boolean isSetter) {
        String jvmNameFromAccessor;
        FirPropertyAccessor accessor;
        AnnotationUseSiteTarget useSiteTarget2 = isSetter ? AnnotationUseSiteTarget.PROPERTY_SETTER : AnnotationUseSiteTarget.PROPERTY_GETTER;
        String jvmNameFromProperty = FirUtilsKt.getJvmNameFromAnnotation(property2, this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), useSiteTarget2);
        if (jvmNameFromProperty != null) {
            return jvmNameFromProperty;
        }
        FirPropertyAccessor firPropertyAccessor = accessor = isSetter ? property2.getSetter() : property2.getGetter();
        String string2 = jvmNameFromAccessor = firPropertyAccessor != null ? FirUtilsKt.getJvmNameFromAnnotation$default(firPropertyAccessor, this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), null, 2, null) : null;
        if (jvmNameFromAccessor != null) {
            return jvmNameFromAccessor;
        }
        String string3 = property2.getName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getIdentifier(...)");
        String identifier = string3;
        return isSetter ? JvmAbi.setterName(identifier) : JvmAbi.getterName(identifier);
    }
}

