/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.stubs;

import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.fileEditor.FileDocumentManager;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.PsiDocumentManager;
import ksp.com.intellij.psi.PsiFile;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

class IndexingStampInfo {
    final long indexingFileStamp;
    final long indexingByteLength;
    final int indexingCharLength;
    final boolean isBinary;

    IndexingStampInfo(long indexingFileStamp, long indexingByteLength, int indexingCharLength, boolean isBinary) {
        this.indexingFileStamp = indexingFileStamp;
        this.indexingByteLength = indexingByteLength;
        this.indexingCharLength = indexingCharLength;
        this.isBinary = isBinary;
    }

    public String toString() {
        return "indexing timestamp = " + this.indexingFileStamp + ", binary = " + this.isBinary + ", byte size = " + this.indexingByteLength + ", char size = " + this.indexingCharLength;
    }

    public boolean isUpToDate(@Nullable Document document2, @NotNull VirtualFile file2, @NotNull PsiFile psi2) {
        if (file2 == null) {
            IndexingStampInfo.$$$reportNull$$$0(0);
        }
        if (psi2 == null) {
            IndexingStampInfo.$$$reportNull$$$0(1);
        }
        if (document2 == null || FileDocumentManager.getInstance().isDocumentUnsaved(document2) || !PsiDocumentManager.getInstance(psi2.getProject()).isCommitted(document2)) {
            return false;
        }
        boolean isFileBinary = file2.getFileType().isBinary();
        return this.indexingFileStamp == file2.getTimeStamp() && this.isBinary == isFileBinary && this.contentLengthMatches(file2.getLength(), document2.getTextLength());
    }

    public boolean contentLengthMatches(long byteContentLength, int charContentLength) {
        if (this.indexingCharLength >= 0 && charContentLength >= 0) {
            return this.indexingCharLength == charContentLength;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "psi";
                break;
            }
        }
        objectArray[1] = "ksp/com/intellij/psi/stubs/IndexingStampInfo";
        objectArray[2] = "isUpToDate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

