/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.stub;

import ksp.com.intellij.psi.PsiJavaDocumentedElement;
import ksp.com.intellij.psi.PsiMember;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.impl.PsiImplUtil;
import ksp.com.intellij.psi.impl.java.stubs.PsiMemberStub;
import ksp.com.intellij.psi.impl.source.PsiFileImpl;
import ksp.com.intellij.psi.impl.source.PsiMethodImpl;
import ksp.com.intellij.psi.impl.source.StubbedSpine;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class JavaStubImplUtil {
    public static int getMethodStubIndex(PsiMethod method) {
        if (!(method instanceof PsiMethodImpl)) {
            return -1;
        }
        PsiFileImpl file2 = (PsiFileImpl)method.getContainingFile();
        StubbedSpine spine = file2.getStubbedSpine();
        int result2 = 0;
        for (int i = 0; i < spine.getStubCount(); ++i) {
            if (spine.getStubType(i) != JavaElementType.METHOD) continue;
            if (spine.getStubPsi(i) == method) {
                return result2;
            }
            ++result2;
        }
        return -1;
    }

    public static <T extends PsiMember & PsiJavaDocumentedElement> boolean isMemberDeprecated(@NotNull T member2, @Nullable PsiMemberStub<?> stub) {
        if (member2 == null) {
            JavaStubImplUtil.$$$reportNull$$$0(0);
        }
        if (stub != null) {
            return stub.isDeprecated() || stub.hasDeprecatedAnnotation() && PsiImplUtil.isDeprecatedByAnnotation(member2);
        }
        return PsiImplUtil.isDeprecatedByDocTag(member2) || PsiImplUtil.isDeprecatedByAnnotation(member2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "ksp/com/intellij/psi/stub/JavaStubImplUtil", "isMemberDeprecated"));
    }
}

