/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.tree;

import java.util.ArrayList;
import java.util.List;
import ksp.com.intellij.codeInsight.AnnotationTargetUtil;
import ksp.com.intellij.lang.ASTFactory;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiAnnotation;
import ksp.com.intellij.psi.PsiArrayType;
import ksp.com.intellij.psi.PsiComment;
import ksp.com.intellij.psi.PsiDisjunctionType;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiEllipsisType;
import ksp.com.intellij.psi.PsiExpression;
import ksp.com.intellij.psi.PsiIdentifier;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiModifierList;
import ksp.com.intellij.psi.PsiModifierListOwner;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypeElement;
import ksp.com.intellij.psi.PsiVariable;
import ksp.com.intellij.psi.PsiWhiteSpace;
import ksp.com.intellij.psi.TypeAnnotationProvider;
import ksp.com.intellij.psi.impl.GeneratedMarkerVisitor;
import ksp.com.intellij.psi.impl.PsiImplUtil;
import ksp.com.intellij.psi.impl.cache.TypeInfo;
import ksp.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import ksp.com.intellij.psi.impl.source.tree.CompositeElement;
import ksp.com.intellij.psi.impl.source.tree.Factory;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.com.intellij.psi.impl.source.tree.SharedImplUtil;
import ksp.com.intellij.psi.impl.source.tree.TreeElement;
import ksp.com.intellij.psi.impl.source.tree.java.AnnotationElement;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.util.CharTable;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.com.intellij.util.SmartList;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.com.intellij.util.containers.JBIterable;
import ksp.com.intellij.util.containers.MultiMap;
import ksp.com.intellij.util.containers.Stack;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class JavaSharedImplUtil {
    private static final Logger LOG = Logger.getInstance(JavaSharedImplUtil.class);
    private static final TokenSet BRACKETS = TokenSet.create(JavaTokenType.LBRACKET, JavaTokenType.RBRACKET);

    private JavaSharedImplUtil() {
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor2) {
        if (typeElement == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(0);
        }
        if (anchor2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(1);
        }
        return JavaSharedImplUtil.getType(typeElement, anchor2, null);
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor2, @Nullable PsiAnnotation stopAt) {
        if (typeElement == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(2);
        }
        if (anchor2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(3);
        }
        PsiType type2 = typeElement.getType();
        List<PsiAnnotation[]> allAnnotations = JavaSharedImplUtil.collectAnnotations(anchor2, stopAt);
        if (allAnnotations == null) {
            return null;
        }
        for (PsiAnnotation[] annotations2 : allAnnotations) {
            type2 = type2.createArrayType().annotate(TypeAnnotationProvider.Static.create(annotations2));
        }
        return type2;
    }

    @Nullable
    private static List<PsiAnnotation[]> collectAnnotations(@NotNull PsiElement anchor2, @Nullable PsiAnnotation stopAt) {
        if (anchor2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(4);
        }
        SmartList<PsiAnnotation[]> annotations2 = new SmartList<PsiAnnotation[]>();
        SmartList<PsiAnnotation> current = null;
        boolean found = stopAt == null;
        boolean stop = false;
        for (PsiElement child = anchor2.getNextSibling(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                if (current == null) {
                    current = new SmartList<PsiAnnotation>();
                }
                current.add((PsiAnnotation)child);
                if (child != stopAt) continue;
                stop = true;
                found = true;
                continue;
            }
            if (PsiUtil.isJavaToken(child, JavaTokenType.LBRACKET)) {
                annotations2.add(0, current == null ? PsiAnnotation.EMPTY_ARRAY : ContainerUtil.toArray(current, PsiAnnotation.ARRAY_FACTORY));
                current = null;
                if (!stop) continue;
                return annotations2;
            }
            if (!PsiUtil.isJavaToken(child, JavaTokenType.RBRACKET)) break;
        }
        return !found || stop ? null : annotations2;
    }

    @NotNull
    public static PsiType createTypeFromStub(@NotNull PsiModifierListOwner owner, @NotNull TypeInfo typeInfo) {
        if (owner == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(5);
        }
        if (typeInfo == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(6);
        }
        String typeText = TypeInfo.createTypeText(typeInfo);
        assert (typeText != null) : owner;
        PsiType type2 = JavaPsiFacade.getInstance(owner.getProject()).getParserFacade().createTypeFromText(typeText, owner);
        type2 = JavaSharedImplUtil.applyAnnotations(type2, owner.getModifierList());
        PsiType psiType2 = typeInfo.getTypeAnnotations().applyTo(type2, owner);
        if (psiType2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(7);
        }
        return psiType2;
    }

    @NotNull
    public static PsiType applyAnnotations(@NotNull PsiType type2, @Nullable PsiModifierList modifierList2) {
        PsiAnnotation[] annotations2;
        if (type2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(8);
        }
        if (modifierList2 != null && (annotations2 = modifierList2.getAnnotations()).length > 0) {
            if (type2 instanceof PsiArrayType) {
                Stack<PsiArrayType> types2 = new Stack<PsiArrayType>();
                do {
                    types2.push((PsiArrayType)type2);
                } while ((type2 = ((PsiArrayType)type2).getComponentType()) instanceof PsiArrayType);
                type2 = JavaSharedImplUtil.annotate(type2, modifierList2, annotations2);
                while (!types2.isEmpty()) {
                    PsiArrayType t = (PsiArrayType)types2.pop();
                    type2 = t instanceof PsiEllipsisType ? new PsiEllipsisType(type2, t.getAnnotations()) : new PsiArrayType(type2, t.getAnnotations());
                }
                PsiType psiType2 = type2;
                if (psiType2 == null) {
                    JavaSharedImplUtil.$$$reportNull$$$0(9);
                }
                return psiType2;
            }
            if (type2 instanceof PsiDisjunctionType) {
                ArrayList<PsiType> components2 = new ArrayList<PsiType>(((PsiDisjunctionType)type2).getDisjunctions());
                components2.set(0, JavaSharedImplUtil.annotate((PsiType)components2.get(0), modifierList2, annotations2));
                PsiDisjunctionType psiDisjunctionType = ((PsiDisjunctionType)type2).newDisjunctionType(components2);
                if (psiDisjunctionType == null) {
                    JavaSharedImplUtil.$$$reportNull$$$0(10);
                }
                return psiDisjunctionType;
            }
            return JavaSharedImplUtil.annotate(type2, modifierList2, annotations2);
        }
        PsiType psiType3 = type2;
        if (psiType3 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(11);
        }
        return psiType3;
    }

    @NotNull
    private static PsiType annotate(@NotNull PsiType type2, @NotNull PsiModifierList modifierList2, PsiAnnotation @NotNull [] annotations2) {
        if (type2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(12);
        }
        if (modifierList2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(13);
        }
        if (annotations2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(14);
        }
        TypeAnnotationProvider original = modifierList2.getParent() instanceof PsiMethod ? type2.getAnnotationProvider() : TypeAnnotationProvider.EMPTY;
        FilteringTypeAnnotationProvider provider2 = new FilteringTypeAnnotationProvider(annotations2, original);
        PsiType psiType2 = type2.annotate(provider2);
        if (psiType2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(15);
        }
        return psiType2;
    }

    public static void normalizeBrackets(@NotNull PsiVariable variable2) {
        if (variable2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(16);
        }
        CompositeElement variableElement = (CompositeElement)variable2.getNode();
        PsiTypeElement typeElement = variable2.getTypeElement();
        PsiIdentifier nameElement = variable2.getNameIdentifier();
        LOG.assertTrue(typeElement != null && nameElement != null);
        ASTNode type2 = typeElement.getNode();
        ASTNode name2 = nameElement.getNode();
        ASTNode firstBracket = null;
        ASTNode lastBracket = null;
        int arrayCount = 0;
        ASTNode element2 = name2;
        MultiMap<Integer, AnnotationElement> annotationElementsToMove = new MultiMap<Integer, AnnotationElement>();
        while (element2 != null) {
            if ((element2 = PsiImplUtil.skipWhitespaceAndComments(element2.getTreeNext())) instanceof AnnotationElement) {
                annotationElementsToMove.putValue(arrayCount, (AnnotationElement)element2);
                continue;
            }
            if (element2 == null || element2.getElementType() != JavaTokenType.LBRACKET) break;
            if (firstBracket == null) {
                firstBracket = element2;
            }
            lastBracket = element2;
            ++arrayCount;
            if ((element2 = PsiImplUtil.skipWhitespaceAndComments(element2.getTreeNext())) == null || element2.getElementType() != JavaTokenType.RBRACKET) break;
            lastBracket = element2;
        }
        if (firstBracket != null) {
            element2 = PsiImplUtil.skipWhitespaceAndComments(name2.getTreeNext());
            while (element2 != null) {
                ASTNode next = PsiImplUtil.skipWhitespaceAndComments(element2.getTreeNext());
                CodeEditUtil.removeChild(variableElement, element2);
                if (element2 == lastBracket) break;
                element2 = next;
            }
            CompositeElement newType = (CompositeElement)type2.clone();
            if (!(typeElement.getType() instanceof PsiArrayType)) {
                CompositeElement newType1 = ASTFactory.composite(JavaElementType.TYPE);
                newType1.rawAddChildren(newType);
                newType = newType1;
            }
            for (int i = 0; i < arrayCount; ++i) {
                annotationElementsToMove.get(i).forEach(newType::rawAddChildren);
                newType.rawAddChildren(ASTFactory.leaf(JavaTokenType.LBRACKET, "["));
                newType.rawAddChildren(ASTFactory.leaf(JavaTokenType.RBRACKET, "]"));
            }
            newType.acceptTree(new GeneratedMarkerVisitor());
            newType.putUserData(CharTable.CHAR_TABLE_KEY, SharedImplUtil.findCharTableByTree(type2));
            CodeEditUtil.replaceChild(variableElement, type2, newType);
        }
    }

    public static void setInitializer(@NotNull PsiVariable variable2, PsiExpression initializer2) throws IncorrectOperationException {
        PsiExpression oldInitializer;
        if (variable2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(17);
        }
        if ((oldInitializer = variable2.getInitializer()) != null) {
            oldInitializer.delete();
        }
        if (initializer2 == null) {
            return;
        }
        CompositeElement variableElement = (CompositeElement)variable2.getNode();
        ASTNode eq = variableElement.findChildByRole(20);
        if (eq == null) {
            CharTable charTable = SharedImplUtil.findCharTableByTree(variableElement);
            eq = Factory.createSingleLeafElement(JavaTokenType.EQ, "=", 0, 1, charTable, variable2.getManager());
            PsiIdentifier identifier = variable2.getNameIdentifier();
            assert (identifier != null) : variable2;
            ASTNode node = PsiImplUtil.skipWhitespaceCommentsAndTokens(identifier.getNode().getTreeNext(), BRACKETS);
            variableElement.addInternal((TreeElement)eq, eq, node, Boolean.TRUE);
            eq = variableElement.findChildByRole(20);
            assert (eq != null) : variable2;
        }
        variable2.addAfter(initializer2, eq.getPsi());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInfo";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/source/tree/JavaSharedImplUtil";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/source/tree/JavaSharedImplUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeFromStub";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "applyAnnotations";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectAnnotations";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTypeFromStub";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyAnnotations";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "normalizeBrackets";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setInitializer";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FilteringTypeAnnotationProvider
    implements TypeAnnotationProvider {
        private final PsiAnnotation[] myCandidates;
        private final TypeAnnotationProvider myOriginalProvider;
        private volatile PsiAnnotation[] myCache;

        private FilteringTypeAnnotationProvider(PsiAnnotation @NotNull [] candidates2, @NotNull TypeAnnotationProvider originalProvider) {
            if (originalProvider == null) {
                FilteringTypeAnnotationProvider.$$$reportNull$$$0(0);
            }
            if (candidates2 == null) {
                FilteringTypeAnnotationProvider.$$$reportNull$$$0(1);
            }
            this.myCandidates = candidates2;
            this.myOriginalProvider = originalProvider;
        }

        @Override
        public PsiAnnotation @NotNull [] getAnnotations() {
            PsiAnnotation[] result2 = this.myCache;
            if (result2 == null) {
                List<PsiAnnotation> filtered = JBIterable.of(this.myCandidates).filter(annotation2 -> !annotation2.isValid() || AnnotationTargetUtil.isTypeAnnotation(annotation2)).append((PsiAnnotation)this.myOriginalProvider.getAnnotations()).toList();
                result2 = filtered.isEmpty() ? PsiAnnotation.EMPTY_ARRAY : filtered.toArray(PsiAnnotation.EMPTY_ARRAY);
                this.myCache = result2;
            }
            if (result2 == null) {
                FilteringTypeAnnotationProvider.$$$reportNull$$$0(2);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalProvider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidates";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/psi/impl/source/tree/JavaSharedImplUtil$FilteringTypeAnnotationProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/psi/impl/source/tree/JavaSharedImplUtil$FilteringTypeAnnotationProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

