/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.smartPointers;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.openapi.editor.event.DocumentEvent;
import ksp.com.intellij.openapi.editor.impl.FrozenDocument;
import ksp.com.intellij.openapi.editor.impl.ManualRangeMarker;
import ksp.com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import ksp.com.intellij.openapi.util.ProperTextRange;
import ksp.com.intellij.openapi.util.Segment;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.openapi.util.UnfairTextRange;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.impl.smartPointers.Identikit;
import ksp.com.intellij.psi.impl.smartPointers.SelfElementInfo;
import ksp.com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

class MarkerCache {
    static final Comparator<SelfElementInfo> INFO_COMPARATOR = (info1, info2) -> {
        int o1 = info1.getPsiStartOffset();
        int o2 = info2.getPsiStartOffset();
        if (o1 < 0 || o2 < 0) {
            return o1 >= 0 ? -1 : (o2 >= 0 ? 1 : 0);
        }
        if (o1 != o2) {
            return o1 > o2 ? 1 : -1;
        }
        o1 = info1.getPsiEndOffset();
        if (o1 != (o2 = info2.getPsiEndOffset())) {
            return o1 > o2 ? 1 : -1;
        }
        return (info1.isGreedy() ? 1 : 0) - (info2.isGreedy() ? 1 : 0);
    };
    private final SmartPointerTracker myPointers;
    private UpdatedRanges myUpdatedRanges;

    MarkerCache(@NotNull SmartPointerTracker pointers) {
        if (pointers == null) {
            MarkerCache.$$$reportNull$$$0(0);
        }
        this.myPointers = pointers;
    }

    @NotNull
    private UpdatedRanges getUpdatedMarkers(@NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        UpdatedRanges answer;
        if (frozen == null) {
            MarkerCache.$$$reportNull$$$0(1);
        }
        if (events == null) {
            MarkerCache.$$$reportNull$$$0(2);
        }
        int eventCount = events.size();
        assert (eventCount > 0);
        UpdatedRanges cache2 = this.myUpdatedRanges;
        if (cache2 != null && cache2.myEventCount == eventCount) {
            UpdatedRanges updatedRanges = cache2;
            if (updatedRanges == null) {
                MarkerCache.$$$reportNull$$$0(3);
            }
            return updatedRanges;
        }
        if (cache2 != null && cache2.myEventCount < eventCount) {
            answer = MarkerCache.applyEvents(events.subList(cache2.myEventCount, eventCount), cache2);
        } else {
            List<SelfElementInfo> infos = this.myPointers.getSortedInfos();
            ManualRangeMarker[] markers2 = MarkerCache.createMarkers(infos);
            answer = MarkerCache.applyEvents(events, new UpdatedRanges(0, frozen, infos, markers2));
        }
        this.myUpdatedRanges = answer;
        UpdatedRanges updatedRanges = answer;
        if (updatedRanges == null) {
            MarkerCache.$$$reportNull$$$0(4);
        }
        return updatedRanges;
    }

    private static ManualRangeMarker @NotNull [] createMarkers(@NotNull List<? extends SelfElementInfo> infos) {
        if (infos == null) {
            MarkerCache.$$$reportNull$$$0(5);
        }
        ManualRangeMarker[] markers2 = new ManualRangeMarker[infos.size()];
        int i = 0;
        while (i < markers2.length) {
            SelfElementInfo info = infos.get(i);
            boolean greedy = info.isGreedy();
            int start = info.getPsiStartOffset();
            int end = info.getPsiEndOffset();
            markers2[i] = new ManualRangeMarker(start, end, greedy, greedy, !greedy, null);
            ++i;
            while (i < markers2.length && MarkerCache.rangeEquals(infos.get(i), start, end, greedy)) {
                markers2[i] = markers2[i - 1];
                ++i;
            }
        }
        if (markers2 == null) {
            MarkerCache.$$$reportNull$$$0(6);
        }
        return markers2;
    }

    private static boolean rangeEquals(@NotNull SelfElementInfo info, int start, int end, boolean greedy) {
        if (info == null) {
            MarkerCache.$$$reportNull$$$0(7);
        }
        return start == info.getPsiStartOffset() && end == info.getPsiEndOffset() && greedy == info.isGreedy();
    }

    @NotNull
    private static UpdatedRanges applyEvents(@NotNull List<? extends DocumentEvent> events, @NotNull UpdatedRanges struct) {
        if (events == null) {
            MarkerCache.$$$reportNull$$$0(8);
        }
        if (struct == null) {
            MarkerCache.$$$reportNull$$$0(9);
        }
        FrozenDocument frozen = struct.myResultDocument;
        ManualRangeMarker[] resultMarkers = (ManualRangeMarker[])struct.myMarkers.clone();
        for (DocumentEvent documentEvent : events) {
            FrozenDocument before = frozen;
            frozen = frozen.applyEvent(documentEvent, 0);
            DocumentEventImpl corrected = new DocumentEventImpl(frozen, documentEvent.getOffset(), documentEvent.getOldFragment(), documentEvent.getNewFragment(), documentEvent.getOldTimeStamp(), documentEvent.isWholeTextReplaced(), ((DocumentEventImpl)documentEvent).getInitialStartOffset(), ((DocumentEventImpl)documentEvent).getInitialOldLength(), documentEvent.getMoveOffset());
            int i = 0;
            while (i < resultMarkers.length) {
                ManualRangeMarker updatedRange;
                int sameMarkersEnd;
                ManualRangeMarker currentRange = resultMarkers[i];
                for (sameMarkersEnd = i + 1; sameMarkersEnd < resultMarkers.length && resultMarkers[sameMarkersEnd] == currentRange; ++sameMarkersEnd) {
                }
                ManualRangeMarker manualRangeMarker = updatedRange = currentRange == null ? null : currentRange.getUpdatedRange(corrected, before);
                while (i < sameMarkersEnd) {
                    resultMarkers[i] = updatedRange;
                    ++i;
                }
            }
        }
        return new UpdatedRanges(struct.myEventCount + events.size(), frozen, struct.mySortedInfos, resultMarkers);
    }

    boolean updateMarkers(@NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        if (frozen == null) {
            MarkerCache.$$$reportNull$$$0(10);
        }
        if (events == null) {
            MarkerCache.$$$reportNull$$$0(11);
        }
        UpdatedRanges updated = this.getUpdatedMarkers(frozen, events);
        boolean sorted = true;
        for (int i = 0; i < updated.myMarkers.length; ++i) {
            SelfElementInfo info = (SelfElementInfo)updated.mySortedInfos.get(i);
            info.setRange(updated.myMarkers[i]);
            if (!sorted || i <= 0 || INFO_COMPARATOR.compare((SelfElementInfo)updated.mySortedInfos.get(i - 1), info) <= 0) continue;
            sorted = false;
        }
        this.myUpdatedRanges = null;
        return sorted;
    }

    @Nullable
    TextRange getUpdatedRange(@NotNull SelfElementInfo info, @NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        UpdatedRanges struct;
        int i;
        if (info == null) {
            MarkerCache.$$$reportNull$$$0(12);
        }
        if (frozen == null) {
            MarkerCache.$$$reportNull$$$0(13);
        }
        if (events == null) {
            MarkerCache.$$$reportNull$$$0(14);
        }
        ManualRangeMarker updated = (i = Collections.binarySearch((struct = this.getUpdatedMarkers(frozen, events)).mySortedInfos, info, INFO_COMPARATOR)) >= 0 ? struct.myMarkers[i] : null;
        return updated == null ? null : new UnfairTextRange(updated.getStartOffset(), updated.getEndOffset());
    }

    @Nullable
    static Segment getUpdatedRange(@NotNull PsiFile containingFile2, @NotNull Segment segment, boolean isSegmentGreedy, @NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        if (containingFile2 == null) {
            MarkerCache.$$$reportNull$$$0(15);
        }
        if (segment == null) {
            MarkerCache.$$$reportNull$$$0(16);
        }
        if (frozen == null) {
            MarkerCache.$$$reportNull$$$0(17);
        }
        if (events == null) {
            MarkerCache.$$$reportNull$$$0(18);
        }
        SelfElementInfo info = new SelfElementInfo(ProperTextRange.create(segment), new Identikit(){

            @Override
            @Nullable
            public PsiElement findPsiElement(@NotNull PsiFile file2, int startOffset, int endOffset) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return null;
            }

            @Override
            @NotNull
            public Language getFileLanguage() {
                throw new IllegalStateException();
            }

            @Override
            public boolean isForPsiFile() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "ksp/com/intellij/psi/impl/smartPointers/MarkerCache$1", "findPsiElement"));
            }
        }, containingFile2, isSegmentGreedy);
        List<SelfElementInfo> infos = Collections.singletonList(info);
        boolean greedy = info.isGreedy();
        int start = info.getPsiStartOffset();
        int end = info.getPsiEndOffset();
        boolean surviveOnExternalChange = events.stream().anyMatch(event -> MarkerCache.isWholeDocumentReplace(frozen, (DocumentEventImpl)event));
        ManualRangeMarker marker = new ManualRangeMarker(start, end, greedy, greedy, surviveOnExternalChange, null);
        UpdatedRanges ranges = new UpdatedRanges(0, frozen, infos, new ManualRangeMarker[]{marker});
        List<DocumentEvent> newEvents = ContainerUtil.map(events, event -> MarkerCache.isWholeDocumentReplace(frozen, (DocumentEventImpl)event) ? new DocumentEventImpl(event.getDocument(), event.getOffset(), event.getOldFragment(), event.getNewFragment(), event.getOldTimeStamp(), true, ((DocumentEventImpl)event).getInitialStartOffset(), ((DocumentEventImpl)event).getInitialOldLength(), event.getMoveOffset()) : event);
        UpdatedRanges updated = MarkerCache.applyEvents(newEvents, ranges);
        return updated.myMarkers[0];
    }

    private static boolean isWholeDocumentReplace(@NotNull FrozenDocument frozen, @NotNull DocumentEventImpl event) {
        if (frozen == null) {
            MarkerCache.$$$reportNull$$$0(19);
        }
        if (event == null) {
            MarkerCache.$$$reportNull$$$0(20);
        }
        return event.getInitialStartOffset() == 0 && event.getInitialOldLength() == frozen.getTextLength();
    }

    void rangeChanged() {
        this.myUpdatedRanges = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frozen";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/smartPointers/MarkerCache";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "struct";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/smartPointers/MarkerCache";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatedMarkers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createMarkers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatedMarkers";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMarkers";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "rangeEquals";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyEvents";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateMarkers";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatedRange";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isWholeDocumentReplace";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UpdatedRanges {
        private final int myEventCount;
        private final FrozenDocument myResultDocument;
        private final List<SelfElementInfo> mySortedInfos;
        private final ManualRangeMarker[] myMarkers;

        UpdatedRanges(int eventCount, @NotNull FrozenDocument resultDocument, @NotNull List<SelfElementInfo> sortedInfos, ManualRangeMarker @NotNull [] markers2) {
            if (resultDocument == null) {
                UpdatedRanges.$$$reportNull$$$0(0);
            }
            if (sortedInfos == null) {
                UpdatedRanges.$$$reportNull$$$0(1);
            }
            if (markers2 == null) {
                UpdatedRanges.$$$reportNull$$$0(2);
            }
            this.myEventCount = eventCount;
            this.myResultDocument = resultDocument;
            this.mySortedInfos = sortedInfos;
            this.myMarkers = markers2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resultDocument";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sortedInfos";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "markers";
                    break;
                }
            }
            objectArray[1] = "ksp/com/intellij/psi/impl/smartPointers/MarkerCache$UpdatedRanges";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

