/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.compiled;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import ksp.com.intellij.psi.PsiNameHelper;
import ksp.com.intellij.psi.impl.cache.TypeAnnotationContainer;
import ksp.com.intellij.psi.impl.cache.TypeInfo;
import ksp.com.intellij.psi.impl.compiled.AnnotationTextCollector;
import ksp.com.intellij.psi.impl.compiled.FirstPassData;
import ksp.com.intellij.util.ArrayUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import ksp.org.jetbrains.org.objectweb.asm.TypePath;

class ClsTypeAnnotationCollector
extends TypeAnnotationContainer.Collector {
    @NotNull
    private final FirstPassData myFirstPassData;

    ClsTypeAnnotationCollector(@NotNull TypeInfo info, @NotNull FirstPassData classInfo) {
        if (info == null) {
            ClsTypeAnnotationCollector.$$$reportNull$$$0(0);
        }
        if (classInfo == null) {
            ClsTypeAnnotationCollector.$$$reportNull$$$0(1);
        }
        super(info);
        this.myFirstPassData = classInfo;
    }

    void add(TypePath path, String text) {
        byte[] translated = this.translatePath(path);
        if (translated != null) {
            this.add(translated, text);
        }
    }

    AnnotationVisitor collect(@Nullable TypePath path, @Nullable String desc) {
        return new AnnotationTextCollector(desc, this.myFirstPassData, text -> this.add(path, (String)text));
    }

    private byte[] translatePath(@Nullable TypePath path) {
        String typeText = this.myTypeInfo.text;
        int arrayLevel = this.myTypeInfo.arrayCount + (this.myTypeInfo.isEllipsis ? (byte)1 : 0);
        String qualifiedName2 = PsiNameHelper.getQualifiedClassName(typeText, false);
        int depth = this.myFirstPassData.getInnerDepth(qualifiedName2);
        boolean atWildcard = false;
        if (path == null) {
            if (depth == 0 || arrayLevel > 0) {
                return ArrayUtil.EMPTY_BYTE_ARRAY;
            }
            byte[] result2 = new byte[depth];
            Arrays.fill(result2, (byte)1);
            return result2;
        }
        ByteArrayOutputStream result3 = new ByteArrayOutputStream();
        int length = path.getLength();
        block6: for (int i = 0; i < length; ++i) {
            byte step = (byte)path.getStep(i);
            switch (step) {
                case 1: {
                    if (depth == 0) {
                        return null;
                    }
                    --depth;
                    continue block6;
                }
                case 0: {
                    if (arrayLevel <= 0 || atWildcard) {
                        return null;
                    }
                    --arrayLevel;
                    result3.write(0);
                    continue block6;
                }
                case 2: {
                    if (!atWildcard) {
                        return null;
                    }
                    atWildcard = false;
                    result3.write(2);
                    continue block6;
                }
                case 3: {
                    String[] arguments2;
                    if (atWildcard || arrayLevel > 0) {
                        return null;
                    }
                    while (depth-- > 0) {
                        result3.write(1);
                        typeText = PsiNameHelper.getOuterClassReference(typeText);
                    }
                    int argumentIndex = path.getStepArgument(i);
                    if (argumentIndex >= (arguments2 = PsiNameHelper.getClassParametersText(typeText)).length) {
                        return null;
                    }
                    TypeInfo argument2 = TypeInfo.fromString(arguments2[argumentIndex], false);
                    arrayLevel = argument2.arrayCount;
                    typeText = argument2.text;
                    if (typeText.startsWith("? extends ")) {
                        typeText = typeText.substring("? extends ".length());
                        atWildcard = true;
                    } else if (typeText.startsWith("? super ")) {
                        typeText = typeText.substring("? super ".length());
                        atWildcard = true;
                    }
                    qualifiedName2 = PsiNameHelper.getQualifiedClassName(typeText, false);
                    depth = this.myFirstPassData.getInnerDepth(qualifiedName2);
                    result3.write(3);
                    result3.write(argumentIndex);
                }
            }
        }
        if (!atWildcard && arrayLevel == 0) {
            while (depth-- > 0) {
                result3.write(1);
            }
        }
        return result3.toByteArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "classInfo";
                break;
            }
        }
        objectArray[1] = "ksp/com/intellij/psi/impl/compiled/ClsTypeAnnotationCollector";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

