/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtLightSourceElement;
import ksp.org.jetbrains.kotlin.KtPsiSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.AbstractKtDiagnosticFactory;
import ksp.org.jetbrains.kotlin.diagnostics.AbstractSourceElementPositioningStrategy;
import ksp.org.jetbrains.kotlin.diagnostics.InternalDiagnosticFactoryMethod;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticRenderer;
import ksp.org.jetbrains.kotlin.diagnostics.KtLightSimpleDiagnostic;
import ksp.org.jetbrains.kotlin.diagnostics.KtOffsetsOnlySimpleDiagnostic;
import ksp.org.jetbrains.kotlin.diagnostics.KtPsiSimpleDiagnostic;
import ksp.org.jetbrains.kotlin.diagnostics.KtSimpleDiagnostic;
import ksp.org.jetbrains.kotlin.diagnostics.Severity;
import ksp.org.jetbrains.kotlin.diagnostics.SimpleKtDiagnosticRenderer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0007R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "Lksp/org/jetbrains/kotlin/diagnostics/AbstractKtDiagnosticFactory;", "name", "", "severity", "Lksp/org/jetbrains/kotlin/diagnostics/Severity;", "defaultPositioningStrategy", "Lksp/org/jetbrains/kotlin/diagnostics/AbstractSourceElementPositioningStrategy;", "psiType", "Lkotlin/reflect/KClass;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;Lorg/jetbrains/kotlin/diagnostics/AbstractSourceElementPositioningStrategy;Lkotlin/reflect/KClass;)V", "ktRenderer", "Lksp/org/jetbrains/kotlin/diagnostics/KtDiagnosticRenderer;", "getKtRenderer", "()Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticRenderer;", "on", "Lksp/org/jetbrains/kotlin/diagnostics/KtSimpleDiagnostic;", "element", "Lksp/org/jetbrains/kotlin/AbstractKtSourceElement;", "positioningStrategy", "frontend.common"})
public final class KtDiagnosticFactory0
extends AbstractKtDiagnosticFactory {
    @NotNull
    private final KtDiagnosticRenderer ktRenderer;

    public KtDiagnosticFactory0(@NotNull String name2, @NotNull Severity severity, @NotNull AbstractSourceElementPositioningStrategy defaultPositioningStrategy, @NotNull KClass<?> psiType2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter((Object)defaultPositioningStrategy, (String)"defaultPositioningStrategy");
        Intrinsics.checkNotNullParameter(psiType2, (String)"psiType");
        super(name2, severity, defaultPositioningStrategy, psiType2, null);
        this.ktRenderer = new SimpleKtDiagnosticRenderer("");
    }

    @Override
    @NotNull
    public KtDiagnosticRenderer getKtRenderer() {
        return this.ktRenderer;
    }

    @InternalDiagnosticFactoryMethod
    @NotNull
    public final KtSimpleDiagnostic on(@NotNull AbstractKtSourceElement element2, @Nullable AbstractSourceElementPositioningStrategy positioningStrategy) {
        KtSimpleDiagnostic ktSimpleDiagnostic;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        AbstractKtSourceElement abstractKtSourceElement = element2;
        if (abstractKtSourceElement instanceof KtPsiSourceElement) {
            KtPsiSourceElement ktPsiSourceElement = (KtPsiSourceElement)element2;
            Severity severity = this.getSeverity();
            AbstractSourceElementPositioningStrategy abstractSourceElementPositioningStrategy = positioningStrategy;
            if (abstractSourceElementPositioningStrategy == null) {
                abstractSourceElementPositioningStrategy = this.getDefaultPositioningStrategy();
            }
            ktSimpleDiagnostic = new KtPsiSimpleDiagnostic(ktPsiSourceElement, severity, this, abstractSourceElementPositioningStrategy);
        } else if (abstractKtSourceElement instanceof KtLightSourceElement) {
            KtLightSourceElement ktLightSourceElement = (KtLightSourceElement)element2;
            Severity severity = this.getSeverity();
            AbstractSourceElementPositioningStrategy abstractSourceElementPositioningStrategy = positioningStrategy;
            if (abstractSourceElementPositioningStrategy == null) {
                abstractSourceElementPositioningStrategy = this.getDefaultPositioningStrategy();
            }
            ktSimpleDiagnostic = new KtLightSimpleDiagnostic(ktLightSourceElement, severity, this, abstractSourceElementPositioningStrategy);
        } else {
            Severity severity = this.getSeverity();
            AbstractSourceElementPositioningStrategy abstractSourceElementPositioningStrategy = positioningStrategy;
            if (abstractSourceElementPositioningStrategy == null) {
                abstractSourceElementPositioningStrategy = this.getDefaultPositioningStrategy();
            }
            ktSimpleDiagnostic = new KtOffsetsOnlySimpleDiagnostic(element2, severity, this, abstractSourceElementPositioningStrategy);
        }
        return ktSimpleDiagnostic;
    }
}

