/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.lazy.resolve;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.lazy.resolve.FirLazyAnnotationTransformerData;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.lazy.resolve.FirLazyAnnotationTransformerScope;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.lazy.resolve.FirLazyBodiesCalculator;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationsPlatformSpecificSupportComponentKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import ksp.org.jetbrains.kotlin.fir.expressions.FirBlock;
import ksp.org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirErrorAnnotationCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirLazyBlock;
import ksp.org.jetbrains.kotlin.fir.expressions.FirLazyExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirLazyDelegatedConstructorCall;
import ksp.org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotationsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.CustomAnnotationTypeAttributeKt;
import ksp.org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirQualifierPart;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import ksp.org.jetbrains.kotlin.fir.visitors.FirTransformer;
import ksp.org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\"\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0002H\u0016J'\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u0002H\u00142\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0018\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0018\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a8\u0006'"}, d2={"Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/lazy/resolve/FirLazyAnnotationTransformer;", "Lksp/org/jetbrains/kotlin/fir/visitors/FirTransformer;", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/lazy/resolve/FirLazyAnnotationTransformerData;", "()V", "canBeCompilerAnnotation", "", "annotationCall", "Lksp/org/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "transformAnnotationCall", "Lksp/org/jetbrains/kotlin/fir/expressions/FirStatement;", "data", "transformBlock", "block", "Lksp/org/jetbrains/kotlin/fir/expressions/FirBlock;", "transformDelegatedConstructorCall", "delegatedConstructorCall", "Lksp/org/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "transformElement", "E", "Lksp/org/jetbrains/kotlin/fir/FirElement;", "element", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/lazy/resolve/FirLazyAnnotationTransformerData;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformErrorAnnotationCall", "errorAnnotationCall", "Lksp/org/jetbrains/kotlin/fir/expressions/FirErrorAnnotationCall;", "transformErrorTypeRef", "Lksp/org/jetbrains/kotlin/fir/types/FirTypeRef;", "errorTypeRef", "Lksp/org/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "transformExpression", "expression", "Lksp/org/jetbrains/kotlin/fir/expressions/FirExpression;", "transformResolvedTypeRef", "resolvedTypeRef", "Lksp/org/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "visitTypeAnnotations", "", "low-level-api-fir"})
abstract class FirLazyAnnotationTransformer
extends FirTransformer<FirLazyAnnotationTransformerData> {
    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element2, @NotNull FirLazyAnnotationTransformerData data2) {
        Intrinsics.checkNotNullParameter(element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        element2.transformChildren(this, (FirLazyAnnotationTransformerData)data2);
        return element2;
    }

    private final boolean canBeCompilerAnnotation(FirAnnotationCall annotationCall, FirSession session2) {
        FirTypeRef annotationTypeRef = annotationCall.getAnnotationTypeRef();
        if (!(annotationTypeRef instanceof FirUserTypeRef)) {
            return false;
        }
        if (!((Collection)FirRegisteredPluginAnnotationsKt.getRegisteredPluginAnnotations(session2).getAnnotations()).isEmpty()) {
            return true;
        }
        Name name2 = ((FirQualifierPart)CollectionsKt.last(((FirUserTypeRef)annotationTypeRef).getQualifier())).getName();
        return FirAnnotationsPlatformSpecificSupportComponentKt.getAnnotationPlatformSupport(session2).getRequiredAnnotationsShortClassNames().contains(name2);
    }

    @Override
    @NotNull
    public FirTypeRef transformErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef, @NotNull FirLazyAnnotationTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)errorTypeRef, (String)"errorTypeRef");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.visitTypeAnnotations(errorTypeRef, data2);
        return super.transformErrorTypeRef(errorTypeRef, data2);
    }

    @Override
    @NotNull
    public FirTypeRef transformResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @NotNull FirLazyAnnotationTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)resolvedTypeRef, (String)"resolvedTypeRef");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.visitTypeAnnotations(resolvedTypeRef, data2);
        return super.transformResolvedTypeRef(resolvedTypeRef, data2);
    }

    private final void visitTypeAnnotations(FirResolvedTypeRef resolvedTypeRef, FirLazyAnnotationTransformerData data2) {
        ConeTypeUtilsKt.forEachType(FirTypeUtilsKt.getConeType(resolvedTypeRef), (Function1<? super ConeKotlinType, Unit>)((Function1)new Function1<ConeKotlinType, Unit>(this, data2){
            final /* synthetic */ FirLazyAnnotationTransformer this$0;
            final /* synthetic */ FirLazyAnnotationTransformerData $data;
            {
                this.this$0 = $receiver;
                this.$data = $data;
                super(1);
            }

            public final void invoke(ConeKotlinType coneType) {
                Intrinsics.checkNotNullParameter((Object)coneType, (String)"coneType");
                for (FirAnnotation typeArgumentAnnotation : CustomAnnotationTypeAttributeKt.getCustomAnnotations(coneType)) {
                    typeArgumentAnnotation.accept(this.this$0, this.$data);
                }
            }
        }));
    }

    @Override
    @NotNull
    public FirStatement transformAnnotationCall(@NotNull FirAnnotationCall annotationCall, @NotNull FirLazyAnnotationTransformerData data2) {
        boolean shouldCalculate;
        Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        boolean bl = shouldCalculate = data2.getCompilerAnnotationsOnly() == FirLazyAnnotationTransformerScope.ALL_ANNOTATIONS || this.canBeCompilerAnnotation(annotationCall, data2.getSession());
        if (shouldCalculate && FirLazyBodiesCalculator.INSTANCE.needCalculatingAnnotationCall(annotationCall)) {
            FirArgumentList newArgumentList = FirLazyBodiesCalculator.INSTANCE.calculateLazyArgumentsForAnnotation(annotationCall, data2.getSession());
            annotationCall.replaceArgumentList(newArgumentList);
        }
        super.transformAnnotationCall(annotationCall, data2);
        return annotationCall;
    }

    @Override
    @NotNull
    public FirStatement transformErrorAnnotationCall(@NotNull FirErrorAnnotationCall errorAnnotationCall, @NotNull FirLazyAnnotationTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)errorAnnotationCall, (String)"errorAnnotationCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.transformAnnotationCall((FirAnnotationCall)errorAnnotationCall, data2);
        return errorAnnotationCall;
    }

    @Override
    @NotNull
    public FirStatement transformExpression(@NotNull FirExpression expression2, @NotNull FirLazyAnnotationTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (expression2 instanceof FirLazyExpression) {
            return expression2;
        }
        return super.transformExpression(expression2, data2);
    }

    @Override
    @NotNull
    public FirStatement transformBlock(@NotNull FirBlock block, @NotNull FirLazyAnnotationTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (block instanceof FirLazyBlock) {
            return block;
        }
        return super.transformBlock(block, data2);
    }

    @Override
    @NotNull
    public FirStatement transformDelegatedConstructorCall(@NotNull FirDelegatedConstructorCall delegatedConstructorCall, @NotNull FirLazyAnnotationTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)delegatedConstructorCall, (String)"delegatedConstructorCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (delegatedConstructorCall instanceof FirLazyDelegatedConstructorCall) {
            return delegatedConstructorCall;
        }
        return super.transformDelegatedConstructorCall(delegatedConstructorCall, data2);
    }
}

