/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.psi.Call;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import ksp.org.jetbrains.kotlin.resolve.sam.SamConstructorDescriptor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/checkers/SamInterfaceConstructorReferenceCallChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
public final class SamInterfaceConstructorReferenceCallChecker
implements CallChecker {
    @NotNull
    public static final SamInterfaceConstructorReferenceCallChecker INSTANCE = new SamInterfaceConstructorReferenceCallChecker();

    private SamInterfaceConstructorReferenceCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Object resultingDescriptor;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
                Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Object obj = resolvedCall2.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue(obj, (String)"getResultingDescriptor(...)");
                resultingDescriptor = obj;
                if (!(resultingDescriptor instanceof SamConstructorDescriptor)) break block4;
                Call call2 = resolvedCall2.getCall();
                Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"getCall(...)");
                if (CallUtilKt.isCallableReference(call2)) break block5;
            }
            return;
        }
        if (!((ClassDescriptor)((SamConstructorDescriptor)resultingDescriptor).getBaseDescriptorForSynthetic()).isFun()) {
            context2.getTrace().report(ErrorsJvm.JAVA_SAM_INTERFACE_CONSTRUCTOR_REFERENCE.on(reportOn));
        }
    }
}

