/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.backend.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import ksp.org.jetbrains.kotlin.fir.backend.generators.FirBasedFakeOverrideGenerator;
import ksp.org.jetbrains.kotlin.fir.backend.utils.ScopeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import ksp.org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import ksp.org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0001\u001a\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0001\u001a\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0001\u001a\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0011"}, d2={"generateOverriddenAccessorSymbols", "", "Lksp/org/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "containingClass", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "isGetter", "", "c", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "generateOverriddenPropertySymbols", "Lksp/org/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "generateOverriddenFunctionSymbols", "Lksp/org/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "getSuperTypesAsIrClasses", "", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFakeOverrideGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FakeOverrideGenerator.kt\norg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGeneratorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,750:1\n1611#2,9:751\n1863#2:760\n1864#2:762\n1620#2:763\n1#3:761\n1#3:764\n*S KotlinDebug\n*F\n+ 1 FakeOverrideGenerator.kt\norg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGeneratorKt\n*L\n748#1:751,9\n748#1:760\n748#1:762\n748#1:763\n748#1:761\n*E\n"})
public final class FakeOverrideGeneratorKt {
    @FirBasedFakeOverrideGenerator
    @NotNull
    public static final List<IrSimpleFunctionSymbol> generateOverriddenAccessorSymbols(@NotNull FirProperty $this$generateOverriddenAccessorSymbols, @NotNull FirClass containingClass, boolean isGetter, @NotNull Fir2IrComponents c) {
        Intrinsics.checkNotNullParameter((Object)$this$generateOverriddenAccessorSymbols, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        FirTypeScope scope = ScopeUtilsKt.unsubstitutedScope(containingClass, c);
        scope.processPropertiesByName($this$generateOverriddenAccessorSymbols.getName(), FakeOverrideGeneratorKt::generateOverriddenAccessorSymbols$lambda$0);
        Set overriddenSet = new LinkedHashSet();
        Set<IrClass> superClasses = FakeOverrideGeneratorKt.getSuperTypesAsIrClasses(containingClass, c);
        ScopeUtilsKt.processOverriddenPropertiesFromSuperClasses(scope, $this$generateOverriddenAccessorSymbols.getSymbol(), containingClass, (Function1<? super FirPropertySymbol, ? extends ProcessorAction>)((Function1)arg_0 -> FakeOverrideGeneratorKt.generateOverriddenAccessorSymbols$lambda$2(c, $this$generateOverriddenAccessorSymbols, superClasses, isGetter, overriddenSet, arg_0)));
        return CollectionsKt.toList((Iterable)overriddenSet);
    }

    @FirBasedFakeOverrideGenerator
    @NotNull
    public static final List<IrPropertySymbol> generateOverriddenPropertySymbols(@NotNull FirProperty $this$generateOverriddenPropertySymbols, @NotNull FirClass containingClass, @NotNull Fir2IrComponents c) {
        Intrinsics.checkNotNullParameter((Object)$this$generateOverriddenPropertySymbols, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Set<IrClass> superClasses = FakeOverrideGeneratorKt.getSuperTypesAsIrClasses(containingClass, c);
        Set overriddenSet = new LinkedHashSet();
        ScopeUtilsKt.processOverriddenPropertySymbols($this$generateOverriddenPropertySymbols, containingClass, c, (Function1<? super FirPropertySymbol, Unit>)((Function1)arg_0 -> FakeOverrideGeneratorKt.generateOverriddenPropertySymbols$lambda$4(c, superClasses, $this$generateOverriddenPropertySymbols, overriddenSet, arg_0)));
        return CollectionsKt.toList((Iterable)overriddenSet);
    }

    @FirBasedFakeOverrideGenerator
    @NotNull
    public static final List<IrSimpleFunctionSymbol> generateOverriddenFunctionSymbols(@NotNull FirSimpleFunction $this$generateOverriddenFunctionSymbols, @NotNull FirClass containingClass, @NotNull Fir2IrComponents c) {
        Intrinsics.checkNotNullParameter((Object)$this$generateOverriddenFunctionSymbols, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Set<IrClass> superClasses = FakeOverrideGeneratorKt.getSuperTypesAsIrClasses(containingClass, c);
        Set overriddenSet = new LinkedHashSet();
        ScopeUtilsKt.processOverriddenFunctionSymbols($this$generateOverriddenFunctionSymbols, containingClass, c, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)arg_0 -> FakeOverrideGeneratorKt.generateOverriddenFunctionSymbols$lambda$6(c, superClasses, $this$generateOverriddenFunctionSymbols, overriddenSet, arg_0)));
        return CollectionsKt.toList((Iterable)overriddenSet);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<IrClass> getSuperTypesAsIrClasses(FirClass $this$getSuperTypesAsIrClasses, Fir2IrComponents c) {
        void $this$mapNotNullTo$iv$iv;
        IrClass irClass = (IrClass)c.getDeclarationStorage().getClassifierStorage().getIrClassSymbol($this$getSuperTypesAsIrClasses.getSymbol()).getOwner();
        Iterable $this$mapNotNull$iv = irClass.getSuperTypes();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrClass it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrType it = (IrType)element$iv$iv;
            boolean bl2 = false;
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(it);
            IrSymbolOwner irSymbolOwner = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
            if ((irSymbolOwner instanceof IrClass ? (IrClass)irSymbolOwner : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final Unit generateOverriddenAccessorSymbols$lambda$0(FirVariableSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final ProcessorAction generateOverriddenAccessorSymbols$lambda$2(Fir2IrComponents $c, FirProperty $this_generateOverriddenAccessorSymbols, Set $superClasses, boolean $isGetter, Set $overriddenSet, FirPropertySymbol overriddenSymbol) {
        Intrinsics.checkNotNullParameter((Object)overriddenSymbol, (String)"overriddenSymbol");
        if (!FirVisibilityCheckerKt.getVisibilityChecker($c.getSession()).isVisibleForOverriding((FirCallableDeclaration)$this_generateOverriddenAccessorSymbols.getSymbol().getFir(), (FirCallableDeclaration)overriddenSymbol.getFir())) {
            return ProcessorAction.NEXT;
        }
        for (IrPropertySymbol overriddenIrPropertySymbol : $c.getFakeOverrideGenerator().getOverriddenSymbolsInSupertypes$fir2ir(overriddenSymbol, (Set<? extends IrClass>)$superClasses)) {
            boolean bl;
            IrSimpleFunctionSymbol overriddenIrAccessorSymbol = $isGetter ? $c.getDeclarationStorage().findGetterOfProperty(overriddenIrPropertySymbol) : $c.getDeclarationStorage().findSetterOfProperty(overriddenIrPropertySymbol);
            if (overriddenIrAccessorSymbol == null) continue;
            boolean bl2 = bl = !Intrinsics.areEqual((Object)overriddenIrAccessorSymbol, (Object)$this_generateOverriddenAccessorSymbols.getSymbol());
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Cannot add property " + overriddenIrAccessorSymbol + " to its own overriddenSymbols";
                throw new AssertionError((Object)string2);
            }
            ((Collection)$overriddenSet).add(overriddenIrAccessorSymbol);
        }
        return ProcessorAction.NEXT;
    }

    private static final Unit generateOverriddenPropertySymbols$lambda$4(Fir2IrComponents $c, Set $superClasses, FirProperty $this_generateOverriddenPropertySymbols, Set $overriddenSet, FirPropertySymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        for (IrPropertySymbol overridden : $c.getFakeOverrideGenerator().getOverriddenSymbolsInSupertypes$fir2ir(it, (Set<? extends IrClass>)$superClasses)) {
            boolean bl;
            boolean bl2 = bl = !Intrinsics.areEqual((Object)overridden, (Object)$this_generateOverriddenPropertySymbols.getSymbol());
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Cannot add property " + overridden + " to its own overriddenSymbols";
                throw new AssertionError((Object)string2);
            }
            ((Collection)$overriddenSet).add(overridden);
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateOverriddenFunctionSymbols$lambda$6(Fir2IrComponents $c, Set $superClasses, FirSimpleFunction $this_generateOverriddenFunctionSymbols, Set $overriddenSet, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        for (IrSimpleFunctionSymbol overridden : $c.getFakeOverrideGenerator().getOverriddenSymbolsInSupertypes$fir2ir(it, (Set<? extends IrClass>)$superClasses)) {
            boolean bl;
            boolean bl2 = bl = !Intrinsics.areEqual((Object)overridden, (Object)$this_generateOverriddenFunctionSymbols.getSymbol());
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Cannot add function " + overridden + " to its own overriddenSymbols";
                throw new AssertionError((Object)string2);
            }
            ((Collection)$overriddenSet).add(overridden);
        }
        return Unit.INSTANCE;
    }
}

