/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.collectors.components;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.collectors.components.AbstractDiagnosticCollectorComponent;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirErrorPrimaryConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirErrorProperty;
import ksp.org.jetbrains.kotlin.fir.diagnostics.ConeAmbiguousSuper;
import ksp.org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import ksp.org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import ksp.org.jetbrains.kotlin.fir.diagnostics.ConeSyntaxDiagnostic;
import ksp.org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import ksp.org.jetbrains.kotlin.fir.expressions.FirErrorAnnotationCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirErrorLoop;
import ksp.org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import ksp.org.jetbrains.kotlin.fir.references.FirNamedReference;
import ksp.org.jetbrains.kotlin.fir.references.FirResolvedErrorReference;
import ksp.org.jetbrains.kotlin.fir.references.FirThisReference;
import ksp.org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import ksp.org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import ksp.org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableWrongReceiver;
import ksp.org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInstanceAccessBeforeSuperCall;
import ksp.org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import ksp.org.jetbrains.kotlin.fir.types.ConeErrorType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\rH\u0002J\u000e\u0010#\u001a\u00020$*\u0004\u0018\u00010%H\u0002J\u0018\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020(2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020+2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020.2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u0002012\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u00102\u001a\u00020\t2\u0006\u00103\u001a\u0002042\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u00105\u001a\u00020\t2\u0006\u00106\u001a\u0002072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020:2\u0006\u0010\f\u001a\u00020\rH\u0016J.\u0010;\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\b\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010\"\u001a\u00020\r2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010=H\u0002\u00a8\u0006?"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/collectors/components/ErrorNodeDiagnosticCollectorComponent;", "Lksp/org/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "visitErrorLoop", "", "errorLoop", "Lksp/org/jetbrains/kotlin/fir/expressions/FirErrorLoop;", "data", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "visitErrorTypeRef", "errorTypeRef", "Lksp/org/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "visitResolvedTypeRef", "resolvedTypeRef", "Lksp/org/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "visitErrorAnnotationCall", "errorAnnotationCall", "Lksp/org/jetbrains/kotlin/fir/expressions/FirErrorAnnotationCall;", "visitErrorNamedReference", "errorNamedReference", "Lksp/org/jetbrains/kotlin/fir/references/FirErrorNamedReference;", "visitResolvedErrorReference", "resolvedErrorReference", "Lksp/org/jetbrains/kotlin/fir/references/FirResolvedErrorReference;", "processErrorReference", "reference", "Lksp/org/jetbrains/kotlin/fir/references/FirNamedReference;", "diagnostic", "Lksp/org/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "context", "cannotBeResolved", "", "Lksp/org/jetbrains/kotlin/fir/expressions/FirExpression;", "visitErrorExpression", "errorExpression", "Lksp/org/jetbrains/kotlin/fir/expressions/FirErrorExpression;", "visitErrorFunction", "errorFunction", "Lksp/org/jetbrains/kotlin/fir/declarations/FirErrorFunction;", "visitErrorProperty", "errorProperty", "Lksp/org/jetbrains/kotlin/fir/declarations/FirErrorProperty;", "visitErrorResolvedQualifier", "errorResolvedQualifier", "Lksp/org/jetbrains/kotlin/fir/expressions/FirErrorResolvedQualifier;", "visitErrorPrimaryConstructor", "errorPrimaryConstructor", "Lksp/org/jetbrains/kotlin/fir/declarations/FirErrorPrimaryConstructor;", "visitThisReference", "thisReference", "Lksp/org/jetbrains/kotlin/fir/references/FirThisReference;", "visitVarargArgumentsExpression", "varargArgumentsExpression", "Lksp/org/jetbrains/kotlin/fir/expressions/FirVarargArgumentsExpression;", "reportFirDiagnostic", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "callOrAssignmentSource", "checkers"})
public final class ErrorNodeDiagnosticCollectorComponent
extends AbstractDiagnosticCollectorComponent {
    public ErrorNodeDiagnosticCollectorComponent(@NotNull FirSession session, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        super(session, reporter);
    }

    @Override
    public void visitErrorLoop(@NotNull FirErrorLoop errorLoop, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorLoop, (String)"errorLoop");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KtSourceElement source = errorLoop.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorLoop.getDiagnostic(), source, data, null, 8, null);
    }

    @Override
    public void visitErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorTypeRef, (String)"errorTypeRef");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KtSourceElement source = errorTypeRef.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorTypeRef.getDiagnostic(), source, data, null, 8, null);
    }

    @Override
    public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @NotNull CheckerContext data) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)resolvedTypeRef, (String)"resolvedTypeRef");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        boolean bl2 = bl = !(resolvedTypeRef.getType() instanceof ConeErrorType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Instead use FirErrorTypeRef for " + ConeTypeUtilsKt.renderForDebugging(resolvedTypeRef.getType());
            throw new AssertionError((Object)string2);
        }
    }

    @Override
    public void visitErrorAnnotationCall(@NotNull FirErrorAnnotationCall errorAnnotationCall, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorAnnotationCall, (String)"errorAnnotationCall");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KtSourceElement source = errorAnnotationCall.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorAnnotationCall.getDiagnostic(), source, data, null, 8, null);
    }

    @Override
    public void visitErrorNamedReference(@NotNull FirErrorNamedReference errorNamedReference, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorNamedReference, (String)"errorNamedReference");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.processErrorReference(errorNamedReference, errorNamedReference.getDiagnostic(), data);
    }

    @Override
    public void visitResolvedErrorReference(@NotNull FirResolvedErrorReference resolvedErrorReference, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)resolvedErrorReference, (String)"resolvedErrorReference");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.processErrorReference(resolvedErrorReference, resolvedErrorReference.getDiagnostic(), data);
    }

    private final void processErrorReference(FirNamedReference reference2, ConeDiagnostic diagnostic, CheckerContext context2) {
        FirStatement firStatement;
        KtSourceElement source = reference2.getSource();
        FirStatement firStatement2 = (FirStatement)CollectionsKt.lastOrNull(context2.getCallsOrAssignments());
        if (firStatement2 != null) {
            FirStatement firStatement3;
            FirStatement it = firStatement3 = firStatement2;
            boolean bl = false;
            firStatement = Intrinsics.areEqual((Object)ReferenceUtilsKt.toReference(it, this.getSession()), (Object)reference2) ? firStatement3 : null;
        } else {
            firStatement = null;
        }
        FirStatement callOrAssignment = firStatement;
        KtSourceElement ktSourceElement = source;
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getElementType() : null), (Object)KtNodeTypes.ANNOTATION_ENTRY) && diagnostic instanceof ConeUnresolvedNameError) {
            return;
        }
        KtSourceElement ktSourceElement2 = source;
        if (Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtFakeSourceElementKind.ArrayAccessNameReference.INSTANCE) && diagnostic instanceof ConeUnresolvedNameError) {
            return;
        }
        if (callOrAssignment instanceof FirQualifiedAccessExpression && (this.cannotBeResolved(((FirQualifiedAccessExpression)callOrAssignment).getDispatchReceiver()) || this.cannotBeResolved(((FirQualifiedAccessExpression)callOrAssignment).getExtensionReceiver()) || this.cannotBeResolved(((FirQualifiedAccessExpression)callOrAssignment).getExplicitReceiver()))) {
            return;
        }
        KtSourceElement ktSourceElement3 = source;
        source = ktSourceElement3 != null ? SourceHelpersKt.delegatedPropertySourceOrThis(ktSourceElement3, context2) : null;
        FirStatement firStatement4 = callOrAssignment;
        this.reportFirDiagnostic(diagnostic, source, context2, firStatement4 != null ? firStatement4.getSource() : null);
    }

    private final boolean cannotBeResolved(FirExpression $this$cannotBeResolved) {
        ConeDiagnostic diagnostic;
        FirExpression firExpression = $this$cannotBeResolved;
        ConeKotlinType coneKotlinType = firExpression != null ? FirTypeUtilsKt.getResolvedType(firExpression) : null;
        ConeErrorType coneErrorType = coneKotlinType instanceof ConeErrorType ? (ConeErrorType)coneKotlinType : null;
        ConeDiagnostic coneDiagnostic = diagnostic = coneErrorType != null ? coneErrorType.getDiagnostic() : null;
        return diagnostic instanceof ConeUnresolvedNameError || diagnostic instanceof ConeInstanceAccessBeforeSuperCall || diagnostic instanceof ConeAmbiguousSuper ? true : (diagnostic instanceof ConeSimpleDiagnostic ? ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.NotASupertype || ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.SuperNotAvailable || ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.UnresolvedLabel : false);
    }

    @Override
    public void visitErrorExpression(@NotNull FirErrorExpression errorExpression, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorExpression, (String)"errorExpression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KtSourceElement source = errorExpression.getSource();
        ConeDiagnostic diagnostic = errorExpression.getDiagnostic();
        if (source == null) {
            if (diagnostic instanceof ConeSyntaxDiagnostic) {
                return;
            }
            if (diagnostic instanceof ConeSimpleDiagnostic && ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.ExpressionExpected) {
                return;
            }
        }
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, diagnostic, source, data, null, 8, null);
    }

    @Override
    public void visitErrorFunction(@NotNull FirErrorFunction errorFunction, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorFunction, (String)"errorFunction");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KtSourceElement source = errorFunction.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorFunction.getDiagnostic(), source, data, null, 8, null);
    }

    @Override
    public void visitErrorProperty(@NotNull FirErrorProperty errorProperty, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorProperty, (String)"errorProperty");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KtSourceElement source = errorProperty.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorProperty.getDiagnostic(), source, data, null, 8, null);
    }

    @Override
    public void visitErrorResolvedQualifier(@NotNull FirErrorResolvedQualifier errorResolvedQualifier, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorResolvedQualifier, (String)"errorResolvedQualifier");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KtSourceElement source = errorResolvedQualifier.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorResolvedQualifier.getDiagnostic(), source, data, null, 8, null);
    }

    @Override
    public void visitErrorPrimaryConstructor(@NotNull FirErrorPrimaryConstructor errorPrimaryConstructor, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorPrimaryConstructor, (String)"errorPrimaryConstructor");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorPrimaryConstructor.getDiagnostic(), errorPrimaryConstructor.getSource(), data, null, 8, null);
    }

    @Override
    public void visitThisReference(@NotNull FirThisReference thisReference, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)thisReference, (String)"thisReference");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ConeDiagnostic coneDiagnostic = thisReference.getDiagnostic();
        if (coneDiagnostic == null) {
            return;
        }
        ConeDiagnostic diagnostic = coneDiagnostic;
        KtSourceElement ktSourceElement = thisReference.getSource();
        if (ktSourceElement == null) {
            FirElement firElement = (FirElement)CollectionsKt.getOrNull(data.getContainingElements(), (int)1);
            ktSourceElement = firElement != null ? firElement.getSource() : null;
        }
        KtSourceElement source = ktSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, diagnostic, source, data, null, 8, null);
    }

    @Override
    public void visitVarargArgumentsExpression(@NotNull FirVarargArgumentsExpression varargArgumentsExpression, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)varargArgumentsExpression, (String)"varargArgumentsExpression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ConeKotlinType coneKotlinType = varargArgumentsExpression.getConeElementTypeOrNull();
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType elementType = coneKotlinType;
        if (elementType instanceof ConeErrorType) {
            ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, ((ConeErrorType)elementType).getDiagnostic(), varargArgumentsExpression.getSource(), data, null, 8, null);
        }
    }

    private final void reportFirDiagnostic(ConeDiagnostic diagnostic, KtSourceElement source, CheckerContext context2, KtSourceElement callOrAssignmentSource) {
        block8: {
            block7: {
                KtSourceElement ktSourceElement = source;
                if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getElementType() : null), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY)) {
                    return;
                }
                KtSourceElement ktSourceElement2 = source;
                if (Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE) && (diagnostic instanceof ConeUnresolvedNameError || diagnostic instanceof ConeAmbiguityError || diagnostic instanceof ConeInapplicableWrongReceiver || diagnostic instanceof ConeInapplicableCandidateError)) {
                    return;
                }
                KtSourceElement ktSourceElement3 = source;
                if (Intrinsics.areEqual((Object)(ktSourceElement3 != null ? ktSourceElement3.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitConstructor.INSTANCE)) break block7;
                KtSourceElement ktSourceElement4 = source;
                if (!Intrinsics.areEqual((Object)(ktSourceElement4 != null ? ktSourceElement4.getKind() : null), (Object)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) break block8;
            }
            return;
        }
        KtSourceElement ktSourceElement = source;
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredPrefixSecondGetReference) {
            return;
        }
        for (KtDiagnostic coneDiagnostic : ConeDiagnosticToFirDiagnosticKt.toFirDiagnostics(diagnostic, this.getSession(), source, callOrAssignmentSource)) {
            this.getReporter().report(coneDiagnostic, context2);
        }
    }

    static /* synthetic */ void reportFirDiagnostic$default(ErrorNodeDiagnosticCollectorComponent errorNodeDiagnosticCollectorComponent, ConeDiagnostic coneDiagnostic, KtSourceElement ktSourceElement, CheckerContext checkerContext, KtSourceElement ktSourceElement2, int n, Object object) {
        if ((n & 8) != 0) {
            ktSourceElement2 = null;
        }
        errorNodeDiagnosticCollectorComponent.reportFirDiagnostic(coneDiagnostic, ktSourceElement, checkerContext, ktSourceElement2);
    }
}

