/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.xmlb;

import java.lang.ref.Reference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ksp.com.intellij.openapi.util.JDOMExternalizableStringList;
import ksp.com.intellij.reference.SoftReference;
import ksp.com.intellij.serialization.ClassUtil;
import ksp.com.intellij.serialization.MutableAccessor;
import ksp.com.intellij.serialization.SerializationException;
import ksp.com.intellij.util.xmlb.ArrayBinding;
import ksp.com.intellij.util.xmlb.BeanBinding;
import ksp.com.intellij.util.xmlb.Binding;
import ksp.com.intellij.util.xmlb.CollectionBinding;
import ksp.com.intellij.util.xmlb.CompactCollectionBinding;
import ksp.com.intellij.util.xmlb.JDOMElementBinding;
import ksp.com.intellij.util.xmlb.MapBinding;
import ksp.com.intellij.util.xmlb.SerializationFilter;
import ksp.com.intellij.util.xmlb.Serializer;
import ksp.com.intellij.util.xmlb.XmlSerializationException;
import ksp.com.intellij.util.xmlb.annotations.CollectionBean;
import ksp.org.jdom.Content;
import ksp.org.jdom.Element;
import ksp.org.jdom.Text;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class XmlSerializerImpl {
    static final XmlSerializer serializer = new XmlSerializer();

    @NotNull
    static Element serialize(@NotNull Object object, @Nullable SerializationFilter filter) throws SerializationException {
        Element element2;
        Binding binding;
        block7: {
            if (object == null) {
                XmlSerializerImpl.$$$reportNull$$$0(0);
            }
            Class<?> aClass = object.getClass();
            binding = serializer.getRootBinding(aClass, aClass);
            if (!(binding instanceof BeanBinding)) break block7;
            Element element3 = ((BeanBinding)binding).serialize(object, true, filter);
            if (element3 == null) {
                XmlSerializerImpl.$$$reportNull$$$0(1);
            }
            return element3;
        }
        try {
            element2 = (Element)binding.serialize(object, null, filter);
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException("Can't serialize instance of " + object.getClass(), e);
        }
        if (element2 == null) {
            XmlSerializerImpl.$$$reportNull$$$0(2);
        }
        return element2;
    }

    @Nullable
    static Object convert(@Nullable String value2, @NotNull Class<?> valueClass) {
        if (valueClass == null) {
            XmlSerializerImpl.$$$reportNull$$$0(3);
        }
        if (value2 == null) {
            return null;
        }
        if (valueClass == String.class) {
            return value2;
        }
        if (valueClass == Integer.TYPE || valueClass == Integer.class) {
            return Integer.parseInt(value2);
        }
        if (valueClass == Boolean.TYPE || valueClass == Boolean.class) {
            return Boolean.parseBoolean(value2);
        }
        if (valueClass == Double.TYPE || valueClass == Double.class) {
            return Double.parseDouble(value2);
        }
        if (valueClass == Float.TYPE || valueClass == Float.class) {
            return Float.valueOf(Float.parseFloat(value2));
        }
        if (valueClass == Long.TYPE || valueClass == Long.class) {
            return Long.parseLong(value2);
        }
        if (valueClass.isEnum()) {
            for (Object enumConstant : valueClass.getEnumConstants()) {
                if (!enumConstant.toString().equals(value2)) continue;
                return enumConstant;
            }
            return null;
        }
        if (Date.class.isAssignableFrom(valueClass)) {
            try {
                return new Date(Long.parseLong(value2));
            }
            catch (NumberFormatException e) {
                return new Date(0L);
            }
        }
        return value2;
    }

    static void doSet(@NotNull Object host, @Nullable String value2, @NotNull MutableAccessor accessor, @NotNull Class<?> valueClass) {
        if (host == null) {
            XmlSerializerImpl.$$$reportNull$$$0(4);
        }
        if (accessor == null) {
            XmlSerializerImpl.$$$reportNull$$$0(5);
        }
        if (valueClass == null) {
            XmlSerializerImpl.$$$reportNull$$$0(6);
        }
        if (value2 == null) {
            accessor.set(host, null);
        } else if (valueClass == String.class) {
            accessor.set(host, value2);
        } else if (valueClass == Integer.TYPE) {
            accessor.setInt(host, Integer.parseInt(value2));
        } else if (valueClass == Boolean.TYPE) {
            accessor.setBoolean(host, Boolean.parseBoolean(value2));
        } else if (valueClass == Double.TYPE) {
            accessor.setDouble(host, Double.parseDouble(value2));
        } else if (valueClass == Float.TYPE) {
            accessor.setFloat(host, Float.parseFloat(value2));
        } else if (valueClass == Long.TYPE) {
            accessor.setLong(host, Long.parseLong(value2));
        } else if (valueClass == Short.TYPE) {
            accessor.setShort(host, Short.parseShort(value2));
        } else if (valueClass.isEnum()) {
            accessor.set(host, ClassUtil.stringToEnum(value2, valueClass, false));
        } else if (Date.class.isAssignableFrom(valueClass)) {
            try {
                accessor.set(host, new Date(Long.parseLong(value2)));
            }
            catch (NumberFormatException e) {
                accessor.set(host, new Date(0L));
            }
        } else {
            Object deserializedValue = value2;
            if (valueClass == Boolean.class) {
                deserializedValue = Boolean.parseBoolean(value2);
            } else if (valueClass == Integer.class) {
                deserializedValue = Integer.parseInt(value2);
            } else if (valueClass == Short.class) {
                deserializedValue = Short.parseShort(value2);
            } else if (valueClass == Long.class) {
                deserializedValue = Long.parseLong(value2);
            } else if (valueClass == Double.class) {
                deserializedValue = Double.parseDouble(value2);
            } else if (valueClass == Float.class) {
                deserializedValue = Float.valueOf(Float.parseFloat(value2));
            } else if (XmlSerializerImpl.callFromStringIfDefined(host, value2, accessor, valueClass)) {
                return;
            }
            accessor.set(host, deserializedValue);
        }
    }

    private static boolean callFromStringIfDefined(@NotNull Object host, @NotNull String value2, @NotNull MutableAccessor accessor, @NotNull Class<?> valueClass) {
        Method fromText;
        if (host == null) {
            XmlSerializerImpl.$$$reportNull$$$0(7);
        }
        if (value2 == null) {
            XmlSerializerImpl.$$$reportNull$$$0(8);
        }
        if (accessor == null) {
            XmlSerializerImpl.$$$reportNull$$$0(9);
        }
        if (valueClass == null) {
            XmlSerializerImpl.$$$reportNull$$$0(10);
        }
        try {
            fromText = valueClass.getMethod("fromText", String.class);
        }
        catch (NoSuchMethodException ignored) {
            return false;
        }
        try {
            fromText.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            accessor.set(host, fromText.invoke(null, value2));
            return true;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
    }

    @NotNull
    static String convertToString(@NotNull Object value2) {
        if (value2 == null) {
            XmlSerializerImpl.$$$reportNull$$$0(11);
        }
        if (value2 instanceof Date) {
            String string2 = Long.toString(((Date)value2).getTime());
            if (string2 == null) {
                XmlSerializerImpl.$$$reportNull$$$0(12);
            }
            return string2;
        }
        String string3 = value2.toString();
        if (string3 == null) {
            XmlSerializerImpl.$$$reportNull$$$0(13);
        }
        return string3;
    }

    @NotNull
    static String getTextValue(@NotNull Element element2, @NotNull String defaultText) {
        if (element2 == null) {
            XmlSerializerImpl.$$$reportNull$$$0(14);
        }
        if (defaultText == null) {
            XmlSerializerImpl.$$$reportNull$$$0(15);
        }
        List<Content> content = element2.getContent();
        int size = content.size();
        StringBuilder builder2 = null;
        for (int i = 0; i < size; ++i) {
            Content child = content.get(i);
            if (!(child instanceof Text)) continue;
            String value2 = child.getValue();
            if (builder2 == null && i == size - 1) {
                String string2 = value2;
                if (string2 == null) {
                    XmlSerializerImpl.$$$reportNull$$$0(16);
                }
                return string2;
            }
            if (builder2 == null) {
                builder2 = new StringBuilder();
            }
            builder2.append(value2);
        }
        String string3 = builder2 == null ? defaultText : builder2.toString();
        if (string3 == null) {
            XmlSerializerImpl.$$$reportNull$$$0(17);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/xmlb/XmlSerializerImpl";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/xmlb/XmlSerializerImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToString";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doSet";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "callFromStringIfDefined";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertToString";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTextValue";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class XmlSerializer
    extends XmlSerializerBase {
        private Reference<Map<Type, Binding>> ourBindings;

        XmlSerializer() {
        }

        @NotNull
        private Map<Type, Binding> getBindingCacheMap() {
            Map<Type, Binding> map = SoftReference.dereference(this.ourBindings);
            if (map == null) {
                map = new ConcurrentHashMap<Type, Binding>();
                this.ourBindings = new java.lang.ref.SoftReference<Map<Type, Binding>>(map);
            }
            Map<Type, Binding> map2 = map;
            if (map2 == null) {
                XmlSerializer.$$$reportNull$$$0(0);
            }
            return map2;
        }

        @Override
        @NotNull
        public synchronized Binding getRootBinding(@NotNull Class<?> aClass, @NotNull Type originalType) {
            Map<Type, Binding> map;
            Binding binding;
            if (aClass == null) {
                XmlSerializer.$$$reportNull$$$0(1);
            }
            if (originalType == null) {
                XmlSerializer.$$$reportNull$$$0(2);
            }
            if ((binding = (map = this.getBindingCacheMap()).get(originalType)) == null) {
                binding = XmlSerializer.createClassBinding(aClass, null, originalType);
                if (binding == null) {
                    binding = new BeanBinding(aClass);
                }
                map.put(originalType, binding);
                try {
                    binding.init(originalType, this);
                }
                catch (Error | RuntimeException e) {
                    map.remove(originalType);
                    throw e;
                }
            }
            Binding binding2 = binding;
            if (binding2 == null) {
                XmlSerializer.$$$reportNull$$$0(3);
            }
            return binding2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBindingCacheMap";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootBinding";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getRootBinding";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class XmlSerializerBase
    implements Serializer {
        @Override
        @Nullable
        public final Binding getBinding(@NotNull Class<?> aClass, @NotNull Type type2) {
            if (aClass == null) {
                XmlSerializerBase.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                XmlSerializerBase.$$$reportNull$$$0(1);
            }
            return ClassUtil.isPrimitive(aClass) ? null : this.getRootBinding(aClass, type2);
        }

        @Override
        @NotNull
        public final synchronized Binding getRootBinding(@NotNull Class<?> aClass, @NotNull Type originalType, @NotNull MutableAccessor accessor) {
            Binding binding;
            if (aClass == null) {
                XmlSerializerBase.$$$reportNull$$$0(2);
            }
            if (originalType == null) {
                XmlSerializerBase.$$$reportNull$$$0(3);
            }
            if (accessor == null) {
                XmlSerializerBase.$$$reportNull$$$0(4);
            }
            if ((binding = XmlSerializerBase.createClassBinding(aClass, accessor, originalType)) == null) {
                binding = this.getRootBinding(aClass, originalType);
            } else {
                binding.init(originalType, this);
            }
            Binding binding2 = binding;
            if (binding2 == null) {
                XmlSerializerBase.$$$reportNull$$$0(5);
            }
            return binding2;
        }

        @Override
        @Nullable
        public final Binding getBinding(@NotNull MutableAccessor accessor) {
            Type type2;
            Class<?> aClass;
            if (accessor == null) {
                XmlSerializerBase.$$$reportNull$$$0(6);
            }
            return ClassUtil.isPrimitive(aClass = ClassUtil.typeToClass(type2 = accessor.getGenericType())) ? null : this.getRootBinding(aClass, type2, accessor);
        }

        @Nullable
        protected static Binding createClassBinding(@NotNull Class<?> aClass, @Nullable MutableAccessor accessor, @NotNull Type originalType) {
            if (aClass == null) {
                XmlSerializerBase.$$$reportNull$$$0(7);
            }
            if (originalType == null) {
                XmlSerializerBase.$$$reportNull$$$0(8);
            }
            if (aClass.isArray()) {
                if (Element.class.isAssignableFrom(aClass.getComponentType())) {
                    assert (accessor != null);
                    return new JDOMElementBinding(accessor);
                }
                return new ArrayBinding(aClass, accessor);
            }
            if (Collection.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
                CollectionBean listBean;
                if (accessor != null && (listBean = accessor.getAnnotation(CollectionBean.class)) != null) {
                    return new CompactCollectionBinding(accessor);
                }
                return new CollectionBinding((ParameterizedType)originalType, accessor);
            }
            if (Map.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
                return new MapBinding(accessor, aClass);
            }
            if (accessor != null) {
                if (Element.class.isAssignableFrom(aClass)) {
                    return new JDOMElementBinding(accessor);
                }
                if (JDOMExternalizableStringList.class == aClass) {
                    return new CompactCollectionBinding(accessor);
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalType";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accessor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializerBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializerBase";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootBinding";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getBinding";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getRootBinding";
                    break;
                }
                case 5: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createClassBinding";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

