/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import java.io.InputStream;
import ksp.org.jetbrains.annotations.NotNull;

public class UnsyncByteArrayInputStream
extends InputStream {
    protected byte[] myBuffer;
    private int myPosition;
    private int myCount;
    private int myMarkedPosition;

    public UnsyncByteArrayInputStream(@NotNull byte[] buf) {
        if (buf == null) {
            UnsyncByteArrayInputStream.$$$reportNull$$$0(0);
        }
        this(buf, 0, buf.length);
    }

    public UnsyncByteArrayInputStream(@NotNull byte[] buf, int offset, int length) {
        if (buf == null) {
            UnsyncByteArrayInputStream.$$$reportNull$$$0(1);
        }
        this.init(buf, offset, length);
    }

    public void init(@NotNull byte[] buf, int offset, int length) {
        if (buf == null) {
            UnsyncByteArrayInputStream.$$$reportNull$$$0(2);
        }
        this.myBuffer = buf;
        this.myPosition = offset;
        this.myCount = length;
    }

    @Override
    public int read() {
        return this.myPosition < this.myCount ? this.myBuffer[this.myPosition++] & 0xFF : -1;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        if (b == null) {
            UnsyncByteArrayInputStream.$$$reportNull$$$0(3);
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.myPosition >= this.myCount) {
            return -1;
        }
        if (this.myPosition + len > this.myCount) {
            len = this.myCount - this.myPosition;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.myBuffer, this.myPosition, b, off, len);
        this.myPosition += len;
        return len;
    }

    @Override
    public long skip(long n) {
        if ((long)this.myPosition + n > (long)this.myCount) {
            n = this.myCount - this.myPosition;
        }
        if (n < 0L) {
            return 0L;
        }
        this.myPosition = (int)((long)this.myPosition + n);
        return n;
    }

    @Override
    public int available() {
        return this.myCount - this.myPosition;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readLimit) {
        this.myMarkedPosition = this.myPosition;
    }

    @Override
    public void reset() {
        this.myPosition = this.myMarkedPosition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/util/io/UnsyncByteArrayInputStream";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

