/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.containers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.com.intellij.util.Processor;
import ksp.com.intellij.util.containers.CollectionFactory;
import ksp.org.jetbrains.annotations.Debug;
import ksp.org.jetbrains.annotations.NotNull;

@Debug.Renderer(text="\"size = \" + size()", hasChildren="!isEmpty()", childrenArray="myMap.entrySet().toArray()")
public class MostlySingularMultiMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 2784473565881807109L;
    protected final Map<K, Object> myMap;

    public MostlySingularMultiMap() {
        this.myMap = CollectionFactory.createSmallMemoryFootprintMap();
    }

    public MostlySingularMultiMap(@NotNull Map<K, Object> map) {
        if (map == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(0);
        }
        this.myMap = map;
    }

    public void add(@NotNull K key, @NotNull V value2) {
        Object current;
        if (key == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(1);
        }
        if (value2 == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(2);
        }
        if ((current = this.myMap.get(key)) == null) {
            this.myMap.put(key, value2);
        } else if (current instanceof ValueList) {
            ((List)current).add(value2);
        } else {
            ValueList newList = new ValueList();
            newList.add(current);
            newList.add(value2);
            this.myMap.put(key, newList);
        }
    }

    public boolean remove(@NotNull K key, @NotNull V value2) {
        Object current;
        if (key == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(3);
        }
        if (value2 == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(4);
        }
        if ((current = this.myMap.get(key)) == null) {
            return false;
        }
        if (current instanceof ValueList) {
            return ((List)current).remove(value2);
        }
        if (value2.equals(current)) {
            this.myMap.remove(key);
            return true;
        }
        return false;
    }

    public boolean removeAllValues(@NotNull K key) {
        if (key == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(5);
        }
        return this.myMap.remove(key) != null;
    }

    @NotNull
    public final Set<K> keySet() {
        Set<K> set = this.myMap.keySet();
        if (set == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(6);
        }
        return set;
    }

    public final boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    public final boolean processForKey(@NotNull K key, @NotNull Processor<? super V> p) {
        if (key == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(7);
        }
        if (p == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(8);
        }
        return this.processValue(p, this.myMap.get(key));
    }

    private boolean processValue(@NotNull Processor<? super V> p, Object v) {
        if (p == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(9);
        }
        if (v instanceof ValueList) {
            for (Object o : (ValueList)v) {
                if (p.process(o)) continue;
                return false;
            }
            return true;
        }
        return v == null || p.process(v);
    }

    public boolean processAllValues(@NotNull Processor<? super V> p) {
        if (p == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(10);
        }
        for (Object v : this.myMap.values()) {
            if (this.processValue(p, v)) continue;
            return false;
        }
        return true;
    }

    public final int size() {
        return this.myMap.size();
    }

    public final boolean containsKey(@NotNull K key) {
        if (key == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(11);
        }
        return this.myMap.containsKey(key);
    }

    public final int valuesForKey(@NotNull K key) {
        Object current;
        if (key == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(12);
        }
        if ((current = this.myMap.get(key)) == null) {
            return 0;
        }
        if (current instanceof ValueList) {
            return ((ValueList)current).size();
        }
        return 1;
    }

    @NotNull
    public final Iterable<V> get(@NotNull K name2) {
        if (name2 == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(13);
        }
        return this.rawValueToCollection(this.myMap.get(name2));
    }

    @NotNull
    protected final List<V> rawValueToCollection(Object value2) {
        if (value2 == null) {
            List list = Collections.emptyList();
            if (list == null) {
                MostlySingularMultiMap.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (value2 instanceof ValueList) {
            ValueList valueList = (ValueList)value2;
            if (valueList == null) {
                MostlySingularMultiMap.$$$reportNull$$$0(15);
            }
            return valueList;
        }
        List<Object> list = Collections.singletonList(value2);
        if (list == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(16);
        }
        return list;
    }

    public void compact() {
        CollectionFactory.trimMap(this.myMap);
        for (Object eachValue : this.myMap.values()) {
            if (!(eachValue instanceof ValueList)) continue;
            ((ValueList)eachValue).trimToSize();
        }
    }

    public final String toString() {
        return "{" + StringUtil.join(this.myMap.entrySet(), entry -> {
            Object value2 = entry.getValue();
            String s = (value2 instanceof ValueList ? value2 : Collections.singletonList(value2)).toString();
            return entry.getKey() + ": " + s;
        }, "; ") + "}";
    }

    public void clear() {
        this.myMap.clear();
    }

    @NotNull
    public static <K, V> MostlySingularMultiMap<K, V> emptyMap() {
        MostlySingularMultiMap<?, ?> mostlySingularMultiMap = EmptyMap.EMPTY;
        if (mostlySingularMultiMap == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(17);
        }
        return mostlySingularMultiMap;
    }

    public void addAll(@NotNull MostlySingularMultiMap<K, V> other) {
        if (other == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(18);
        }
        if (other.isEmpty()) {
            return;
        }
        for (Map.Entry<K, Object> entry : other.myMap.entrySet()) {
            K key = entry.getKey();
            Object otherValue = entry.getValue();
            Object myValue = this.myMap.get(key);
            if (myValue == null) {
                if (otherValue instanceof ValueList) {
                    this.myMap.put(key, new ValueList((ValueList)otherValue));
                    continue;
                }
                this.myMap.put(key, otherValue);
                continue;
            }
            if (myValue instanceof ValueList) {
                ValueList myListValue = (ValueList)myValue;
                if (otherValue instanceof ValueList) {
                    myListValue.addAll((ValueList)otherValue);
                    continue;
                }
                myListValue.add(otherValue);
                continue;
            }
            if (otherValue instanceof ValueList) {
                ValueList otherListValue = (ValueList)otherValue;
                ValueList newList = new ValueList(otherListValue.size() + 1);
                newList.add(myValue);
                newList.addAll(otherListValue);
                this.myMap.put(key, newList);
                continue;
            }
            ValueList newList = new ValueList();
            newList.add(myValue);
            newList.add(otherValue);
            this.myMap.put(key, newList);
        }
    }

    @NotNull
    public static Class<? extends List<?>> getValueListClass() {
        return ValueList.class;
    }

    @NotNull
    public static List<?> createValueList() {
        return new ValueList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/containers/MostlySingularMultiMap";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/containers/MostlySingularMultiMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "rawValueToCollection";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeAllValues";
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processForKey";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAllValues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "valuesForKey";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class EmptyMap
    extends MostlySingularMultiMap<Object, Object> {
        static final MostlySingularMultiMap<?, ?> EMPTY = new EmptyMap();

        private EmptyMap() {
            super(Collections.emptyMap());
        }

        @Override
        public void add(@NotNull Object key, @NotNull Object value2) {
            if (key == null) {
                EmptyMap.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                EmptyMap.$$$reportNull$$$0(1);
            }
            throw new IncorrectOperationException();
        }

        @Override
        public boolean remove(@NotNull Object key, @NotNull Object value2) {
            if (key == null) {
                EmptyMap.$$$reportNull$$$0(2);
            }
            if (value2 == null) {
                EmptyMap.$$$reportNull$$$0(3);
            }
            throw new IncorrectOperationException();
        }

        @Override
        public void clear() {
            throw new IncorrectOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "ksp/com/intellij/util/containers/MostlySingularMultiMap$EmptyMap";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "remove";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static final class ValueList<V>
    extends ArrayList<V> {
        public ValueList() {
        }

        public ValueList(int initialCapacity) {
            super(initialCapacity);
        }

        public ValueList(@NotNull Collection<? extends V> c) {
            if (c == null) {
                ValueList.$$$reportNull$$$0(0);
            }
            super(c);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "ksp/com/intellij/util/containers/MostlySingularMultiMap$ValueList", "<init>"));
        }
    }
}

