/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.ide.plugins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import ksp.com.intellij.ide.plugins.IdeaPluginDescriptor;
import ksp.com.intellij.ide.plugins.IdeaPluginDescriptorImplKt;
import ksp.com.intellij.ide.plugins.PluginEnabler;
import ksp.com.intellij.ide.plugins.PluginManagerCore;
import ksp.com.intellij.openapi.application.PathManager;
import ksp.com.intellij.openapi.application.ex.ApplicationInfoEx;
import ksp.com.intellij.openapi.application.impl.ApplicationInfoImpl;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.extensions.PluginId;
import ksp.com.intellij.openapi.util.io.NioFiles;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class DisabledPluginsState
implements PluginEnabler {
    @NonNls
    public static final String DISABLED_PLUGINS_FILENAME = "disabled_plugins.txt";
    @Nullable
    private static volatile Set<PluginId> ourDisabledPlugins;
    private static final List<Runnable> ourDisabledPluginListeners;
    private static volatile boolean ourIgnoreDisabledPlugins;

    DisabledPluginsState() {
    }

    public static void addDisablePluginListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(0);
        }
        ourDisabledPluginListeners.add(listener2);
    }

    public static void removeDisablePluginListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(1);
        }
        ourDisabledPluginListeners.remove(listener2);
    }

    public static void setIgnoreDisabledPlugins(boolean ignoreDisabledPlugins) {
        ourIgnoreDisabledPlugins = ignoreDisabledPlugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Set<PluginId> loadDisabledPlugins() {
        LinkedHashSet<PluginId> disabledPlugins = new LinkedHashSet<PluginId>();
        Path file2 = Paths.get(PathManager.getConfigPath(), DISABLED_PLUGINS_FILENAME);
        if (!Files.isRegularFile(file2, new LinkOption[0])) {
            LinkedHashSet<PluginId> linkedHashSet = disabledPlugins;
            if (linkedHashSet == null) {
                DisabledPluginsState.$$$reportNull$$$0(2);
            }
            return linkedHashSet;
        }
        ApplicationInfoEx applicationInfo = ApplicationInfoImpl.getShadowInstance();
        List<String> requiredPlugins = DisabledPluginsState.splitByComma("idea.required.plugins.id");
        boolean updateDisablePluginsList = false;
        try (BufferedReader reader = Files.newBufferedReader(file2);){
            String id;
            while ((id = reader.readLine()) != null) {
                if ((id = id.trim()).isEmpty()) continue;
                if (!requiredPlugins.contains(id) && !applicationInfo.isEssentialPlugin(id)) {
                    DisabledPluginsState.addIdTo(id, disabledPlugins);
                    continue;
                }
                updateDisablePluginsList = true;
            }
            for (String suppressedId : DisabledPluginsState.getNonEssentialSuppressedPlugins(applicationInfo)) {
                if (!DisabledPluginsState.addIdTo(suppressedId, disabledPlugins)) continue;
                updateDisablePluginsList = true;
            }
        }
        catch (IOException e) {
            DisabledPluginsState.getLogger().info("Unable to load disabled plugins list from " + file2, e);
        }
        finally {
            if (updateDisablePluginsList) {
                DisabledPluginsState.trySaveDisabledPlugins(file2, disabledPlugins, false);
            }
        }
        LinkedHashSet<PluginId> linkedHashSet = disabledPlugins;
        if (linkedHashSet == null) {
            DisabledPluginsState.$$$reportNull$$$0(3);
        }
        return linkedHashSet;
    }

    @NotNull
    public static Set<PluginId> disabledPlugins() {
        Set<PluginId> set = Collections.unmodifiableSet(DisabledPluginsState.getDisabledIds());
        if (set == null) {
            DisabledPluginsState.$$$reportNull$$$0(4);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Set<PluginId> getDisabledIds() {
        Set<PluginId> result2 = ourDisabledPlugins;
        if (result2 != null) {
            Set<PluginId> set = result2;
            if (set == null) {
                DisabledPluginsState.$$$reportNull$$$0(5);
            }
            return set;
        }
        if (ourIgnoreDisabledPlugins || System.getProperty("idea.ignore.disabled.plugins") != null) {
            return new HashSet<PluginId>();
        }
        Class<DisabledPluginsState> clazz = DisabledPluginsState.class;
        synchronized (DisabledPluginsState.class) {
            result2 = ourDisabledPlugins;
            if (result2 == null) {
                ourDisabledPlugins = result2 = DisabledPluginsState.loadDisabledPlugins();
            }
            Set<PluginId> set = result2;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (set == null) {
                DisabledPluginsState.$$$reportNull$$$0(6);
            }
            return set;
        }
    }

    @Override
    public boolean isDisabled(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            DisabledPluginsState.$$$reportNull$$$0(7);
        }
        return DisabledPluginsState.getDisabledIds().contains(pluginId);
    }

    @Override
    public boolean enable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors) {
        if (descriptors == null) {
            DisabledPluginsState.$$$reportNull$$$0(8);
        }
        return this.enableById(IdeaPluginDescriptorImplKt.toPluginSet(descriptors));
    }

    @Override
    public boolean disable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors) {
        if (descriptors == null) {
            DisabledPluginsState.$$$reportNull$$$0(9);
        }
        return this.disableById(IdeaPluginDescriptorImplKt.toPluginSet(descriptors));
    }

    @Override
    public boolean enableById(@NotNull Set<PluginId> pluginIds) {
        if (pluginIds == null) {
            DisabledPluginsState.$$$reportNull$$$0(10);
        }
        return DisabledPluginsState.setEnabledState(pluginIds, true);
    }

    @Override
    public boolean disableById(@NotNull Set<PluginId> pluginIds) {
        if (pluginIds == null) {
            DisabledPluginsState.$$$reportNull$$$0(11);
        }
        return DisabledPluginsState.setEnabledState(pluginIds, false);
    }

    static boolean setEnabledState(@NotNull Set<PluginId> plugins, boolean enabled) {
        if (plugins == null) {
            DisabledPluginsState.$$$reportNull$$$0(12);
        }
        Set<PluginId> disabled = DisabledPluginsState.getDisabledIds();
        boolean changed = enabled ? disabled.removeAll(plugins) : disabled.addAll(plugins);
        DisabledPluginsState.getLogger().info(DisabledPluginsState.joinedPluginIds(plugins, enabled));
        return changed && DisabledPluginsState.trySaveDisabledPlugins(disabled);
    }

    public static boolean trySaveDisabledPlugins(@NotNull Collection<PluginId> pluginIds) {
        if (pluginIds == null) {
            DisabledPluginsState.$$$reportNull$$$0(13);
        }
        return DisabledPluginsState.trySaveDisabledPlugins(PathManager.getConfigDir().resolve(DISABLED_PLUGINS_FILENAME), pluginIds, true);
    }

    private static boolean trySaveDisabledPlugins(@NotNull Path file2, @NotNull Collection<PluginId> pluginIds, boolean invalidate) {
        if (file2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(14);
        }
        if (pluginIds == null) {
            DisabledPluginsState.$$$reportNull$$$0(15);
        }
        try {
            DisabledPluginsState.saveDisabledPlugins(file2, pluginIds, invalidate);
            return true;
        }
        catch (IOException e) {
            DisabledPluginsState.getLogger().warn("Unable to save disabled plugins list", e);
            return false;
        }
    }

    @TestOnly
    public static void saveDisabledPlugins(@NotNull Path configDir, String ... ids) throws IOException {
        if (configDir == null) {
            DisabledPluginsState.$$$reportNull$$$0(16);
        }
        ArrayList<PluginId> pluginIds = new ArrayList<PluginId>();
        for (String id : ids) {
            DisabledPluginsState.addIdTo(id, pluginIds);
        }
        DisabledPluginsState.saveDisabledPlugins(configDir.resolve(DISABLED_PLUGINS_FILENAME), pluginIds, true);
    }

    private static void saveDisabledPlugins(@NotNull Path file2, @NotNull Collection<PluginId> pluginIds, boolean invalidate) throws IOException {
        if (file2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(17);
        }
        if (pluginIds == null) {
            DisabledPluginsState.$$$reportNull$$$0(18);
        }
        DisabledPluginsState.savePluginsList(pluginIds, file2);
        if (invalidate) {
            DisabledPluginsState.invalidate();
        }
        for (Runnable listener2 : ourDisabledPluginListeners) {
            listener2.run();
        }
    }

    public static void savePluginsList(@NotNull Collection<PluginId> ids, @NotNull Path file2) throws IOException {
        if (ids == null) {
            DisabledPluginsState.$$$reportNull$$$0(19);
        }
        if (file2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(20);
        }
        NioFiles.createDirectories(file2.getParent());
        try (BufferedWriter writer = Files.newBufferedWriter(file2, new OpenOption[0]);){
            PluginManagerCore.writePluginsList(ids, writer);
        }
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger2 = Logger.getInstance("#com.intellij.ide.plugins.DisabledPluginsState");
        if (logger2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(21);
        }
        return logger2;
    }

    static void invalidate() {
        ourDisabledPlugins = null;
    }

    private static boolean addIdTo(@NotNull String id, @NotNull Collection<PluginId> pluginIds) {
        if (id == null) {
            DisabledPluginsState.$$$reportNull$$$0(22);
        }
        if (pluginIds == null) {
            DisabledPluginsState.$$$reportNull$$$0(23);
        }
        return pluginIds.add(PluginId.getId(id));
    }

    @NotNull
    private static List<String> getNonEssentialSuppressedPlugins(@NotNull ApplicationInfoEx applicationInfo) {
        List<String> suppressedPlugins;
        if (applicationInfo == null) {
            DisabledPluginsState.$$$reportNull$$$0(24);
        }
        if ((suppressedPlugins = DisabledPluginsState.splitByComma("idea.suppressed.plugins.id")).isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                DisabledPluginsState.$$$reportNull$$$0(25);
            }
            return list;
        }
        ArrayList<String> result2 = new ArrayList<String>(suppressedPlugins.size());
        for (String suppressedPlugin : suppressedPlugins) {
            if (applicationInfo.isEssentialPlugin(suppressedPlugin)) continue;
            result2.add(suppressedPlugin);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            DisabledPluginsState.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> splitByComma(@NotNull String key) {
        String[] strings2;
        if (key == null) {
            DisabledPluginsState.$$$reportNull$$$0(27);
        }
        List<String> list = (strings2 = System.getProperty(key, "").split(",")).length == 0 || strings2.length == 1 && strings2[0].isEmpty() ? Collections.emptyList() : Arrays.asList(strings2);
        if (list == null) {
            DisabledPluginsState.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    private static String joinedPluginIds(@NotNull Collection<PluginId> pluginIds, boolean enabled) {
        if (pluginIds == null) {
            DisabledPluginsState.$$$reportNull$$$0(29);
        }
        StringBuilder buffer = new StringBuilder("Plugins to ").append(enabled ? "enable" : "disable").append(": [");
        Iterator<PluginId> iterator2 = pluginIds.iterator();
        while (iterator2.hasNext()) {
            buffer.append(iterator2.next().getIdString());
            if (!iterator2.hasNext()) continue;
            buffer.append(", ");
        }
        String string2 = buffer.append(']').toString();
        if (string2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(30);
        }
        return string2;
    }

    static {
        ourDisabledPluginListeners = new CopyOnWriteArrayList<Runnable>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/ide/plugins/DisabledPluginsState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDir";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationInfo";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/ide/plugins/DisabledPluginsState";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDisabledPlugins";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "disabledPlugins";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIds";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonEssentialSuppressedPlugins";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByComma";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "joinedPluginIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeDisablePluginListener";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "enable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "disable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "enableById";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "disableById";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setEnabledState";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "trySaveDisabledPlugins";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "saveDisabledPlugins";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "savePluginsList";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addIdTo";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getNonEssentialSuppressedPlugins";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "splitByComma";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "joinedPluginIds";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

