/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.ide.plugins;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.diagnostic.PluginException;
import ksp.com.intellij.ide.plugins.ClassLoaderConfigurator;
import ksp.com.intellij.ide.plugins.ClassLoaderConfiguratorKt;
import ksp.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import ksp.com.intellij.ide.plugins.PluginDependency;
import ksp.com.intellij.ide.plugins.PluginManagerCore;
import ksp.com.intellij.ide.plugins.PluginSet;
import ksp.com.intellij.ide.plugins.cl.PluginClassLoader;
import ksp.com.intellij.openapi.extensions.PluginId;
import ksp.com.intellij.util.SmartList;
import ksp.com.intellij.util.lang.ClassPath;
import ksp.com.intellij.util.lang.ResourceFile;
import ksp.com.intellij.util.lang.UrlClassLoader;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u00010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u0006\u0010\u001a\u001a\u00020\u0018J#\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ \u0010\u001f\u001a\u00020\u00182\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\"0!J\u0018\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u0005H\u0002J\u000e\u0010%\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eJ+\u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u000e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010)\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010*J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u0018\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\u0016\u00a8\u00061"}, d2={"Lksp/com/intellij/ide/plugins/ClassLoaderConfigurator;", "", "pluginSet", "Lksp/com/intellij/ide/plugins/PluginSet;", "coreLoader", "Ljava/lang/ClassLoader;", "(Lcom/intellij/ide/plugins/PluginSet;Ljava/lang/ClassLoader;)V", "mainToClassPath", "Ljava/util/IdentityHashMap;", "Lksp/com/intellij/openapi/extensions/PluginId;", "Lksp/com/intellij/ide/plugins/ClassLoaderConfigurator$MainInfo;", "pluginPackagePrefixUniqueGuard", "Ljava/util/HashMap;", "", "Lksp/com/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "getPluginSet", "()Lcom/intellij/ide/plugins/PluginSet;", "resourceFileFactory", "Ljava/util/function/Function;", "Ljava/nio/file/Path;", "Lksp/com/intellij/util/lang/ResourceFile;", "getResourceFileFactory$annotations", "()V", "checkPackagePrefixUniqueness", "", "module", "configure", "configureCorePluginModuleClassLoader", "deps", "", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;[Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;)V", "configureDependenciesIfNeeded", "mainToModule", "", "", "configureDependenciesInOldFormat", "mainDependentClassLoader", "configureModule", "createPluginClassLoader", "Lksp/com/intellij/ide/plugins/cl/PluginClassLoader;", "dependencies", "mainInfo", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;[Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;Lcom/intellij/ide/plugins/ClassLoaderConfigurator$MainInfo;)Lcom/intellij/ide/plugins/cl/PluginClassLoader;", "getCoreUrlClassLoaderIfPossible", "Lksp/com/intellij/util/lang/UrlClassLoader;", "setPluginClassLoaderForModuleAndOldSubDescriptors", "rootDescriptor", "classLoader", "MainInfo", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class ClassLoaderConfigurator {
    private final HashMap<String, IdeaPluginDescriptorImpl> pluginPackagePrefixUniqueGuard;
    private final Function<Path, ResourceFile> resourceFileFactory;
    private final IdentityHashMap<PluginId, MainInfo> mainToClassPath;
    @NotNull
    private final PluginSet pluginSet;
    private final ClassLoader coreLoader;

    private static /* synthetic */ void getResourceFileFactory$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    public final void configureDependenciesIfNeeded(@NotNull Map<IdeaPluginDescriptorImpl, ? extends List<IdeaPluginDescriptorImpl>> mainToModule) {
        Intrinsics.checkNotNullParameter(mainToModule, (String)"mainToModule");
        Object object = mainToModule;
        boolean bl = false;
        Iterator<Map.Entry<IdeaPluginDescriptorImpl, ? extends List<IdeaPluginDescriptorImpl>>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void mainDependent;
            Map.Entry<IdeaPluginDescriptorImpl, ? extends List<IdeaPluginDescriptorImpl>> entry;
            Map.Entry<IdeaPluginDescriptorImpl, ? extends List<IdeaPluginDescriptorImpl>> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            List<IdeaPluginDescriptorImpl> modules = entry2.getValue();
            ClassLoader classLoader = mainDependent.getPluginClassLoader();
            if (classLoader == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.ide.plugins.cl.PluginClassLoader");
            }
            PluginClassLoader mainDependentClassLoader = (PluginClassLoader)classLoader;
            PluginId pluginId = mainDependent.getPluginId();
            ClassPath classPath2 = mainDependentClassLoader.getClassPath();
            Intrinsics.checkNotNullExpressionValue((Object)classPath2, (String)"mainDependentClassLoader.classPath");
            Collection collection = mainDependentClassLoader.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"mainDependentClassLoader.files");
            List<String> list = mainDependentClassLoader.getLibDirectories();
            Intrinsics.checkNotNullExpressionValue(list, (String)"mainDependentClassLoader.libDirectories");
            this.mainToClassPath.put(pluginId, new MainInfo(classPath2, (List<? extends Path>)collection, list));
            if (mainDependent.packagePrefix == null) {
                for (IdeaPluginDescriptorImpl module2 : modules) {
                    module2.setPluginClassLoader(mainDependentClassLoader);
                }
                continue;
            }
            for (IdeaPluginDescriptorImpl module3 : modules) {
                this.configureModule(module3);
            }
        }
    }

    public final void configure() {
        for (IdeaPluginDescriptorImpl module2 : this.pluginSet.getRawListOfEnabledModules()) {
            this.configureModule(module2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void configureModule(@NotNull IdeaPluginDescriptorImpl module2) {
        IdeaPluginDescriptorImpl[] dependencies;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        this.checkPackagePrefixUniqueness(module2);
        boolean isMain = module2.moduleName == null;
        IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = this.pluginSet.moduleToDirectDependencies.get(module2);
        if (ideaPluginDescriptorImplArray == null) {
            ideaPluginDescriptorImplArray = dependencies = ClassLoaderConfiguratorKt.access$getEMPTY_DESCRIPTOR_ARRAY$p();
        }
        if (dependencies.length > 1) {
            dependencies = (IdeaPluginDescriptorImpl[])dependencies.clone();
            ClassLoaderConfiguratorKt.sortDependenciesInPlace(dependencies);
        }
        if (isMain) {
            ClassLoader classLoader;
            if (module2.useCoreClassLoader || Intrinsics.areEqual((Object)module2.getPluginId(), (Object)PluginManagerCore.CORE_ID)) {
                this.setPluginClassLoaderForModuleAndOldSubDescriptors(module2, this.coreLoader);
                return;
            }
            List<Path> files2 = module2.jarFiles;
            if (files2 == null) {
                if (!module2.isUseIdeaClassLoader) {
                    ClassLoaderConfiguratorKt.access$getLog$p().error("jarFiles is not set for " + module2);
                }
                List list = Collections.emptyList();
                Intrinsics.checkNotNull(list);
                files2 = list;
            }
            List libDirectories = new SmartList();
            Path libDir = module2.path.resolve("lib");
            if (Files.exists(libDir, new LinkOption[0])) {
                libDirectories.add(((Object)libDir.toAbsolutePath()).toString());
            }
            boolean mimicJarUrlConnection = !module2.isBundled() && Intrinsics.areEqual((Object)module2.getVendor(), (Object)"JetBrains") ^ true;
            ClassPath pluginClassPath = new ClassPath(files2, Collections.emptySet(), ClassLoaderConfiguratorKt.access$getDEFAULT_CLASSLOADER_CONFIGURATION$p(), this.resourceFileFactory, mimicJarUrlConnection);
            MainInfo mainInfo = new MainInfo(pluginClassPath, files2, libDirectories);
            MainInfo existing = this.mainToClassPath.put(module2.getPluginId(), mainInfo);
            if (existing != null) {
                ClassLoaderConfiguratorKt.access$getLog$p().error(new PluginException("Main module with " + module2.getPluginId() + " is already added (existingClassPath=" + existing.files, module2.getPluginId()));
            }
            if (module2.isUseIdeaClassLoader) {
                classLoader = ClassLoaderConfiguratorKt.access$configureUsingIdeaClassloader(mainInfo.files, module2);
            } else {
                IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray2 = dependencies;
                MainInfo mainInfo2 = mainInfo;
                classLoader = this.createPluginClassLoader(module2, ideaPluginDescriptorImplArray2, mainInfo2);
            }
            ClassLoader mainDependentClassLoader = classLoader;
            module2.setPluginClassLoader(mainDependentClassLoader);
            this.configureDependenciesInOldFormat(module2, mainDependentClassLoader);
            return;
        } else {
            if (module2.packagePrefix == null) {
                throw (Throwable)new PluginException("Package is not specified (module=" + module2 + ')', module2.getPluginId());
            }
            boolean files2 = module2.pluginDependencies.isEmpty();
            int n = 0;
            if (_Assertions.ENABLED && !files2) {
                boolean bl = false;
                String string2 = "Module " + module2 + " shouldn't have plugin dependencies: " + module2.pluginDependencies;
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            for (IdeaPluginDescriptorImpl dependency : dependencies) {
                if (dependency.getPluginClassLoader() != null) continue;
                return;
            }
            if (module2.useCoreClassLoader) {
                module2.setPluginClassLoader(this.coreLoader);
                return;
            }
            MainInfo mainInfo = this.mainToClassPath.get(module2.getPluginId());
            if (mainInfo == null) {
                if (!Intrinsics.areEqual((Object)module2.getPluginId(), (Object)PluginManagerCore.CORE_ID)) throw (Throwable)new PluginException("Cannot find containing plugin " + module2.getPluginId() + " for module " + module2.moduleName + ' ', module2.getPluginId());
                this.configureCorePluginModuleClassLoader(module2, dependencies);
                return;
            } else {
                module2.setPluginClassLoader(new PluginClassLoader(mainInfo.files, mainInfo.classPath, dependencies, module2, this.coreLoader, ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager(), module2.packagePrefix, mainInfo.libDirectories));
            }
        }
    }

    private final void configureDependenciesInOldFormat(IdeaPluginDescriptorImpl module2, ClassLoader mainDependentClassLoader) {
        for (PluginDependency dependency : module2.pluginDependencies) {
            IdeaPluginDescriptorImpl subDescriptor;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl;
            if (dependency.subDescriptor == null) {
                continue;
            }
            if (this.pluginSet.findEnabledPlugin(dependency.getPluginId()) != null) {
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl2;
                boolean bl = false;
                boolean bl2 = false;
                IdeaPluginDescriptorImpl it = ideaPluginDescriptorImpl2;
                boolean bl3 = false;
                ideaPluginDescriptorImpl = it != module2 ? ideaPluginDescriptorImpl2 : null;
            } else {
                ideaPluginDescriptorImpl = null;
            }
            if (ideaPluginDescriptorImpl == null) continue;
            subDescriptor.setPluginClassLoader(mainDependentClassLoader);
            this.configureDependenciesInOldFormat(subDescriptor, mainDependentClassLoader);
        }
    }

    private final void configureCorePluginModuleClassLoader(IdeaPluginDescriptorImpl module2, IdeaPluginDescriptorImpl[] deps) {
        UrlClassLoader coreUrlClassLoader = this.getCoreUrlClassLoaderIfPossible(module2);
        if (coreUrlClassLoader == null) {
            this.setPluginClassLoaderForModuleAndOldSubDescriptors(module2, this.coreLoader);
            return;
        }
        module2.setPluginClassLoader(new PluginClassLoader(Collections.emptyList(), coreUrlClassLoader.getClassPath(), deps, module2, this.coreLoader, ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager(), module2.packagePrefix, new ArrayList()));
    }

    private final UrlClassLoader getCoreUrlClassLoaderIfPossible(IdeaPluginDescriptorImpl module2) {
        UrlClassLoader coreUrlClassLoader;
        ClassLoader classLoader = this.coreLoader;
        if (!(classLoader instanceof UrlClassLoader)) {
            classLoader = null;
        }
        if ((coreUrlClassLoader = (UrlClassLoader)classLoader) == null) {
            if (!Boolean.getBoolean("idea.use.core.classloader.for.plugin.path")) {
                ClassLoaderConfiguratorKt.access$getLog$p().error("You should run JVM with -Djava.system.class.loader=com.intellij.util.lang.PathClassLoader");
            }
            this.setPluginClassLoaderForModuleAndOldSubDescriptors(module2, this.coreLoader);
            return null;
        }
        if (coreUrlClassLoader.resolveScopeManager == null) {
            IdeaPluginDescriptorImpl corePlugin = (IdeaPluginDescriptorImpl)CollectionsKt.first(this.pluginSet.enabledPlugins);
            boolean bl = Intrinsics.areEqual((Object)corePlugin.getPluginId(), (Object)PluginManagerCore.CORE_ID);
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            PluginClassLoader.ResolveScopeManager resolveScopeManager = ClassLoaderConfiguratorKt.access$createPluginDependencyAndContentBasedScope(corePlugin, this.pluginSet);
            if (resolveScopeManager != null) {
                coreUrlClassLoader.resolveScopeManager = new BiPredicate(resolveScopeManager){
                    final /* synthetic */ PluginClassLoader.ResolveScopeManager $resolveScopeManager;

                    public final boolean test(String name2, Boolean force) {
                        Boolean bl = force;
                        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"force");
                        return this.$resolveScopeManager.isDefinitelyAlienClass(name2, "", bl) != null;
                    }
                    {
                        this.$resolveScopeManager = resolveScopeManager;
                    }
                };
            }
        }
        return coreUrlClassLoader;
    }

    private final void setPluginClassLoaderForModuleAndOldSubDescriptors(IdeaPluginDescriptorImpl rootDescriptor, ClassLoader classLoader) {
        rootDescriptor.setPluginClassLoader(classLoader);
        for (PluginDependency dependency : rootDescriptor.pluginDependencies) {
            IdeaPluginDescriptorImpl subDescriptor = dependency.subDescriptor;
            if (subDescriptor == null || !this.pluginSet.isPluginEnabled(dependency.getPluginId())) continue;
            this.setPluginClassLoaderForModuleAndOldSubDescriptors(subDescriptor, classLoader);
        }
    }

    private final void checkPackagePrefixUniqueness(IdeaPluginDescriptorImpl module2) {
        IdeaPluginDescriptorImpl old;
        String packagePrefix = module2.packagePrefix;
        if (packagePrefix != null && (old = this.pluginPackagePrefixUniqueGuard.putIfAbsent(packagePrefix, module2)) != null) {
            throw (Throwable)new PluginException("Package prefix " + packagePrefix + " is already used (second=" + module2 + ", first=" + old + ')', module2.getPluginId());
        }
    }

    private final PluginClassLoader createPluginClassLoader(IdeaPluginDescriptorImpl module2, IdeaPluginDescriptorImpl[] dependencies, MainInfo mainInfo) {
        PluginClassLoader.ResolveScopeManager resolveScopeManager = null;
        if (module2.moduleName == null) {
            PluginClassLoader.ResolveScopeManager resolveScopeManager2;
            switch (module2.getPluginId().getIdString()) {
                case "ksp.com.intellij.diagram": {
                    resolveScopeManager2 = ClassLoaderConfiguratorKt.access$createScopeWithExtraPackage("ksp.com.intellij.diagram.");
                    break;
                }
                case "ksp.com.intellij.struts2": {
                    resolveScopeManager2 = ClassLoaderConfiguratorKt.access$createScopeWithExtraPackage("ksp.com.intellij.lang.ognl.");
                    break;
                }
                case "ksp.com.intellij.properties": {
                    resolveScopeManager2 = createPluginClassLoader.1.INSTANCE;
                    break;
                }
                default: {
                    resolveScopeManager2 = ClassLoaderConfiguratorKt.access$createPluginDependencyAndContentBasedScope(module2, this.pluginSet);
                }
            }
            resolveScopeManager = resolveScopeManager2;
        } else {
            resolveScopeManager = module2.content.modules.isEmpty() ? ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager() : ClassLoaderConfiguratorKt.access$createModuleContentBasedScope(module2);
        }
        return new PluginClassLoader(mainInfo.files, mainInfo.classPath, dependencies, module2, this.coreLoader, resolveScopeManager, module2.packagePrefix, mainInfo.libDirectories);
    }

    @NotNull
    public final PluginSet getPluginSet() {
        return this.pluginSet;
    }

    /*
     * WARNING - void declaration
     */
    public ClassLoaderConfigurator(@NotNull PluginSet pluginSet, @NotNull ClassLoader coreLoader) {
        Function function2;
        ClassLoaderConfigurator classLoaderConfigurator;
        Intrinsics.checkNotNullParameter((Object)pluginSet, (String)"pluginSet");
        Intrinsics.checkNotNullParameter((Object)coreLoader, (String)"coreLoader");
        this.pluginSet = pluginSet;
        this.coreLoader = coreLoader;
        this.pluginPackagePrefixUniqueGuard = new HashMap();
        this.mainToClassPath = new IdentityHashMap();
        ClassLoaderConfigurator classLoaderConfigurator2 = this;
        try {
            classLoaderConfigurator = classLoaderConfigurator2;
            Function function3 = MethodHandles.lookup().findStatic(this.coreLoader.loadClass("ksp.com.intellij.util.lang.PathClassLoader"), "getResourceFileFactory", MethodType.methodType(Function.class)).invokeExact();
            if (function3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.util.function.Function<java.nio.file.Path, com.intellij.util.lang.ResourceFile>");
            }
            function2 = function3;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classLoaderConfigurator = classLoaderConfigurator2;
            function2 = null;
        }
        catch (Throwable ignore) {
            void e;
            classLoaderConfigurator = classLoaderConfigurator2;
            ClassLoaderConfiguratorKt.access$getLog$p().error((Throwable)e);
            function2 = null;
        }
        classLoaderConfigurator.resourceFileFactory = function2;
    }

    public /* synthetic */ ClassLoaderConfigurator(PluginSet pluginSet, ClassLoader classLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ClassLoader classLoader2 = ClassLoaderConfigurator.class.getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"ClassLoaderConfigurator::class.java.classLoader");
            classLoader = classLoader2;
        }
        this(pluginSet, classLoader);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nR\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lksp/com/intellij/ide/plugins/ClassLoaderConfigurator$MainInfo;", "", "classPath", "Lksp/com/intellij/util/lang/ClassPath;", "files", "", "Ljava/nio/file/Path;", "libDirectories", "", "", "(Lcom/intellij/util/lang/ClassPath;Ljava/util/List;Ljava/util/List;)V", "intellij.platform.core.impl"})
    private static final class MainInfo {
        @JvmField
        @NotNull
        public final ClassPath classPath;
        @JvmField
        @NotNull
        public final List<Path> files;
        @JvmField
        @NotNull
        public final List<String> libDirectories;

        public MainInfo(@NotNull ClassPath classPath2, @NotNull List<? extends Path> files2, @NotNull List<String> libDirectories) {
            Intrinsics.checkNotNullParameter((Object)classPath2, (String)"classPath");
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            Intrinsics.checkNotNullParameter(libDirectories, (String)"libDirectories");
            this.classPath = classPath2;
            this.files = files2;
            this.libDirectories = libDirectories;
        }
    }
}

