/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.JvmAnalysisFlags;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtClass;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtModifierList;
import ksp.org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import ksp.org.jetbrains.kotlin.psi.KtNamedFunction;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;
import ksp.org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/checkers/SuspendInFunInterfaceChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class SuspendInFunInterfaceChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(declaration2 instanceof KtClass)) {
            return;
        }
        if (!(descriptor instanceof ClassDescriptor) || !((ClassDescriptor)descriptor).isFun()) {
            return;
        }
        PsiElement psiElement = ((KtClass)declaration2).getFunKeyword();
        if (psiElement == null) {
            return;
        }
        PsiElement funKeyword = psiElement;
        FunctionDescriptor functionDescriptor = SamConversionResolverImplKt.getSingleAbstractMethodOrNull((ClassDescriptor)descriptor);
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor abstractMember = functionDescriptor;
        if (!abstractMember.isSuspend()) {
            return;
        }
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.SuspendFunctionsInFunInterfaces) && context2.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getUseIR()).booleanValue()) {
            return;
        }
        SourceElement sourceElement = abstractMember.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
        PsiElement psiElement2 = PsiSourceElementKt.getPsi(sourceElement);
        KtNamedFunction ktFunction = psiElement2 instanceof KtNamedFunction ? (KtNamedFunction)psiElement2 : null;
        PsiElement psiElement3 = ktFunction;
        if (psiElement3 == null || (psiElement3 = ((KtModifierListOwnerStub)psiElement3).getModifierList()) == null || (psiElement3 = ((KtModifierList)psiElement3).getModifier(KtTokens.SUSPEND_KEYWORD)) == null) {
            psiElement3 = funKeyword;
        }
        PsiElement reportOn = psiElement3;
        context2.getTrace().report(Errors.FUN_INTERFACE_WITH_SUSPEND_FUNCTION.on(reportOn));
    }
}

