/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtNamedDeclaration;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/checkers/FunctionDelegateMemberNameClashChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class FunctionDelegateMemberNameClashChecker
implements DeclarationChecker {
    @NotNull
    public static final FunctionDelegateMemberNameClashChecker INSTANCE = new FunctionDelegateMemberNameClashChecker();

    private FunctionDelegateMemberNameClashChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                if (!(descriptor instanceof CallableMemberDescriptor)) {
                    return;
                }
                DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
                DeclarationDescriptor container = declarationDescriptor;
                if (!(container instanceof ClassDescriptor) || !((ClassDescriptor)container).isFun()) {
                    return;
                }
                if (((CallableMemberDescriptor)descriptor).getExtensionReceiverParameter() != null) break block7;
                List<ValueParameterDescriptor> list = ((CallableMemberDescriptor)descriptor).getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
                if (!(!((Collection)list).isEmpty())) break block8;
            }
            return;
        }
        if (descriptor instanceof FunctionDescriptor && Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor).getName().asString(), (Object)"getFunctionDelegate") || descriptor instanceof PropertyDescriptor && Intrinsics.areEqual((Object)((PropertyDescriptor)descriptor).getName().asString(), (Object)"functionDelegate")) {
            PsiElement psiElement = declaration2 instanceof KtNamedDeclaration ? (KtNamedDeclaration)declaration2 : null;
            if (psiElement == null || (psiElement = psiElement.getNameIdentifier()) == null) {
                psiElement = declaration2;
            }
            PsiElement reportOn = psiElement;
            context2.getTrace().report(ErrorsJvm.FUNCTION_DELEGATE_MEMBER_NAME_CLASH.on(reportOn));
        }
    }
}

