/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import ksp.org.jetbrains.kotlin.resolve.calls.components.ReceiverInfo;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.model.ArgumentConstraintPositionImpl;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintPosition;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.model.ReceiverConstraintPositionImpl;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ArgumentNullabilityErrorDiagnostic;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ExpressionKotlinCallArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.KotlinCall;
import ksp.org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import ksp.org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtomsKt;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedExpressionAtom;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedSubCallArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.SubKotlinCallArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.UnsafeCallError;
import ksp.org.jetbrains.kotlin.resolve.calls.model.UnstableSmartCast;
import ksp.org.jetbrains.kotlin.types.FlexibleTypesKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.NotNullTypeParameter;
import ksp.org.jetbrains.kotlin.types.SpecialTypesKt;
import ksp.org.jetbrains.kotlin.types.TypeConstructor;
import ksp.org.jetbrains.kotlin.types.UnwrappedType;
import ksp.org.jetbrains.kotlin.types.checker.NewCapturedTypeKt;
import ksp.org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerKt;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001aN\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001aF\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u001a\u0016\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007\u001a<\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a8\u0006\u001b"}, d2={"checkSimpleArgument", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "csBuilder", "Lksp/org/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "argument", "Lksp/org/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;", "expectedType", "Lksp/org/jetbrains/kotlin/types/UnwrappedType;", "diagnosticsHolder", "Lksp/org/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "receiverInfo", "Lksp/org/jetbrains/kotlin/resolve/calls/components/ReceiverInfo;", "convertedType", "inferenceSession", "Lksp/org/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "selectorCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/KotlinCall;", "checkExpressionArgument", "expressionArgument", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ExpressionKotlinCallArgument;", "isReceiver", "", "captureFromTypeParameterUpperBoundIfNeeded", "argumentType", "checkSubCallArgument", "subCallArgument", "Lksp/org/jetbrains/kotlin/resolve/calls/model/SubKotlinCallArgument;", "resolution"})
@SourceDebugExtension(value={"SMAP\nSimpleArgumentsChecks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleArgumentsChecks.kt\norg/jetbrains/kotlin/resolve/calls/components/SimpleArgumentsChecksKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n669#2,11:230\n*S KotlinDebug\n*F\n+ 1 SimpleArgumentsChecks.kt\norg/jetbrains/kotlin/resolve/calls/components/SimpleArgumentsChecksKt\n*L\n168#1:230,11\n*E\n"})
public final class SimpleArgumentsChecksKt {
    @NotNull
    public static final ResolvedAtom checkSimpleArgument(@NotNull ConstraintSystemBuilder csBuilder, @NotNull SimpleKotlinCallArgument argument, @Nullable UnwrappedType expectedType, @NotNull KotlinDiagnosticsHolder diagnosticsHolder, @NotNull ReceiverInfo receiverInfo, @Nullable UnwrappedType convertedType, @Nullable InferenceSession inferenceSession, @Nullable KotlinCall selectorCall) {
        ResolvedAtom resolvedAtom;
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)diagnosticsHolder, (String)"diagnosticsHolder");
        Intrinsics.checkNotNullParameter((Object)receiverInfo, (String)"receiverInfo");
        SimpleKotlinCallArgument simpleKotlinCallArgument = argument;
        if (simpleKotlinCallArgument instanceof ExpressionKotlinCallArgument) {
            resolvedAtom = SimpleArgumentsChecksKt.checkExpressionArgument(csBuilder, (ExpressionKotlinCallArgument)argument, expectedType, diagnosticsHolder, receiverInfo.isReceiver(), convertedType, selectorCall);
        } else if (simpleKotlinCallArgument instanceof SubKotlinCallArgument) {
            resolvedAtom = SimpleArgumentsChecksKt.checkSubCallArgument(csBuilder, (SubKotlinCallArgument)argument, expectedType, diagnosticsHolder, receiverInfo, inferenceSession);
        } else {
            ArgumentsUtilsKt.unexpectedArgument(argument);
            throw null;
        }
        return resolvedAtom;
    }

    private static final ResolvedAtom checkExpressionArgument(ConstraintSystemBuilder csBuilder, ExpressionKotlinCallArgument expressionArgument, UnwrappedType expectedType, KotlinDiagnosticsHolder diagnosticsHolder, boolean isReceiver, UnwrappedType convertedType, KotlinCall selectorCall) {
        ConstraintPosition position;
        ResolvedExpressionAtom resolvedExpression = new ResolvedExpressionAtom(expressionArgument);
        if (expectedType == null) {
            return resolvedExpression;
        }
        UnwrappedType unwrappedType = convertedType;
        if (unwrappedType == null) {
            unwrappedType = SimpleArgumentsChecksKt.captureFromTypeParameterUpperBoundIfNeeded(ArgumentsUtilsKt.getStableType(expressionArgument.getReceiver()), expectedType);
        }
        UnwrappedType argumentType = unwrappedType;
        ConstraintPosition constraintPosition = position = isReceiver ? new ReceiverConstraintPositionImpl(expressionArgument, selectorCall) : new ArgumentConstraintPositionImpl(expressionArgument);
        if (expectedType instanceof NotNullTypeParameter && argumentType.isMarkedNullable()) {
            diagnosticsHolder.addDiagnostic(new ArgumentNullabilityErrorDiagnostic(expectedType, argumentType, expressionArgument));
        }
        if (expressionArgument.isSafeCall()) {
            UnwrappedType expectedNullableType = expectedType.makeNullableAsSpecified(true);
            if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedNullableType, position)) {
                ResolvedCallAtomsKt.addDiagnosticIfNotNull(diagnosticsHolder, SimpleArgumentsChecksKt.checkExpressionArgument$unstableSmartCastOrSubtypeError(csBuilder, expressionArgument, isReceiver, argumentType, ArgumentsUtilsKt.getUnstableType(expressionArgument.getReceiver()), expectedNullableType, position));
            }
            return resolvedExpression;
        }
        if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedType, position)) {
            if (!isReceiver) {
                ResolvedCallAtomsKt.addDiagnosticIfNotNull(diagnosticsHolder, SimpleArgumentsChecksKt.checkExpressionArgument$unstableSmartCastOrSubtypeError(csBuilder, expressionArgument, isReceiver, argumentType, ArgumentsUtilsKt.getUnstableType(expressionArgument.getReceiver()), expectedType, position));
                return resolvedExpression;
            }
            UnwrappedType unstableType = ArgumentsUtilsKt.getUnstableType(expressionArgument.getReceiver());
            UnwrappedType expectedNullableType = expectedType.makeNullableAsSpecified(true);
            if (unstableType != null && ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, unstableType, expectedType, position)) {
                diagnosticsHolder.addDiagnostic(UnstableSmartCast.Companion.invoke(expressionArgument, unstableType, isReceiver));
            } else if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedNullableType, position)) {
                diagnosticsHolder.addDiagnostic(new UnsafeCallError(expressionArgument, false, 2, null));
            } else {
                csBuilder.addSubtypeConstraint(argumentType, expectedType, position);
            }
        }
        return resolvedExpression;
    }

    @NotNull
    public static final UnwrappedType captureFromTypeParameterUpperBoundIfNeeded(@NotNull UnwrappedType argumentType, @NotNull UnwrappedType expectedType) {
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        TypeConstructor expectedTypeConstructor = FlexibleTypesKt.upperIfFlexible(expectedType).getConstructor();
        if (FlexibleTypesKt.lowerIfFlexible(argumentType).getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            Object v0;
            block7: {
                Iterable $this$singleOrNull$iv = TypeUtilsKt.supertypes(FlexibleTypesKt.lowerIfFlexible(argumentType));
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl = false;
                    if (!(it.getConstructor().getDeclarationDescriptor() instanceof ClassifierDescriptorWithTypeParameters && NewKotlinTypeCheckerKt.hasSupertypeWithGivenTypeConstructor(it.unwrap(), expectedTypeConstructor))) continue;
                    if (found$iv) {
                        v0 = null;
                        break block7;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            KotlinType chosenSupertype = v0;
            if (chosenSupertype != null) {
                UnwrappedType unwrappedType;
                UnwrappedType capturedType = NewCapturedTypeKt.captureFromExpression(chosenSupertype.unwrap());
                if (capturedType != null && SpecialTypesKt.isDefinitelyNotNullType(argumentType)) {
                    unwrappedType = SpecialTypesKt.makeDefinitelyNotNullOrNotNull$default(capturedType, false, 1, null);
                } else {
                    unwrappedType = capturedType;
                    if (unwrappedType == null) {
                        unwrappedType = argumentType;
                    }
                }
                return unwrappedType;
            }
        }
        return argumentType;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final ResolvedAtom checkSubCallArgument(ConstraintSystemBuilder csBuilder, SubKotlinCallArgument subCallArgument, UnwrappedType expectedType, KotlinDiagnosticsHolder diagnosticsHolder, ReceiverInfo receiverInfo, InferenceSession inferenceSession) {
        if (!receiverInfo.isReceiver()) ** GOTO lbl-1000
        v0 = inferenceSession;
        v1 = v0 != null ? v0.resolveReceiverIndependently() : false;
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        subCallResult = new ResolvedSubCallArgument(subCallArgument, v2);
        if (expectedType == null) {
            return subCallResult;
        }
        expectedNullableType = expectedType.makeNullableAsSpecified(true);
        position /* !! */  = receiverInfo.isReceiver() != false ? new ReceiverConstraintPositionImpl(subCallArgument, subCallArgument.getCallResult().getResultCallAtom().getAtom()) : new ArgumentConstraintPositionImpl(subCallArgument);
        v3 = csBuilder.buildCurrentSubstitutor();
        Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor");
        currentReturnType = ((NewTypeSubstitutor)v3).safeSubstitute(subCallArgument.getReceiver().getReceiverValue().getType().unwrap());
        if (subCallArgument.isSafeCall()) {
            csBuilder.addSubtypeConstraint(currentReturnType, expectedNullableType, position /* !! */ );
            return subCallResult;
        }
        if (receiverInfo.isReceiver() && !ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, currentReturnType, expectedType, position /* !! */ ) && ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, currentReturnType, expectedNullableType, position /* !! */ )) {
            if (receiverInfo.getShouldReportUnsafeCall()) {
                diagnosticsHolder.addDiagnostic(new UnsafeCallError(subCallArgument, receiverInfo.getReportUnsafeCallAsUnsafeImplicitInvoke()));
            }
            return subCallResult;
        }
        csBuilder.addSubtypeConstraint(currentReturnType, expectedType, position /* !! */ );
        return subCallResult;
    }

    private static final KotlinCallDiagnostic checkExpressionArgument$unstableSmartCastOrSubtypeError(ConstraintSystemBuilder $csBuilder, ExpressionKotlinCallArgument $expressionArgument, boolean $isReceiver, UnwrappedType argumentType, UnwrappedType unstableType, UnwrappedType actualExpectedType, ConstraintPosition position) {
        if (unstableType != null && ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible($csBuilder, unstableType, actualExpectedType, position)) {
            return UnstableSmartCast.Companion.invoke($expressionArgument, unstableType, $isReceiver);
        }
        if (argumentType.isMarkedNullable()) {
            if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible($csBuilder, argumentType, actualExpectedType, position)) {
                return null;
            }
            if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible($csBuilder, TypeUtilsKt.makeNotNullable(argumentType), actualExpectedType, position)) {
                return new ArgumentNullabilityErrorDiagnostic(actualExpectedType, argumentType, $expressionArgument);
            }
        }
        $csBuilder.addSubtypeConstraint(argumentType, actualExpectedType, position);
        return null;
    }
}

