/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.utils;

import java.util.List;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import ksp.org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import ksp.org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtOperationExpression;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.psi.KtPureClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtReferenceExpression;
import ksp.org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import ksp.org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import ksp.org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import ksp.org.jetbrains.kotlin.psi.KtTypeReference;
import ksp.org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptorKt;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingContextUtils;
import ksp.org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import ksp.org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForTypeAliasObject;
import ksp.org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import ksp.org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.TypeUtils;

public final class BindingUtils {
    private BindingUtils() {
    }

    @NotNull
    private static <E extends PsiElement, D extends DeclarationDescriptor> D getDescriptorForExpression(@NotNull BindingContext context2, @NotNull E expression2, Class<D> descriptorClass) {
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(0);
        }
        if (expression2 == null) {
            BindingUtils.$$$reportNull$$$0(1);
        }
        DeclarationDescriptor descriptor = context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, expression2);
        assert (descriptor != null);
        assert (descriptorClass.isInstance(descriptor)) : ErrorReportingUtils.message(expression2, expression2.toString() + " expected to have of type" + descriptorClass.toString());
        DeclarationDescriptor declarationDescriptor = descriptor;
        if (declarationDescriptor == null) {
            BindingUtils.$$$reportNull$$$0(2);
        }
        return (D)declarationDescriptor;
    }

    @NotNull
    public static ClassDescriptor getClassDescriptor(@NotNull BindingContext context2, @NotNull KtPureClassOrObject declaration2) {
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(3);
        }
        if (declaration2 == null) {
            BindingUtils.$$$reportNull$$$0(4);
        }
        ClassDescriptor classDescriptor = SyntheticClassOrObjectDescriptorKt.findClassDescriptor(declaration2, context2);
        if (classDescriptor == null) {
            BindingUtils.$$$reportNull$$$0(5);
        }
        return classDescriptor;
    }

    @NotNull
    public static FunctionDescriptor getFunctionDescriptor(@NotNull BindingContext context2, @NotNull KtDeclarationWithBody declaration2) {
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(6);
        }
        if (declaration2 == null) {
            BindingUtils.$$$reportNull$$$0(7);
        }
        return BindingUtils.getDescriptorForExpression(context2, declaration2, FunctionDescriptor.class);
    }

    @NotNull
    public static PropertyDescriptor getPropertyDescriptor(@NotNull BindingContext context2, @NotNull KtProperty declaration2) {
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(8);
        }
        if (declaration2 == null) {
            BindingUtils.$$$reportNull$$$0(9);
        }
        return BindingUtils.getDescriptorForExpression(context2, declaration2, PropertyDescriptor.class);
    }

    @NotNull
    private static KtParameter getParameterForDescriptor(@NotNull ValueParameterDescriptor descriptor) {
        if (descriptor == null) {
            BindingUtils.$$$reportNull$$$0(10);
        }
        PsiElement result2 = DescriptorToSourceUtils.descriptorToDeclaration(descriptor);
        assert (result2 instanceof KtParameter) : ErrorReportingUtils.message(descriptor, "ValueParameterDescriptor should have corresponding KtParameter");
        KtParameter ktParameter = (KtParameter)result2;
        if (ktParameter == null) {
            BindingUtils.$$$reportNull$$$0(11);
        }
        return ktParameter;
    }

    public static boolean hasAncestorClass(@NotNull BindingContext context2, @NotNull KtPureClassOrObject classDeclaration) {
        ClassDescriptor classDescriptor;
        List<ClassDescriptor> superclassDescriptors;
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(12);
        }
        if (classDeclaration == null) {
            BindingUtils.$$$reportNull$$$0(13);
        }
        return JsDescriptorUtils.findAncestorClass(superclassDescriptors = DescriptorUtils.getSuperclassDescriptors(classDescriptor = BindingUtils.getClassDescriptor(context2, classDeclaration))) != null;
    }

    @NotNull
    public static KotlinType getTypeByReference(@NotNull BindingContext context2, @NotNull KtTypeReference typeReference) {
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(14);
        }
        if (typeReference == null) {
            BindingUtils.$$$reportNull$$$0(15);
        }
        KotlinType kotlinType = BindingContextUtils.getNotNull(context2, BindingContext.TYPE, typeReference);
        if (kotlinType == null) {
            BindingUtils.$$$reportNull$$$0(16);
        }
        return kotlinType;
    }

    @Nullable
    public static PropertyDescriptor getPropertyDescriptorForConstructorParameter(@NotNull BindingContext context2, @NotNull KtParameter parameter2) {
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(17);
        }
        if (parameter2 == null) {
            BindingUtils.$$$reportNull$$$0(18);
        }
        return context2.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter2);
    }

    @Nullable
    public static DeclarationDescriptor getDescriptorForReferenceExpression(@NotNull BindingContext context2, @NotNull KtReferenceExpression reference2) {
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(19);
        }
        if (reference2 == null) {
            BindingUtils.$$$reportNull$$$0(20);
        }
        if (BindingContextUtils.isExpressionWithValidReference(reference2, context2)) {
            return BindingUtils.resolveObjectViaTypeAlias(BindingContextUtils.getNotNull(context2, BindingContext.REFERENCE_TARGET, reference2));
        }
        return null;
    }

    @Nullable
    private static DeclarationDescriptor getNullableDescriptorForReferenceExpression(@NotNull BindingContext context2, @NotNull KtReferenceExpression reference2) {
        DeclarationDescriptor descriptor;
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(21);
        }
        if (reference2 == null) {
            BindingUtils.$$$reportNull$$$0(22);
        }
        return (descriptor = context2.get(BindingContext.REFERENCE_TARGET, reference2)) != null ? BindingUtils.resolveObjectViaTypeAlias(descriptor) : null;
    }

    @NotNull
    private static DeclarationDescriptor resolveObjectViaTypeAlias(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            BindingUtils.$$$reportNull$$$0(23);
        }
        if (descriptor instanceof TypeAliasDescriptor) {
            ClassDescriptor classDescriptor = ((TypeAliasDescriptor)descriptor).getClassDescriptor();
            assert (classDescriptor != null) : "Class descriptor must be non-null in resolved typealias: " + descriptor;
            if (classDescriptor.getKind() != ClassKind.OBJECT && classDescriptor.getKind() != ClassKind.ENUM_CLASS) {
                classDescriptor = classDescriptor.getCompanionObjectDescriptor();
                assert (classDescriptor != null) : "Resolved typealias must have non-null class descriptor: " + descriptor;
            }
            ClassDescriptor classDescriptor2 = classDescriptor;
            if (classDescriptor2 == null) {
                BindingUtils.$$$reportNull$$$0(24);
            }
            return classDescriptor2;
        }
        if (descriptor instanceof FakeCallableDescriptorForTypeAliasObject) {
            ClassDescriptor classDescriptor = ((FakeCallableDescriptorForTypeAliasObject)descriptor).getReferencedObject();
            if (classDescriptor == null) {
                BindingUtils.$$$reportNull$$$0(25);
            }
            return classDescriptor;
        }
        DeclarationDescriptor declarationDescriptor = descriptor;
        if (declarationDescriptor == null) {
            BindingUtils.$$$reportNull$$$0(26);
        }
        return declarationDescriptor;
    }

    public static boolean isVariableReassignment(@NotNull BindingContext context2, @NotNull KtExpression expression2) {
        Boolean result2;
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(27);
        }
        if (expression2 == null) {
            BindingUtils.$$$reportNull$$$0(28);
        }
        return (result2 = context2.get(BindingContext.VARIABLE_REASSIGNMENT, expression2)) != null ? result2 : false;
    }

    @Nullable
    public static CallableDescriptor getCallableDescriptorForOperationExpression(@NotNull BindingContext context2, @NotNull KtOperationExpression expression2) {
        KtSimpleNameExpression operationReference;
        DeclarationDescriptor descriptorForReferenceExpression;
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(29);
        }
        if (expression2 == null) {
            BindingUtils.$$$reportNull$$$0(30);
        }
        if ((descriptorForReferenceExpression = BindingUtils.getNullableDescriptorForReferenceExpression(context2, operationReference = expression2.getOperationReference())) == null) {
            return null;
        }
        assert (descriptorForReferenceExpression instanceof CallableDescriptor) : ErrorReportingUtils.message(operationReference, "Operation should resolve to callable descriptor");
        return (CallableDescriptor)descriptorForReferenceExpression;
    }

    @NotNull
    public static DeclarationDescriptor getDescriptorForElement(@NotNull BindingContext context2, @NotNull PsiElement element2) {
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(31);
        }
        if (element2 == null) {
            BindingUtils.$$$reportNull$$$0(32);
        }
        DeclarationDescriptor declarationDescriptor = BindingContextUtils.getNotNull(context2, BindingContext.DECLARATION_TO_DESCRIPTOR, element2);
        if (declarationDescriptor == null) {
            BindingUtils.$$$reportNull$$$0(33);
        }
        return declarationDescriptor;
    }

    @Nullable
    public static Object getCompileTimeValue(@NotNull BindingContext context2, @NotNull KtExpression expression2) {
        CompileTimeConstant<?> compileTimeValue;
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(34);
        }
        if (expression2 == null) {
            BindingUtils.$$$reportNull$$$0(35);
        }
        if ((compileTimeValue = ConstantExpressionEvaluator.getConstant(expression2, context2)) != null) {
            return BindingUtils.getCompileTimeValue(context2, expression2, compileTimeValue);
        }
        return null;
    }

    @Nullable
    public static Object getCompileTimeValue(@NotNull BindingContext context2, @NotNull KtExpression expression2, @NotNull CompileTimeConstant<?> constant) {
        KotlinType expectedType;
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(36);
        }
        if (expression2 == null) {
            BindingUtils.$$$reportNull$$$0(37);
        }
        if (constant == null) {
            BindingUtils.$$$reportNull$$$0(38);
        }
        return constant.getValue((expectedType = context2.getType(expression2)) == null ? TypeUtils.NO_EXPECTED_TYPE : expectedType);
    }

    @NotNull
    public static KtExpression getDefaultArgument(@NotNull ValueParameterDescriptor parameterDescriptor) {
        if (parameterDescriptor == null) {
            BindingUtils.$$$reportNull$$$0(39);
        }
        KtParameter psiParameter = BindingUtils.getParameterForDescriptor(parameterDescriptor);
        KtExpression defaultValue = psiParameter.getDefaultValue();
        assert (defaultValue != null) : ErrorReportingUtils.message(parameterDescriptor, "No default value found in PSI");
        KtExpression ktExpression = defaultValue;
        if (ktExpression == null) {
            BindingUtils.$$$reportNull$$$0(40);
        }
        return ktExpression;
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getIteratorFunction(@NotNull BindingContext context2, @NotNull KtExpression rangeExpression) {
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(41);
        }
        if (rangeExpression == null) {
            BindingUtils.$$$reportNull$$$0(42);
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingContextUtils.getNotNull(context2, BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, rangeExpression);
        if (resolvedCall2 == null) {
            BindingUtils.$$$reportNull$$$0(43);
        }
        return resolvedCall2;
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getNextFunction(@NotNull BindingContext context2, @NotNull KtExpression rangeExpression) {
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(44);
        }
        if (rangeExpression == null) {
            BindingUtils.$$$reportNull$$$0(45);
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingContextUtils.getNotNull(context2, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, rangeExpression);
        if (resolvedCall2 == null) {
            BindingUtils.$$$reportNull$$$0(46);
        }
        return resolvedCall2;
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getHasNextCallable(@NotNull BindingContext context2, @NotNull KtExpression rangeExpression) {
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(47);
        }
        if (rangeExpression == null) {
            BindingUtils.$$$reportNull$$$0(48);
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingContextUtils.getNotNull(context2, BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, rangeExpression);
        if (resolvedCall2 == null) {
            BindingUtils.$$$reportNull$$$0(49);
        }
        return resolvedCall2;
    }

    @NotNull
    public static KotlinType getTypeForExpression(@NotNull BindingContext context2, @NotNull KtExpression expression2) {
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(50);
        }
        if (expression2 == null) {
            BindingUtils.$$$reportNull$$$0(51);
        }
        KotlinType kotlinType = BindingContextUtils.getTypeNotNull(context2, expression2);
        if (kotlinType == null) {
            BindingUtils.$$$reportNull$$$0(52);
        }
        return kotlinType;
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getResolvedCallForArrayAccess(@NotNull BindingContext context2, @NotNull KtArrayAccessExpression arrayAccessExpression, boolean isGet) {
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(53);
        }
        if (arrayAccessExpression == null) {
            BindingUtils.$$$reportNull$$$0(54);
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingContextUtils.getNotNull(context2, isGet ? BindingContext.INDEXED_LVALUE_GET : BindingContext.INDEXED_LVALUE_SET, arrayAccessExpression);
        if (resolvedCall2 == null) {
            BindingUtils.$$$reportNull$$$0(55);
        }
        return resolvedCall2;
    }

    @Nullable
    public static ResolvedCall<FunctionDescriptor> getSuperCall(@NotNull BindingContext context2, KtPureClassOrObject classDeclaration) {
        if (context2 == null) {
            BindingUtils.$$$reportNull$$$0(56);
        }
        for (KtSuperTypeListEntry specifier : classDeclaration.getSuperTypeListEntries()) {
            if (!(specifier instanceof KtSuperTypeCallEntry)) continue;
            KtSuperTypeCallEntry superCall = (KtSuperTypeCallEntry)specifier;
            return CallUtilKt.getResolvedCallWithAssert(superCall, context2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 16: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 40: 
            case 43: 
            case 46: 
            case 49: 
            case 52: 
            case 55: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 16: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 40: 
            case 43: 
            case 46: 
            case 49: 
            case 52: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 28: 
            case 30: 
            case 35: 
            case 37: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 16: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 40: 
            case 43: 
            case 46: 
            case 49: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/js/translate/utils/BindingUtils";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDeclaration";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeReference";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterDescriptor";
                break;
            }
            case 42: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeExpression";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/js/translate/utils/BindingUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorForExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDescriptor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterForDescriptor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeByReference";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveObjectViaTypeAlias";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorForElement";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultArgument";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getIteratorFunction";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextFunction";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getHasNextCallable";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeForExpression";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedCallForArrayAccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorForExpression";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 16: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 40: 
            case 43: 
            case 46: 
            case 49: 
            case 52: 
            case 55: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getClassDescriptor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionDescriptor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParameterForDescriptor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasAncestorClass";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTypeByReference";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescriptorForConstructorParameter";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorForReferenceExpression";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getNullableDescriptorForReferenceExpression";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveObjectViaTypeAlias";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isVariableReassignment";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getCallableDescriptorForOperationExpression";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorForElement";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getCompileTimeValue";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultArgument";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getIteratorFunction";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getNextFunction";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getHasNextCallable";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForExpression";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedCallForArrayAccess";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getSuperCall";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 16: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 40: 
            case 43: 
            case 46: 
            case 49: 
            case 52: 
            case 55: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

