/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.web.common.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.web.common.FirWebCommonErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirConstChecksKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import ksp.org.jetbrains.kotlin.name.CallableId;
import ksp.org.jetbrains.kotlin.name.WebCommonStandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/web/common/checkers/expression/FirJsCodeConstantArgumentChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "<init>", "()V", "jsCodeCallableId", "Lksp/org/jetbrains/kotlin/name/CallableId;", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.web.common"})
@SourceDebugExtension(value={"SMAP\nFirJsCodeConstantArgumentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsCodeConstantArgumentChecker.kt\norg/jetbrains/kotlin/fir/analysis/web/common/checkers/expression/FirJsCodeConstantArgumentChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,60:1\n43#2:61\n*S KotlinDebug\n*F\n+ 1 FirJsCodeConstantArgumentChecker.kt\norg/jetbrains/kotlin/fir/analysis/web/common/checkers/expression/FirJsCodeConstantArgumentChecker\n*L\n31#1:61\n*E\n"})
public final class FirJsCodeConstantArgumentChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirJsCodeConstantArgumentChecker INSTANCE = new FirJsCodeConstantArgumentChecker();
    @NotNull
    private static final CallableId jsCodeCallableId = WebCommonStandardClassIds.Callables.Js;

    private FirJsCodeConstantArgumentChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (!Intrinsics.areEqual((Object)(firCallableSymbol != null ? firCallableSymbol.getCallableId() : null), (Object)jsCodeCallableId)) {
            return;
        }
        FirCall $this$arguments$iv = expression2;
        boolean $i$f$getArguments = false;
        FirExpression jsCodeExpression = (FirExpression)CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments());
        if (jsCodeExpression == null || !ConeBuiltinTypeUtilsKt.isString(FirTypeUtilsKt.getResolvedType(jsCodeExpression))) {
            Object object = jsCodeExpression;
            if (object == null || (object = ((FirExpression)object).getSource()) == null) {
                object = expression2.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)object, FirWebCommonErrors.INSTANCE.getJSCODE_ARGUMENT_NON_CONST_EXPRESSION(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        jsCodeExpression.accept(new FirVisitorVoid(context2, jsCodeExpression, reporter){
            private FirElement lastReportedElement;
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ FirExpression $jsCodeExpression;
            final /* synthetic */ DiagnosticReporter $reporter;
            {
                this.$context = $context;
                this.$jsCodeExpression = $jsCodeExpression;
                this.$reporter = $reporter;
            }

            public final FirElement getLastReportedElement() {
                return this.lastReportedElement;
            }

            public final void setLastReportedElement(FirElement firElement) {
                this.lastReportedElement = firElement;
            }

            public void visitElement(FirElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                FirElement lastReported = this.lastReportedElement;
                element2.acceptChildren(this);
                if (Intrinsics.areEqual((Object)lastReported, (Object)this.lastReportedElement) && !FirConstChecksKt.canBeEvaluatedAtCompileTime(element2 instanceof FirExpression ? (FirExpression)element2 : null, this.$context.getSession(), true, true)) {
                    this.lastReportedElement = element2;
                    KtSourceElement ktSourceElement = element2.getSource();
                    if (ktSourceElement == null) {
                        ktSourceElement = this.$jsCodeExpression.getSource();
                    }
                    KtSourceElement source = ktSourceElement;
                    KtDiagnosticReportHelpersKt.reportOn$default(this.$reporter, (AbstractKtSourceElement)source, FirWebCommonErrors.INSTANCE.getJSCODE_ARGUMENT_NON_CONST_EXPRESSION(), (DiagnosticContext)this.$context, null, 8, null);
                }
            }

            public void visitPropertyAccessExpression(FirPropertyAccessExpression propertyAccessExpression) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
                FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(propertyAccessExpression.getCalleeReference(), false, 1, null);
                if (firCallableSymbol != null) {
                    FirCallableSymbol $this$isConst$iv = firCallableSymbol;
                    boolean $i$f$isConst = false;
                    bl = $this$isConst$iv.getRawStatus().isConst();
                } else {
                    bl = false;
                }
                if (!bl) {
                    super.visitPropertyAccessExpression(propertyAccessExpression);
                }
            }
        });
    }
}

